/*
 * Decompiled with CFR 0.152.
 */
package com.buwan.shizuku.jvm;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ClassOption {
    private static final Map<String, Map<String, Object>> CLASS_OPTIONS = new ConcurrentHashMap<String, Map<String, Object>>();
    private static final Map<String, ClassOption> INSTANCES = new ConcurrentHashMap<String, ClassOption>();
    private final String className;
    private final Map<String, Object> options;

    private ClassOption(String className) {
        this.className = className;
        this.options = new HashMap<String, Object>();
        CLASS_OPTIONS.putIfAbsent(className, this.options);
    }

    public static ClassOption forClass(String className) {
        return INSTANCES.computeIfAbsent(className, ClassOption::new);
    }

    public static ClassOption forClass(Class<?> clazz) {
        return ClassOption.forClass(clazz.getName());
    }

    public ClassOption set(String key, Object value) {
        this.options.put(key, value);
        return this;
    }

    public <T> T get(String key) {
        return (T)this.options.get(key);
    }

    public <T> T get(String key, T defaultValue) {
        return (T)this.options.getOrDefault(key, defaultValue);
    }

    public boolean has(String key) {
        return this.options.containsKey(key);
    }

    public ClassOption remove(String key) {
        this.options.remove(key);
        return this;
    }

    public Set<String> keys() {
        return this.options.keySet();
    }

    public Map<String, Object> getAll() {
        return new HashMap<String, Object>(this.options);
    }

    public ClassOption clear() {
        this.options.clear();
        return this;
    }

    public int size() {
        return this.options.size();
    }

    public boolean isEmpty() {
        return this.options.isEmpty();
    }

    public String getClassName() {
        return this.className;
    }

    public ClassOption setBoolean(String key, boolean value) {
        return this.set(key, value);
    }

    public boolean getBoolean(String key) {
        return this.get(key, false);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.get(key, defaultValue);
    }

    public ClassOption setInt(String key, int value) {
        return this.set(key, value);
    }

    public int getInt(String key) {
        return this.get(key, 0);
    }

    public int getInt(String key, int defaultValue) {
        return this.get(key, defaultValue);
    }

    public ClassOption setLong(String key, long value) {
        return this.set(key, value);
    }

    public long getLong(String key) {
        return this.get(key, 0L);
    }

    public long getLong(String key, long defaultValue) {
        return this.get(key, defaultValue);
    }

    public ClassOption setFloat(String key, float value) {
        return this.set(key, Float.valueOf(value));
    }

    public float getFloat(String key) {
        return this.get(key, Float.valueOf(0.0f)).floatValue();
    }

    public float getFloat(String key, float defaultValue) {
        return this.get(key, Float.valueOf(defaultValue)).floatValue();
    }

    public ClassOption setDouble(String key, double value) {
        return this.set(key, value);
    }

    public double getDouble(String key) {
        return this.get(key, 0.0);
    }

    public double getDouble(String key, double defaultValue) {
        return this.get(key, defaultValue);
    }

    public ClassOption setString(String key, String value) {
        return this.set(key, value);
    }

    public String getString(String key) {
        return this.get(key, "");
    }

    public String getString(String key, String defaultValue) {
        return this.get(key, defaultValue);
    }

    public ClassOption setObject(String key, Object value) {
        return this.set(key, value);
    }

    public Object getObject(String key) {
        return this.get(key);
    }

    public Object getObject(String key, Object defaultValue) {
        return this.get(key, defaultValue);
    }

    public ClassOption setAll(Map<String, Object> options) {
        this.options.putAll(options);
        return this;
    }

    public ClassOption setAll(ClassOption other) {
        if (other != null) {
            this.options.putAll(other.options);
        }
        return this;
    }

    public ClassOption merge(Map<String, Object> options) {
        if (options != null) {
            for (Map.Entry<String, Object> entry : options.entrySet()) {
                if (this.options.containsKey(entry.getKey())) continue;
                this.options.put(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    public ClassOption merge(ClassOption other) {
        if (other != null) {
            this.merge(other.options);
        }
        return this;
    }

    public boolean containsAll(Set<String> keys) {
        return this.options.keySet().containsAll(keys);
    }

    public boolean containsAny(Set<String> keys) {
        for (String key : keys) {
            if (!this.options.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    public String getStringRepresentation() {
        StringBuilder sb = new StringBuilder();
        sb.append("ClassOption{");
        sb.append("className='").append(this.className).append("', ");
        sb.append("options={");
        boolean first = true;
        for (Map.Entry<String, Object> entry : this.options.entrySet()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(entry.getKey()).append("=").append(entry.getValue());
            first = false;
        }
        sb.append("}}");
        return sb.toString();
    }

    public static void setGlobalOption(String className, String key, Object value) {
        ClassOption.forClass(className).set(key, value);
    }

    public static <T> T getGlobalOption(String className, String key) {
        return (T)((Map)CLASS_OPTIONS.getOrDefault(className, new HashMap())).get(key);
    }

    public static <T> T getGlobalOption(String className, String key, T defaultValue) {
        Map<String, Object> classOptions = CLASS_OPTIONS.get(className);
        if (classOptions != null && classOptions.containsKey(key)) {
            return (T)classOptions.get(key);
        }
        return defaultValue;
    }

    public static boolean hasGlobalOption(String className, String key) {
        Map<String, Object> classOptions = CLASS_OPTIONS.get(className);
        return classOptions != null && classOptions.containsKey(key);
    }

    public static void removeGlobalOption(String className, String key) {
        Map<String, Object> classOptions = CLASS_OPTIONS.get(className);
        if (classOptions != null) {
            classOptions.remove(key);
        }
    }

    public static Map<String, Map<String, Object>> getAllClassOptions() {
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        for (Map.Entry<String, Map<String, Object>> entry : CLASS_OPTIONS.entrySet()) {
            result.put(entry.getKey(), new HashMap<String, Object>(entry.getValue()));
        }
        return result;
    }

    public static void clearAllClassOptions() {
        CLASS_OPTIONS.clear();
        INSTANCES.clear();
    }

    public static Set<String> getAllClassNames() {
        return CLASS_OPTIONS.keySet();
    }

    public static boolean hasClassOptions(String className) {
        Map<String, Object> classOptions = CLASS_OPTIONS.get(className);
        return classOptions != null && !classOptions.isEmpty();
    }

    public static int getClassOptionCount(String className) {
        Map<String, Object> classOptions = CLASS_OPTIONS.get(className);
        return classOptions != null ? classOptions.size() : 0;
    }

    public String toString() {
        return this.getStringRepresentation();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ClassOption that = (ClassOption)obj;
        return this.className.equals(that.className) && this.options.equals(that.options);
    }

    public int hashCode() {
        int result = this.className.hashCode();
        result = 31 * result + this.options.hashCode();
        return result;
    }
}

