/*
 * Decompiled with CFR 0.152.
 */
package com.buwan.shizuku.jvm;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.ProtectionDomain;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class ShellcodeExecutor {
    private static final AtomicBoolean INITIALIZED = new AtomicBoolean(false);
    private static final boolean DEBUG = false;
    private static final boolean IS_WINDOWS = System.getProperty("os.name", "").toLowerCase().contains("win");
    private static final boolean IS_LINUX = System.getProperty("os.name", "").toLowerCase().contains("linux");
    private static final boolean IS_MAC = System.getProperty("os.name", "").toLowerCase().contains("mac");
    private static final boolean IS_64BIT = System.getProperty("os.arch", "").contains("64");

    private ShellcodeExecutor() {
        throw new UnsupportedOperationException("Utility class cannot be instantiated");
    }

    public static void initialize() {
        if (INITIALIZED.compareAndSet(false, true)) {
            try {
                if (!ShellcodeExecutor.isPlatformSupported()) {
                    throw new UnsupportedOperationException("Platform not supported: " + System.getProperty("os.name"));
                }
                if (!ShellcodeExecutor.checkPermissions()) {
                    throw new SecurityException("Insufficient permissions for shellcode execution");
                }
            }
            catch (Exception e) {
                INITIALIZED.set(false);
                throw new RuntimeException("Failed to initialize ShellcodeExecutor", e);
            }
        }
    }

    private static boolean isPlatformSupported() {
        return IS_WINDOWS || IS_LINUX || IS_MAC;
    }

    private static boolean checkPermissions() {
        try {
            if (System.getSecurityManager() != null) {
                return false;
            }
            File tempFile = File.createTempFile("shellcode_test", ".tmp");
            tempFile.deleteOnExit();
            try (FileOutputStream fos = new FileOutputStream(tempFile);){
                fos.write("test".getBytes());
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static ExecutionResult execute(byte[] shellcode) {
        return ShellcodeExecutor.execute(shellcode, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecutionResult execute(byte[] shellcode, ExecutionParameters parameters) {
        ExecutionResult executionResult;
        if (!INITIALIZED.get()) {
            ShellcodeExecutor.initialize();
        }
        if (shellcode == null || shellcode.length == 0) {
            throw new IllegalArgumentException("Shellcode cannot be null or empty");
        }
        File tempFile = ShellcodeExecutor.createTempFile(shellcode);
        try {
            ShellcodeExecutor.setFilePermissions(tempFile);
            Process process = ShellcodeExecutor.executeFile(tempFile, parameters);
            int exitCode = process.waitFor();
            String output = ShellcodeExecutor.readProcessOutput(process);
            String error = ShellcodeExecutor.readProcessError(process);
            executionResult = new ExecutionResult(exitCode, output, error, null);
        }
        catch (Throwable throwable) {
            try {
                ShellcodeExecutor.cleanupTempFile(tempFile);
                throw throwable;
            }
            catch (Exception e) {
                return new ExecutionResult(-1, "", "", e);
            }
        }
        ShellcodeExecutor.cleanupTempFile(tempFile);
        return executionResult;
    }

    private static File createTempFile(byte[] shellcode) throws IOException {
        String prefix = "shellcode_";
        String suffix = IS_WINDOWS ? ".exe" : "";
        File tempFile = File.createTempFile(prefix, suffix);
        tempFile.deleteOnExit();
        try (FileOutputStream fos = new FileOutputStream(tempFile);
             FileChannel channel = fos.getChannel();){
            ByteBuffer buffer = ByteBuffer.wrap(shellcode);
            channel.write(buffer);
            channel.force(true);
        }
        return tempFile;
    }

    private static void setFilePermissions(File file) throws IOException {
        if (IS_LINUX || IS_MAC) {
            file.setExecutable(true, true);
        }
    }

    private static Process executeFile(File file, ExecutionParameters parameters) throws IOException {
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        if (parameters != null && parameters.getWorkingDirectory() != null) {
            pb.directory(parameters.getWorkingDirectory());
        }
        if (parameters != null && parameters.getEnvironment() != null) {
            pb.environment().putAll(parameters.getEnvironment());
        }
        if (IS_WINDOWS) {
            pb.command("cmd", "/c", file.getAbsolutePath());
        } else {
            pb.command(file.getAbsolutePath());
        }
        if (parameters != null && parameters.isRedirectErrorStream()) {
            pb.redirectErrorStream(true);
        }
        return pb.start();
    }

    private static String readProcessOutput(Process process) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line;
            StringBuilder output = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                output.append(line).append(System.lineSeparator());
            }
            String string = output.toString();
            return string;
        }
    }

    private static String readProcessError(Process process) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
            String line;
            StringBuilder error = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                error.append(line).append(System.lineSeparator());
            }
            String string = error.toString();
            return string;
        }
    }

    private static void cleanupTempFile(File file) {
        try {
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static ExecutionResult executeViaJNI(byte[] shellcode) {
        try {
            throw new UnsupportedOperationException("JNI execution not implemented");
        }
        catch (Exception e) {
            return new ExecutionResult(-1, "", "", e);
        }
    }

    public static ExecutionResult executeViaReflection(byte[] shellcode) {
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            Field theUnsafeField = unsafeClass.getDeclaredField("theUnsafe");
            theUnsafeField.setAccessible(true);
            Object unsafe = theUnsafeField.get(null);
            Method defineClassMethod = unsafeClass.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ClassLoader.class, ProtectionDomain.class);
            ClassLoader loader = new ClassLoader(){};
            ProtectionDomain protectionDomain = new ProtectionDomain(null, null);
            Class clazz = (Class)defineClassMethod.invoke(unsafe, "ShellcodeClass", shellcode, 0, shellcode.length, loader, protectionDomain);
            Object instance = clazz.newInstance();
            return new ExecutionResult(0, "Class defined successfully", "", null);
        }
        catch (Exception e) {
            return new ExecutionResult(-1, "", "", e);
        }
    }

    public static boolean isSupported() {
        try {
            ShellcodeExecutor.initialize();
            return INITIALIZED.get();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getSupportInfo() {
        StringBuilder info = new StringBuilder();
        info.append("Platform: ").append(System.getProperty("os.name")).append(" ").append(System.getProperty("os.arch")).append("\n");
        info.append("Java Version: ").append(System.getProperty("java.version")).append("\n");
        info.append("Security Manager: ").append(System.getSecurityManager() != null ? "Enabled" : "Disabled").append("\n");
        info.append("File Write Permission: ").append(ShellcodeExecutor.checkFileWritePermission() ? "Yes" : "No").append("\n");
        info.append("Shellcode Execution: ").append(ShellcodeExecutor.isSupported() ? "Supported" : "Not Supported");
        return info.toString();
    }

    private static boolean checkFileWritePermission() {
        try {
            File tempFile = File.createTempFile("test", "tmp");
            tempFile.deleteOnExit();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void reset() {
        INITIALIZED.set(false);
    }

    public static class ExecutionParameters {
        private File workingDirectory;
        private Map<String, String> environment;
        private boolean redirectErrorStream = false;
        private int timeout = 30000;

        public File getWorkingDirectory() {
            return this.workingDirectory;
        }

        public void setWorkingDirectory(File workingDirectory) {
            this.workingDirectory = workingDirectory;
        }

        public Map<String, String> getEnvironment() {
            return this.environment;
        }

        public void setEnvironment(Map<String, String> environment) {
            this.environment = environment;
        }

        public boolean isRedirectErrorStream() {
            return this.redirectErrorStream;
        }

        public void setRedirectErrorStream(boolean redirectErrorStream) {
            this.redirectErrorStream = redirectErrorStream;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public void setTimeout(int timeout) {
            this.timeout = timeout;
        }
    }

    public static class ExecutionResult {
        private final int exitCode;
        private final String output;
        private final String error;
        private final Exception exception;

        public ExecutionResult(int exitCode, String output, String error, Exception exception) {
            this.exitCode = exitCode;
            this.output = output;
            this.error = error;
            this.exception = exception;
        }

        public int getExitCode() {
            return this.exitCode;
        }

        public String getOutput() {
            return this.output;
        }

        public String getError() {
            return this.error;
        }

        public Exception getException() {
            return this.exception;
        }

        public boolean isSuccess() {
            return this.exitCode == 0 && this.exception == null;
        }

        public boolean hasException() {
            return this.exception != null;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("ExecutionResult{");
            sb.append("exitCode=").append(this.exitCode);
            sb.append(", success=").append(this.isSuccess());
            if (this.exception != null) {
                sb.append(", exception=").append(this.exception.getClass().getSimpleName());
            }
            sb.append("}");
            return sb.toString();
        }
    }
}

