/*
 * Decompiled with CFR 0.152.
 */
package com.buwan.shizuku.jvm.helfy;

public class Type {
    private final String typeName;
    private final int sort;
    private final String descriptor;
    private final String internalName;

    public Type(String typeName) {
        this.typeName = typeName;
        this.sort = this.determineSort(typeName);
        this.descriptor = this.generateDescriptor(typeName);
        this.internalName = this.generateInternalName(typeName);
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int getSort() {
        return this.sort;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public boolean isPrimitive() {
        return this.sort >= 1 && this.sort <= 8;
    }

    public boolean isArray() {
        return this.sort == 9;
    }

    public boolean isObject() {
        return this.sort == 10;
    }

    public boolean isVoid() {
        return this.sort == 0;
    }

    private int determineSort(String typeName) {
        if (typeName == null || typeName.isEmpty()) {
            return 0;
        }
        switch (typeName) {
            case "void": {
                return 0;
            }
            case "boolean": {
                return 1;
            }
            case "char": {
                return 2;
            }
            case "byte": {
                return 3;
            }
            case "short": {
                return 4;
            }
            case "int": {
                return 5;
            }
            case "float": {
                return 6;
            }
            case "long": {
                return 7;
            }
            case "double": {
                return 8;
            }
        }
        if (typeName.endsWith("[]")) {
            return 9;
        }
        return 10;
    }

    private String generateDescriptor(String typeName) {
        if (typeName == null || typeName.isEmpty()) {
            return "V";
        }
        switch (typeName) {
            case "void": {
                return "V";
            }
            case "boolean": {
                return "Z";
            }
            case "char": {
                return "C";
            }
            case "byte": {
                return "B";
            }
            case "short": {
                return "S";
            }
            case "int": {
                return "I";
            }
            case "float": {
                return "F";
            }
            case "long": {
                return "J";
            }
            case "double": {
                return "D";
            }
        }
        if (typeName.endsWith("[]")) {
            return "[" + this.generateDescriptor(typeName.substring(0, typeName.length() - 2));
        }
        return "L" + typeName.replace('.', '/') + ";";
    }

    private String generateInternalName(String typeName) {
        if (typeName == null || typeName.isEmpty()) {
            return typeName;
        }
        if (typeName.endsWith("[]")) {
            return "[" + this.generateInternalName(typeName.substring(0, typeName.length() - 2));
        }
        return typeName.replace('.', '/');
    }

    public String toString() {
        return "Type{typeName='" + this.typeName + "', sort=" + this.sort + ", descriptor='" + this.descriptor + "', internalName='" + this.internalName + "'}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Type type = (Type)obj;
        return this.typeName.equals(type.typeName);
    }

    public int hashCode() {
        return this.typeName.hashCode();
    }
}

