/*
 * Decompiled with CFR 0.152.
 */
package com.buwan.shizuku.jvm.hotspot.oops;

import com.buwan.shizuku.jvm.helfy.JVM;
import com.buwan.shizuku.jvm.hotspot.JVMObject;
import com.buwan.shizuku.jvm.hotspot.oops.HashtableEntry;

public class HashtableBucket
extends JVMObject {
    private final int bucketIndex;
    private HashtableEntry firstEntry;
    private int entryCount;
    private final int maxEntries;

    public HashtableBucket(int bucketIndex, int maxEntries) {
        super(JVM.type("HashtableBucket"));
        this.bucketIndex = bucketIndex;
        this.firstEntry = null;
        this.entryCount = 0;
        this.maxEntries = maxEntries;
    }

    public HashtableBucket(int bucketIndex) {
        this(bucketIndex, 8);
    }

    public int getBucketIndex() {
        return this.bucketIndex;
    }

    public HashtableEntry getFirstEntry() {
        return this.firstEntry;
    }

    public int getEntryCount() {
        return this.entryCount;
    }

    public int getMaxEntries() {
        return this.maxEntries;
    }

    public boolean isEmpty() {
        return this.firstEntry == null;
    }

    public boolean isFull() {
        return this.entryCount >= this.maxEntries;
    }

    public void addEntry(HashtableEntry entry) {
        if (entry != null && !this.isFull()) {
            entry.setNext(this.firstEntry);
            this.firstEntry = entry;
            ++this.entryCount;
        }
    }

    public boolean removeEntry(HashtableEntry entry) {
        HashtableEntry current;
        if (entry == null || this.isEmpty()) {
            return false;
        }
        if (this.firstEntry == entry) {
            this.firstEntry = this.firstEntry.getNext();
            --this.entryCount;
            return true;
        }
        for (current = this.firstEntry; current != null && current.getNext() != entry; current = current.getNext()) {
        }
        if (current != null) {
            current.setNext(entry.getNext());
            --this.entryCount;
            return true;
        }
        return false;
    }

    public boolean removeEntryByKey(Object key) {
        if (key == null || this.isEmpty()) {
            return false;
        }
        if (this.firstEntry != null && key.equals(this.firstEntry.getKey())) {
            this.firstEntry = this.firstEntry.getNext();
            --this.entryCount;
            return true;
        }
        for (HashtableEntry current = this.firstEntry; current != null && current.getNext() != null; current = current.getNext()) {
            if (!key.equals(current.getNext().getKey())) continue;
            current.setNext(current.getNext().getNext());
            --this.entryCount;
            return true;
        }
        return false;
    }

    public HashtableEntry findEntry(Object key) {
        if (key == null || this.isEmpty()) {
            return null;
        }
        for (HashtableEntry current = this.firstEntry; current != null; current = current.getNext()) {
            if (!key.equals(current.getKey())) continue;
            return current;
        }
        return null;
    }

    public double getLoadFactor() {
        return (double)this.entryCount / (double)this.maxEntries;
    }

    public String getStatistics() {
        return String.format("Bucket[%d]: %d/%d entries, Load: %.2f%%", this.bucketIndex, this.entryCount, this.maxEntries, this.getLoadFactor() * 100.0);
    }

    public void clear() {
        this.firstEntry = null;
        this.entryCount = 0;
    }

    public HashtableEntry[] getAllEntries() {
        HashtableEntry[] entries = new HashtableEntry[this.entryCount];
        int index = 0;
        for (HashtableEntry current = this.firstEntry; current != null && index < this.entryCount; current = current.getNext()) {
            entries[index++] = current;
        }
        return entries;
    }

    @Override
    public long getSize() {
        return 32 + this.entryCount * 16;
    }

    @Override
    public long getMark() {
        return this.bucketIndex;
    }

    @Override
    public void setMark(long mark) {
    }

    @Override
    public long getKlass() {
        return System.identityHashCode(this.getClass());
    }

    @Override
    public void setKlass(long klass) {
    }

    @Override
    public String toString() {
        return "HashtableBucket{index=" + this.bucketIndex + ", entries=" + this.entryCount + ", maxEntries=" + this.maxEntries + ", loadFactor=" + String.format("%.2f", this.getLoadFactor()) + "}";
    }
}

