/*
 * Decompiled with CFR 0.152.
 */
package com.buwan.shizuku.jvm.hotspot.oops;

import com.buwan.shizuku.jvm.helfy.JVM;
import com.buwan.shizuku.jvm.hotspot.JVMObject;

public class HashtableEntry
extends JVMObject {
    private final Object key;
    private final Object value;
    private final int hash;
    private HashtableEntry next;

    public HashtableEntry(Object key, Object value, int hash) {
        super(JVM.type("HashtableEntry"));
        this.key = key;
        this.value = value;
        this.hash = hash;
        this.next = null;
    }

    public Object getKey() {
        return this.key;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
    }

    public int getHash() {
        return this.hash;
    }

    public HashtableEntry getNext() {
        return this.next;
    }

    public void setNext(HashtableEntry next) {
        this.next = next;
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public int getChainLength() {
        int length = 1;
        HashtableEntry current = this.next;
        while (current != null) {
            ++length;
            current = current.next;
        }
        return length;
    }

    public String getEntryString() {
        return String.format("Entry{key=%s, value=%s, hash=%d}", this.key, this.value, this.hash);
    }

    @Override
    public long getSize() {
        return 32 + (this.key != null ? this.key.toString().length() * 2 : 0) + (this.value != null ? this.value.toString().length() * 2 : 0);
    }

    @Override
    public long getMark() {
        return this.hash;
    }

    @Override
    public void setMark(long mark) {
    }

    @Override
    public long getKlass() {
        return System.identityHashCode(this.getClass());
    }

    @Override
    public void setKlass(long klass) {
    }

    @Override
    public String toString() {
        return "HashtableEntry{key=" + String.valueOf(this.key) + ", value=" + String.valueOf(this.value) + ", hash=" + this.hash + ", hasNext=" + this.hasNext() + "}";
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HashtableEntry that = (HashtableEntry)obj;
        return this.hash == that.hash && (this.key == null ? that.key == null : this.key.equals(that.key));
    }

    @Override
    public int hashCode() {
        return this.hash;
    }
}

