/*
 * Decompiled with CFR 0.152.
 */
package com.buwan.shizuku.jvm.hotspot.oops.klass;

import com.buwan.shizuku.jvm.hotspot.oops.AccessFlags;
import com.buwan.shizuku.jvm.hotspot.oops.Symbol;
import com.buwan.shizuku.jvm.hotspot.oops.klass.Klass;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class InstanceKlass
extends Klass {
    private final Map<String, FieldInfo> fields = new ConcurrentHashMap<String, FieldInfo>();
    private final Map<String, MethodInfo> methods = new ConcurrentHashMap<String, MethodInfo>();
    private final Map<String, String> annotations = new ConcurrentHashMap<String, String>();
    private byte[] classBytes = new byte[0];
    private final int constantPoolSize;
    private final int staticFieldSize;
    private final int instanceFieldSize;
    private final boolean isInitialized;
    private final boolean isLinked;
    private final boolean isVerified;

    public InstanceKlass(Symbol name, Symbol signature, AccessFlags accessFlags) {
        super(name, signature, accessFlags);
        this.constantPoolSize = 0;
        this.staticFieldSize = 0;
        this.instanceFieldSize = 0;
        this.isInitialized = false;
        this.isLinked = false;
        this.isVerified = false;
    }

    public InstanceKlass(Symbol name, Symbol signature, AccessFlags accessFlags, Klass superKlass, Klass[] interfaces) {
        super(name, signature, accessFlags, superKlass, interfaces);
        this.constantPoolSize = 0;
        this.staticFieldSize = 0;
        this.instanceFieldSize = 0;
        this.isInitialized = false;
        this.isLinked = false;
        this.isVerified = false;
    }

    public void addField(String fieldName, FieldInfo fieldInfo) {
        if (fieldName != null && fieldInfo != null) {
            this.fields.put(fieldName, fieldInfo);
        }
    }

    public void addMethod(String methodName, MethodInfo methodInfo) {
        if (methodName != null && methodInfo != null) {
            this.methods.put(methodName, methodInfo);
        }
    }

    public void addAnnotation(String annotationName, String annotationValue) {
        if (annotationName != null) {
            this.annotations.put(annotationName, annotationValue);
        }
    }

    public FieldInfo getField(String fieldName) {
        return fieldName != null ? this.fields.get(fieldName) : null;
    }

    public MethodInfo getMethod(String methodName) {
        return methodName != null ? this.methods.get(methodName) : null;
    }

    public String getAnnotation(String annotationName) {
        return annotationName != null ? this.annotations.get(annotationName) : null;
    }

    public Set<String> getFieldNames() {
        return this.fields.keySet();
    }

    public Set<String> getMethodNames() {
        return this.methods.keySet();
    }

    public Set<String> getAnnotationNames() {
        return this.annotations.keySet();
    }

    public int getFieldCount() {
        return this.fields.size();
    }

    public int getMethodCount() {
        return this.methods.size();
    }

    public int getAnnotationCount() {
        return this.annotations.size();
    }

    public boolean hasField(String fieldName) {
        return fieldName != null && this.fields.containsKey(fieldName);
    }

    public boolean hasMethod(String methodName) {
        return methodName != null && this.methods.containsKey(methodName);
    }

    public boolean hasAnnotation(String annotationName) {
        return annotationName != null && this.annotations.containsKey(annotationName);
    }

    public void setClassBytes(byte[] classBytes) {
        if (classBytes != null) {
            this.classBytes = (byte[])classBytes.clone();
        }
    }

    public byte[] getClassBytes() {
        return (byte[])this.classBytes.clone();
    }

    public void setConstantPoolSize(int constantPoolSize) {
    }

    public int getConstantPoolSize() {
        return this.constantPoolSize;
    }

    public void setStaticFieldSize(int staticFieldSize) {
    }

    public int getStaticFieldSize() {
        return this.staticFieldSize;
    }

    public void setInstanceFieldSize(int instanceFieldSize) {
    }

    public int getInstanceFieldSize() {
        return this.instanceFieldSize;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public boolean isLinked() {
        return this.isLinked;
    }

    public boolean isVerified() {
        return this.isVerified;
    }

    public String getDetailedInfo() {
        return String.format("InstanceKlass: %s\nFields: %d, Methods: %d, Annotations: %d\nInitialized: %s, Linked: %s, Verified: %s\nStatic Fields: %d bytes, Instance Fields: %d bytes", this.getClassName(), this.getFieldCount(), this.getMethodCount(), this.getAnnotationCount(), this.isInitialized, this.isLinked, this.isVerified, this.staticFieldSize, this.instanceFieldSize);
    }

    @Override
    protected int calculateInstanceSize() {
        return 16 + this.instanceFieldSize;
    }

    @Override
    public long getSize() {
        return super.getSize() + (long)(this.fields.size() * 32) + (long)(this.methods.size() * 48) + (long)(this.annotations.size() * 24) + (long)this.classBytes.length;
    }

    @Override
    public String toString() {
        return "InstanceKlass{name=" + this.getClassName() + ", fields=" + this.getFieldCount() + ", methods=" + this.getMethodCount() + ", annotations=" + this.getAnnotationCount() + ", initialized=" + this.isInitialized + ", linked=" + this.isLinked + ", verified=" + this.isVerified + "}";
    }

    public static class FieldInfo {
        private final String name;
        private final String type;
        private final AccessFlags accessFlags;
        private final Object defaultValue;

        public FieldInfo(String name, String type, AccessFlags accessFlags, Object defaultValue) {
            this.name = name;
            this.type = type;
            this.accessFlags = accessFlags;
            this.defaultValue = defaultValue;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public AccessFlags getAccessFlags() {
            return this.accessFlags;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }
    }

    public static class MethodInfo {
        private final String name;
        private final String signature;
        private final AccessFlags accessFlags;
        private final String returnType;
        private final String[] parameterTypes;

        public MethodInfo(String name, String signature, AccessFlags accessFlags, String returnType, String[] parameterTypes) {
            this.name = name;
            this.signature = signature;
            this.accessFlags = accessFlags;
            this.returnType = returnType;
            this.parameterTypes = parameterTypes != null ? (String[])parameterTypes.clone() : new String[]{};
        }

        public String getName() {
            return this.name;
        }

        public String getSignature() {
            return this.signature;
        }

        public AccessFlags getAccessFlags() {
            return this.accessFlags;
        }

        public String getReturnType() {
            return this.returnType;
        }

        public String[] getParameterTypes() {
            return (String[])this.parameterTypes.clone();
        }
    }
}

