/*
 * Decompiled with CFR 0.152.
 */
package com.buwan.shizuku.sa;

import com.buwan.shizuku.sa.Ymsa;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class AllReturnTest {
    public static void testAllReturnBasic(ServerPlayer player) {
        try {
            boolean currentState = Ymsa.isAllReturnEnabled();
            player.m_213846_((Component)Component.m_237113_((String)("\u00a7e[Test] \u5f53\u524d AllReturn \u72b6\u6001: " + currentState)));
            int killedCount = Ymsa.getAllReturnKilledCount();
            int protectedCount = Ymsa.getAllReturnProtectedCount();
            player.m_213846_((Component)Component.m_237113_((String)("\u00a7e[Test] \u5df2\u6e05\u9664\u5b9e\u4f53: " + killedCount)));
            player.m_213846_((Component)Component.m_237113_((String)("\u00a7e[Test] \u53d7\u4fdd\u62a4\u5b9e\u4f53: " + protectedCount)));
            Ymsa.toggleAllReturn(player);
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7a[Test] AllReturn \u57fa\u672c\u529f\u80fd\u6d4b\u8bd5\u5b8c\u6210"));
        }
        catch (Exception e) {
            player.m_213846_((Component)Component.m_237113_((String)("\u00a7c[Test] AllReturn \u6d4b\u8bd5\u5931\u8d25: " + e.getMessage())));
            e.printStackTrace();
        }
    }

    public static void testEntityProtection(ServerPlayer player) {
        try {
            Ymsa.addProtectedEntity(player.m_20148_());
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7e[Test] \u5df2\u6dfb\u52a0\u73a9\u5bb6\u5230\u4fdd\u62a4\u5217\u8868"));
            int protectedCount = Ymsa.getAllReturnProtectedCount();
            player.m_213846_((Component)Component.m_237113_((String)("\u00a7e[Test] \u5f53\u524d\u53d7\u4fdd\u62a4\u5b9e\u4f53\u6570\u91cf: " + protectedCount)));
            Ymsa.removeProtectedEntity(player.m_20148_());
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7e[Test] \u5df2\u79fb\u9664\u73a9\u5bb6\u4fdd\u62a4"));
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7a[Test] \u5b9e\u4f53\u4fdd\u62a4\u529f\u80fd\u6d4b\u8bd5\u5b8c\u6210"));
        }
        catch (Exception e) {
            player.m_213846_((Component)Component.m_237113_((String)("\u00a7c[Test] \u5b9e\u4f53\u4fdd\u62a4\u6d4b\u8bd5\u5931\u8d25: " + e.getMessage())));
            e.printStackTrace();
        }
    }

    public static void testDataCleanup(ServerPlayer player) {
        try {
            Ymsa.clearAllReturnData();
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7e[Test] \u5df2\u6e05\u7406\u6240\u6709 AllReturn \u6570\u636e"));
            int killedCount = Ymsa.getAllReturnKilledCount();
            int protectedCount = Ymsa.getAllReturnProtectedCount();
            player.m_213846_((Component)Component.m_237113_((String)("\u00a7e[Test] \u6e05\u7406\u540e - \u5df2\u6e05\u9664\u5b9e\u4f53: " + killedCount)));
            player.m_213846_((Component)Component.m_237113_((String)("\u00a7e[Test] \u6e05\u7406\u540e - \u53d7\u4fdd\u62a4\u5b9e\u4f53: " + protectedCount)));
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7a[Test] \u6570\u636e\u6e05\u7406\u529f\u80fd\u6d4b\u8bd5\u5b8c\u6210"));
        }
        catch (Exception e) {
            player.m_213846_((Component)Component.m_237113_((String)("\u00a7c[Test] \u6570\u636e\u6e05\u7406\u6d4b\u8bd5\u5931\u8d25: " + e.getMessage())));
            e.printStackTrace();
        }
    }

    public static void runFullTestSuite(ServerPlayer player) {
        player.m_213846_((Component)Component.m_237113_((String)"\u00a76[Test] \u5f00\u59cb\u8fd0\u884c AllReturn \u5b8c\u6574\u6d4b\u8bd5\u5957\u4ef6..."));
        AllReturnTest.testAllReturnBasic(player);
        AllReturnTest.testEntityProtection(player);
        AllReturnTest.testDataCleanup(player);
        player.m_213846_((Component)Component.m_237113_((String)"\u00a7a[Test] AllReturn \u5b8c\u6574\u6d4b\u8bd5\u5957\u4ef6\u8fd0\u884c\u5b8c\u6210\uff01"));
    }

    private static boolean isDevelopmentEnvironment() {
        try {
            String javaClassPath = System.getProperty("java.class.path");
            return javaClassPath != null && (javaClassPath.contains("gradle") || javaClassPath.contains("idea") || javaClassPath.contains("eclipse") || javaClassPath.contains("run"));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void performanceTest(ServerPlayer player) {
        try {
            long startTime = System.currentTimeMillis();
            for (int i = 0; i < 1000; ++i) {
                Ymsa.addProtectedEntity(UUID.randomUUID());
            }
            long endTime = System.currentTimeMillis();
            long duration = endTime - startTime;
            player.m_213846_((Component)Component.m_237113_((String)("\u00a7e[Test] \u6027\u80fd\u6d4b\u8bd5 - \u5904\u74061000\u4e2aUUID\u8017\u65f6: " + duration + "ms")));
            Ymsa.clearAllReturnData();
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7a[Test] \u6027\u80fd\u6d4b\u8bd5\u5b8c\u6210"));
        }
        catch (Exception e) {
            player.m_213846_((Component)Component.m_237113_((String)("\u00a7c[Test] \u6027\u80fd\u6d4b\u8bd5\u5931\u8d25: " + e.getMessage())));
            e.printStackTrace();
        }
    }
}

