/*
 * Decompiled with CFR 0.152.
 */
package com.buwan.shizuku.server;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class ChaosWitherInterceptor {
    private static final ScheduledExecutorService CLEANUP_EXECUTOR = Executors.newScheduledThreadPool(1);
    private static boolean isInitialized = false;

    private static void initializeInterceptor() {
        if (isInitialized) {
            return;
        }
        try {
            System.out.println("\u00a7d[ChaosWitherInterceptor] \u5f00\u59cb\u521d\u59cb\u5316\u6df7\u6c8c\u51cb\u96f6\u62e6\u622a\u5668");
            CLEANUP_EXECUTOR.scheduleAtFixedRate(() -> {
                try {
                    ChaosWitherInterceptor.performAggressiveCleanup();
                }
                catch (Exception e) {
                    System.out.println("\u00a7d[ChaosWitherInterceptor] \u6e05\u7406\u4efb\u52a1\u6267\u884c\u5931\u8d25: " + e.getMessage());
                }
            }, 1L, 2L, TimeUnit.SECONDS);
            ChaosWitherInterceptor.disableChaosWitherCore();
            isInitialized = true;
            System.out.println("\u00a7d[ChaosWitherInterceptor] \u6df7\u6c8c\u51cb\u96f6\u62e6\u622a\u5668\u521d\u59cb\u5316\u5b8c\u6210");
        }
        catch (Exception e) {
            System.out.println("\u00a7d[ChaosWitherInterceptor] \u521d\u59cb\u5316\u5931\u8d25: " + e.getMessage());
        }
    }

    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        try {
            Entity entity = event.getEntity();
            if (entity == null) {
                return;
            }
            if ("true".equals(System.getProperty("shizuku.chaoswither.allowed"))) {
                System.out.println("\u00a7d[ChaosWitherInterceptor] \u6df7\u6c8c\u51cb\u96f6\u751f\u6210\u5df2\u5141\u8bb8\uff0c\u8df3\u8fc7\u62e6\u622a");
                return;
            }
            if (ChaosWitherInterceptor.isChaosWitherEntity(entity)) {
                System.out.println("\u00a7d[ChaosWitherInterceptor] \u62e6\u622a\u6df7\u6c8c\u51cb\u96f6\u5b9e\u4f53: " + entity.m_7755_().getString());
                entity.m_142687_(Entity.RemovalReason.DISCARDED);
                event.setCanceled(true);
                ChaosWitherInterceptor.performEmergencyCleanup(entity.m_9236_());
            }
        }
        catch (Exception e) {
            System.out.println("\u00a7d[ChaosWitherInterceptor] \u5b9e\u4f53\u62e6\u622a\u5931\u8d25: " + e.getMessage());
        }
    }

    private static boolean isChaosWitherEntity(Entity entity) {
        try {
            if (entity == null) {
                return false;
            }
            String className = entity.getClass().getName().toLowerCase();
            String entityName = entity.m_7755_().getString();
            if (className.contains("chaoswither") || className.contains("chaos_wither")) {
                return true;
            }
            if (entityName.contains("\u6df7\u6c8c\u51cb\u96f6") || entityName.contains("ChaosWither")) {
                return true;
            }
            ResourceLocation key = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
            return key != null && "chaoswither".equals(key.m_135827_());
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void performEmergencyCleanup(Level level) {
        try {
            if (!(level instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            for (Entity entity : serverLevel.m_8583_()) {
                if (!ChaosWitherInterceptor.isChaosWitherEntity(entity)) continue;
                try {
                    entity.m_142687_(Entity.RemovalReason.DISCARDED);
                    System.out.println("\u00a7d[ChaosWitherInterceptor] \u7d27\u6025\u6e05\u7406\u79fb\u9664: " + entity.m_7755_().getString());
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            System.out.println("\u00a7d[ChaosWitherInterceptor] \u7d27\u6025\u6e05\u7406\u5931\u8d25: " + e.getMessage());
        }
    }

    private static void performAggressiveCleanup() {
        try {
            MinecraftServer server = null;
            try {
                Class<?> serverClass = Class.forName("net.minecraft.server.MinecraftServer");
                Field currentServerField = serverClass.getDeclaredField("SERVER");
                currentServerField.setAccessible(true);
                server = (MinecraftServer)currentServerField.get(null);
            }
            catch (Exception serverClass) {
                // empty catch block
            }
            if (server != null) {
                int totalRemoved = 0;
                for (ServerLevel sl : server.m_129785_()) {
                    int removedCount = 0;
                    for (Entity entity : sl.m_8583_()) {
                        if (!ChaosWitherInterceptor.isChaosWitherEntity(entity)) continue;
                        try {
                            entity.m_142687_(Entity.RemovalReason.DISCARDED);
                            ++removedCount;
                            ++totalRemoved;
                        }
                        catch (Exception exception) {}
                    }
                    if (removedCount <= 0) continue;
                    System.out.println("\u00a7d[ChaosWitherInterceptor] \u5b9a\u671f\u6e05\u7406\uff1a\u5728\u7ef4\u5ea6 " + String.valueOf(sl.m_46472_().m_135782_()) + " \u4e2d\u79fb\u9664 " + removedCount + " \u4e2a\u6df7\u6c8c\u51cb\u96f6\u5b9e\u4f53");
                }
                if (totalRemoved > 0) {
                    System.out.println("\u00a7d[ChaosWitherInterceptor] \u5b9a\u671f\u6e05\u7406\u5b8c\u6210\uff1a\u603b\u5171\u79fb\u9664 " + totalRemoved + " \u4e2a\u6df7\u6c8c\u51cb\u96f6\u5b9e\u4f53");
                }
            }
        }
        catch (Exception e) {
            System.out.println("\u00a7d[ChaosWitherInterceptor] \u6fc0\u8fdb\u6e05\u7406\u5931\u8d25: " + e.getMessage());
        }
    }

    private static void disableChaosWitherCore() {
        try {
            String[] targetClasses;
            for (String className : targetClasses = new String[]{"net.wzz.chaoswither.ChaoswitherMod", "net.wzz.chaoswither.entity.ChaosWitherEntity", "net.wzz.chaoswither.utils.ChaosUtil", "net.wzz.chaoswither.command.HappyModeCommand"}) {
                try {
                    Class<?> clazz = Class.forName(className);
                    System.out.println("\u00a7d[ChaosWitherInterceptor] \u53d1\u73b0\u76ee\u6807\u7c7b: " + className);
                    for (Field field : clazz.getDeclaredFields()) {
                        try {
                            field.setAccessible(true);
                            if (!Modifier.isStatic(field.getModifiers())) continue;
                            String fieldName = field.getName().toLowerCase();
                            if (field.getType() == Boolean.TYPE || field.getType() == Boolean.class) {
                                if (!fieldName.contains("enable") && !fieldName.contains("active") && !fieldName.contains("hook") && !fieldName.contains("protect") && !fieldName.contains("spawn") && !fieldName.contains("create")) continue;
                                field.set(null, false);
                                System.out.println("\u00a7d[ChaosWitherInterceptor] \u7981\u7528\u5b57\u6bb5: " + className + "." + fieldName);
                                continue;
                            }
                            if (!Collection.class.isAssignableFrom(field.getType()) && !Map.class.isAssignableFrom(field.getType())) continue;
                            Object collectionOrMap = field.get(null);
                            if (collectionOrMap instanceof Collection) {
                                ((Collection)collectionOrMap).clear();
                            }
                            if (collectionOrMap instanceof Map) {
                                ((Map)collectionOrMap).clear();
                            }
                            System.out.println("\u00a7d[ChaosWitherInterceptor] \u6e05\u7a7a\u96c6\u5408: " + className + "." + fieldName);
                        }
                        catch (Exception fieldName) {
                            // empty catch block
                        }
                    }
                    for (String methodName : new String[]{"shutdown", "disable", "stop", "destroy"}) {
                        try {
                            Method method = clazz.getDeclaredMethod(methodName, new Class[0]);
                            method.setAccessible(true);
                            if (!Modifier.isStatic(method.getModifiers())) continue;
                            method.invoke(null, new Object[0]);
                            System.out.println("\u00a7d[ChaosWitherInterceptor] \u8c03\u7528\u65b9\u6cd5: " + className + "." + (String)methodName);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            System.out.println("\u00a7d[ChaosWitherInterceptor] \u7981\u7528\u6838\u5fc3\u7c7b\u5931\u8d25: " + e.getMessage());
        }
    }

    public static void shutdown() {
        try {
            if (CLEANUP_EXECUTOR != null && !CLEANUP_EXECUTOR.isShutdown()) {
                CLEANUP_EXECUTOR.shutdownNow();
            }
            System.out.println("\u00a7d[ChaosWitherInterceptor] \u62e6\u622a\u5668\u5df2\u5173\u95ed");
        }
        catch (Exception e) {
            System.out.println("\u00a7d[ChaosWitherInterceptor] \u5173\u95ed\u5931\u8d25: " + e.getMessage());
        }
    }

    static {
        ChaosWitherInterceptor.initializeInterceptor();
    }
}

