/*
 * Decompiled with CFR 0.152.
 */
package com.buwan.shizuku.server;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber
public class ChaosWitherUltimateInterceptor {
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private static boolean isInitialized = false;

    public static void initialize() {
        if (isInitialized) {
            return;
        }
        ChaosWitherUltimateInterceptor.startPeriodicCleanup();
        ChaosWitherUltimateInterceptor.startEntityMonitoring();
        isInitialized = true;
    }

    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        Entity entity = event.getEntity();
        if ("true".equals(System.getProperty("shizuku.chaoswither.allowed"))) {
            System.out.println("[ChaosWitherInterceptor] \u6df7\u6c8c\u51cb\u96f6\u751f\u6210\u5df2\u5141\u8bb8\uff0c\u8df3\u8fc7\u62e6\u622a");
            return;
        }
        if (ChaosWitherUltimateInterceptor.isChaosWither(entity)) {
            event.setCanceled(true);
            System.out.println("[ChaosWitherInterceptor] \u963b\u6b62\u4e86Chaos Wither\u5b9e\u4f53\u52a0\u5165\u4e16\u754c: " + String.valueOf(entity));
            return;
        }
        if (entity instanceof WitherBoss) {
            ChaosWitherUltimateInterceptor.enhanceWitherProtection((WitherBoss)entity);
        }
    }

    @SubscribeEvent
    public static void onMobSpawnFinalize(MobSpawnEvent.FinalizeSpawn event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        if ("true".equals(System.getProperty("shizuku.chaoswither.allowed"))) {
            System.out.println("[ChaosWitherInterceptor] \u6df7\u6c8c\u51cb\u96f6\u751f\u6210\u5df2\u5141\u8bb8\uff0c\u8df3\u8fc7\u62e6\u622a");
            return;
        }
        if (ChaosWitherUltimateInterceptor.isChaosWither((Entity)event.getEntity())) {
            event.setCanceled(true);
            System.out.println("[ChaosWitherInterceptor] \u963b\u6b62\u4e86Chaos Wither\u751f\u6210: " + String.valueOf(event.getEntity()));
        }
    }

    private static boolean isChaosWither(Entity entity) {
        if (entity == null) {
            return false;
        }
        String entityName = entity.m_7755_().getString().toLowerCase();
        String className = entity.getClass().getName().toLowerCase();
        return entityName.contains("\u6df7\u6c8c\u51cb\u96f6") || entityName.contains("chaoswither") || className.contains("chaoswither") || className.contains("chaos_wither") || entity.m_6095_().toString().toLowerCase().contains("chaoswither");
    }

    private static void enhanceWitherProtection(WitherBoss wither) {
        try {
            wither.m_21153_(wither.m_21223_() * 0.5f);
            System.out.println("[ChaosWitherInterceptor] \u589e\u5f3a\u4e86\u51cb\u96f6\u602a\u9632\u62a4: " + String.valueOf(wither));
        }
        catch (Exception e) {
            System.out.println("[ChaosWitherInterceptor] \u589e\u5f3a\u9632\u62a4\u5931\u8d25: " + e.getMessage());
        }
    }

    private static void startPeriodicCleanup() {
        scheduler.scheduleAtFixedRate(() -> {
            try {
                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                if (server == null) {
                    return;
                }
                for (ServerLevel level : server.m_129785_()) {
                    ChaosWitherUltimateInterceptor.cleanupChaosWitherInLevel(level);
                }
            }
            catch (Exception e) {
                System.out.println("[ChaosWitherInterceptor] \u5b9a\u671f\u6e05\u7406\u5931\u8d25: " + e.getMessage());
            }
        }, 5L, 10L, TimeUnit.SECONDS);
    }

    private static void startEntityMonitoring() {
        scheduler.scheduleAtFixedRate(() -> {
            try {
                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                if (server == null) {
                    return;
                }
                for (ServerLevel level : server.m_129785_()) {
                    ChaosWitherUltimateInterceptor.monitorAndKillChaosWither(level);
                }
            }
            catch (Exception e) {
                System.out.println("[ChaosWitherInterceptor] \u5b9e\u4f53\u76d1\u63a7\u5931\u8d25: " + e.getMessage());
            }
        }, 2L, 5L, TimeUnit.SECONDS);
    }

    private static void cleanupChaosWitherInLevel(ServerLevel level) {
        try {
            Iterable entities = level.m_8583_();
            int removedCount = 0;
            for (Entity entity : entities) {
                if (!ChaosWitherUltimateInterceptor.isChaosWither(entity)) continue;
                entity.m_142687_(Entity.RemovalReason.DISCARDED);
                ++removedCount;
            }
            if (removedCount > 0) {
                System.out.println("[ChaosWitherInterceptor] \u5728 " + String.valueOf(level.m_46472_()) + " \u4e2d\u6e05\u7406\u4e86 " + removedCount + " \u4e2aChaos Wither\u5b9e\u4f53");
            }
        }
        catch (Exception e) {
            System.out.println("[ChaosWitherInterceptor] \u6e05\u7406\u5931\u8d25: " + e.getMessage());
        }
    }

    private static void monitorAndKillChaosWither(ServerLevel level) {
        try {
            Method getEntitiesMethod;
            Field entityManagerField = level.getClass().getDeclaredField("entityManager");
            entityManagerField.setAccessible(true);
            Object entityManager = entityManagerField.get(level);
            if (entityManager != null && (getEntitiesMethod = entityManager.getClass().getMethod("getAllEntities", new Class[0])) != null) {
                Iterable entities = (Iterable)getEntitiesMethod.invoke(entityManager, new Object[0]);
                for (Entity entity : entities) {
                    if (!ChaosWitherUltimateInterceptor.isChaosWither(entity)) continue;
                    entity.m_142687_(Entity.RemovalReason.DISCARDED);
                    System.out.println("[ChaosWitherInterceptor] \u76d1\u63a7\u53d1\u73b0\u5e76\u79fb\u9664\u4e86Chaos Wither: " + String.valueOf(entity));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void shutdown() {
        if (scheduler != null && !scheduler.isShutdown()) {
            scheduler.shutdown();
            try {
                if (!scheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                    scheduler.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                scheduler.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }
}

