# Shizuku Blade Mod

一个强大的Minecraft Forge模组，提供实体管理、Boss秒杀和拔刀剑保护功能。

喵石可通过击杀原本怪物掉落

## 🚀 快速开始

### 全局功能控制（推荐）

使用以下命令一次性控制所有功能：

```bash
# 开启所有功能
/shizuku all on

# 关闭所有功能  
/shizuku all off

# 查看所有功能状态
/shizuku all status

# 查看帮助
/shizuku all help
```

### 快捷键激活

- **Shift + J**: 拿着"无铭有名拔刀剑"时激活所有功能
- **Shift + K**: 激活EntityEraser
- **Shift + L**: 激活AllReturn

## 📋 功能列表

### ✅ 已集成功能-----------------------------------目前的ALLRETURN+EntityEraser并未完善

1. **EntityEraser** - 实体擦除器
   - 自动检测和移除指定实体
   - 支持关键词匹配和命名空间过滤
   - 可配置的冷却时间

2. **AllReturn** - 全局返回系统
   - 持续扫描和清理模组实体
   - 自动替换为原版实体
   - 高级Boss处理机制

3. **归寂凋零秒杀** - 特殊Boss处理
   - 专门针对归寂凋零的秒杀系统
   - 多层次攻击策略
   - 投射物清理功能



5. **拔刀剑保护** - 防缴械系统
   - 保护"无铭有名拔刀剑"不被丢弃
   - 自动修复归寂凋零的影响
   - 支持强制丢弃（Shift+Q）

## 🎮 命令系统

### 全局控制命令

```bash
/shizuku all on          # 开启所有功能
/shizuku all off         # 关闭所有功能
/shizuku all status      # 查看状态
/shizuku all help        # 查看帮助
```

### EntityEraser命令

```bash
/shizuku entityeraser on/off/toggle  # 控制EntityEraser
/shizuku entityeraser status         # 查看状态
/shizuku entityeraser stats          # 查看统计
/shizuku entityeraser help           # 查看帮助
/shizuku ee on/off/toggle            # 别名
```

### AllReturn命令

```bash
/shizuku allreturn on/off/toggle     # 控制AllReturn
/shizuku allreturn status            # 查看状态
/shizuku allreturn stats             # 查看统计
/shizuku allreturn help              # 查看帮助
/shizuku ar on/off/toggle            # 别名
```

### 调试命令

```bash
/shizuku entityeraser test           # 测试EntityEraser功能
/shizuku allreturn test              # 测试AllReturn功能
/shizuku entityeraser scan           # 扫描模组实体
/shizuku allreturn check             # 检查保护系统
```

### 归寂凋零专用命令

```bash
/silence scan                        # 扫描归寂凋零实体和投射物
/silence kill                        # 强制清理所有归寂凋零相关实体
```

### 混沌凋零控制命令

```bash
/shizuku chaos allow                 # 允许混沌凋零生成
/shizuku chaos block                 # 阻止混沌凋零生成
/shizuku chaos status                # 查看拦截器状态
/shizuku chaos help                  # 查看帮助
```



## ⚙️ 配置说明

### 自动激活限制

- **重要**: 所有功能默认不会自动开启
- 必须通过命令或快捷键手动激活
- 确保不会影响正常游戏体验

### 激活方式

1. **命令激活**: 使用 `/shizuku all on`
2. **快捷键激活**: 拿着无铭有名拔刀剑时按 `Shift+J`
3. **单独激活**: 使用对应的功能命令



### 功能说明
- **基于归寂之刃源码的精确抹杀**：完全按照归寂之刃的抹杀逻辑来处理超级蜜蜂
- **完整的实体移除流程**：包括加入禁止列表、强制移除、生物实体处理、Boss血条移除等
- **防止重新生成**：通过SilenceList.addBadEntity()确保超级蜜蜂不会重新出现

### 技术实现
1. **加入禁止列表**：调用SilenceList.addBadEntity()防止重新生成
2. **强制移除实体**：设置移除原因、传送到虚空、销毁实体
3. **生物实体处理**：标记死亡状态、触发死亡事件、清除AI
4. **特殊处理**：移除Boss血条、设置特殊标记
5. **兜底处理**：确保实体被彻底移除

### 使用方法
1. 开启AllReturn功能：`/shizuku allreturn on`
2. 释放SA攻击超级蜜蜂
3. 超级蜜蜂将被按照归寂之刃的逻辑完全抹杀

## 🌀 混沌凋零秒杀

### 功能说明
- **基于混沌凋零模组源码的精确抹杀**：完全按照混沌凋零0.8版本的抹杀逻辑来处理混沌凋零
- **原生ChaosUtil.killEntity()调用**：优先使用混沌凋零模组自己的抹杀方法
- **完整的实体移除流程**：包括多种RemovalReason、强制移除、生物实体处理等
- **多重移除策略**：确保混沌凋零及其变体被彻底移除

### 技术实现
1. **原生方法调用**：优先调用ChaosUtil.killEntity()方法
2. **多重移除原因**：DISCARDED、KILLED、UNLOADED_TO_CHUNK
3. **反射操作**：设置死亡时间、移除原因、死亡标记
4. **强制移除**：多种移除方法确保彻底清除
5. **兜底处理**：确保实体被彻底移除，使用2000tick持续追杀

### 支持的实体
- ChaosWitherEntity（混沌凋零）
- ChaosPlayerEntity（混沌玩家）
- 所有chaoswither命名空间下的实体
- 包含"混沌凋零"或"chaos wither"的自定义名称实体

### 使用方法
1. 开启AllReturn功能：`/shizuku allreturn on`
2. 释放SA攻击混沌凋零
3. 混沌凋零将被按照其模组源码的逻辑完全抹杀

## 🔧 技术特性

### 安全机制

- 功能不会在游戏启动时自动激活
- 所有操作都需要玩家明确触发
- 完整的错误处理和异常捕获

### 性能优化

- 异步处理避免卡顿
- 智能缓存减少重复计算
- 可配置的扫描间隔

### 兼容性

- 支持多种模组实体
- 兼容不同的Minecraft版本
- 可扩展的架构设计

## 🐛 故障排除

### 常见问题

1. **功能无法激活**
   - 确保使用正确的命令格式
   - 检查是否有权限错误

2. **归寂凋零无法秒杀**
   - 使用 `/silence scan` 检查实体
   - 确保SA技能正确释放

3. **超级蜜蜂无法秒杀**
   - 确保SA技能正确释放
   - 检查控制台调试信息

4. **拔刀剑保护失效**
   - 使用 `/shizuku allreturn check` 检查系统
   - 确保拿着正确的拔刀剑

### 调试命令

```bash
/shizuku allreturn check             # 检查保护系统状态
/silence scan                        
/shizuku entityeraser test           # 测试EntityEraser
```

## 📝 更新日志








## 🤝 贡献

欢迎提交Issue和Pull Request来改进这个模组！

## �� 许可证

本项目采用MIT许可证。





