/*
 * Decompiled with CFR 0.152.
 */
package net.jackson;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonWriter;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class CommandAliasesClient
implements ClientModInitializer {
    private static final Map<String, String> commandAliases = new HashMap<String, String>();
    private static final Path aliasesFilePath = Path.of("config/command_aliases.json", new String[0]);
    private static CommandDispatcher<FabricClientCommandSource> lastDispatcher = null;

    public void onInitializeClient() {
        CommandAliasesClient.loadCommandAliases();
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
            lastDispatcher = dispatcher;
            CommandAliasesClient.registerAliasCommands((CommandDispatcher<FabricClientCommandSource>)dispatcher);
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"alias").then(ClientCommandManager.literal((String)"add").then(ClientCommandManager.argument((String)"alias", (ArgumentType)StringArgumentType.string()).then(ClientCommandManager.argument((String)"command", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
                String alias = StringArgumentType.getString((CommandContext)ctx, (String)"alias");
                String command = StringArgumentType.getString((CommandContext)ctx, (String)"command");
                CommandAliasesClient.addCommandAlias(alias, command);
                CommandAliasesClient.sendFeedback(ctx, "Added alias: " + alias + " -> " + command);
                return 1;
            }))))).then(ClientCommandManager.literal((String)"remove").then(ClientCommandManager.argument((String)"alias", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
                String alias = StringArgumentType.getString((CommandContext)ctx, (String)"alias");
                if (CommandAliasesClient.removeCommandAlias(alias)) {
                    CommandAliasesClient.sendFeedback(ctx, "Removed alias: " + alias);
                } else {
                    CommandAliasesClient.sendFeedback(ctx, "Alias not found: " + alias);
                }
                return 1;
            }))));
        });
    }

    private static void spoofReload() {
        if (lastDispatcher != null) {
            CommandAliasesClient.registerAliasCommands(lastDispatcher);
        }
        CommandAliasesClient.forceUpdateClientDispatcher();
    }

    private static void registerAliasCommands(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        commandAliases.forEach((alias, command) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)alias).executes(ctx -> CommandAliasesClient.executeAlias(command, ctx))).then(ClientCommandManager.argument((String)"args", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            String args = StringArgumentType.getString((CommandContext)ctx, (String)"args");
            return CommandAliasesClient.executeAlias(command + " " + args, ctx);
        }))));
    }

    private static void forceUpdateClientDispatcher() {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1724.field_3944 == null) {
            return;
        }
        try {
            class_634 handler = client.field_1724.field_3944;
            Field dispatcherField = class_634.class.getDeclaredField("commandDispatcher");
            dispatcherField.setAccessible(true);
            CommandDispatcher dispatcher = (CommandDispatcher)dispatcherField.get(handler);
            CommandAliasesClient.registerAliasCommands((CommandDispatcher<FabricClientCommandSource>)dispatcher);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static int executeAlias(String command, CommandContext<?> ctx) {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            player.field_3944.method_45730(command);
        }
        return 1;
    }

    private static void loadCommandAliases() {
        commandAliases.clear();
        try (InputStreamReader reader = new InputStreamReader(Files.newInputStream(aliasesFilePath, new OpenOption[0]));){
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            JsonObject aliases = json.getAsJsonObject("aliases");
            aliases.entrySet().forEach(entry -> commandAliases.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void saveCommandAliases() {
        JsonObject json = new JsonObject();
        JsonObject aliases = new JsonObject();
        commandAliases.forEach((arg_0, arg_1) -> ((JsonObject)aliases).addProperty(arg_0, arg_1));
        json.add("aliases", (JsonElement)aliases);
        try (JsonWriter writer = new JsonWriter((Writer)new OutputStreamWriter(Files.newOutputStream(aliasesFilePath, new OpenOption[0])));){
            writer.setIndent("  ");
            writer.jsonValue(json.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void addCommandAlias(String alias, String command) {
        commandAliases.put(alias, command);
        CommandAliasesClient.saveCommandAliases();
        CommandAliasesClient.spoofReload();
    }

    private static boolean removeCommandAlias(String alias) {
        boolean existed;
        boolean bl = existed = commandAliases.remove(alias) != null;
        if (existed) {
            CommandAliasesClient.saveCommandAliases();
            CommandAliasesClient.spoofReload();
        }
        return existed;
    }

    private static void sendFeedback(CommandContext<?> ctx, String message) {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            player.method_7353(class_2561.method_30163((String)message), false);
        }
    }
}

