#version 150

// Autoformatting keeps butchering these.
// find    #moj_import < ([a-z_]+) : ([a-z_.]+)>
// replace #moj_import <$1:$2>
#moj_import <minecraft:fog.glsl>
#moj_import <minecraft:dynamictransforms.glsl>
#moj_import <minecraft:globals.glsl>

#moj_import <vese:utils.glsl>
#moj_import <vese:portal.glsl>
#moj_import <vese:fluid.glsl>
#moj_import <vese:hue.glsl>
#moj_import <vese:waveforms.glsl>

uniform sampler2D Sampler0;

in float sphericalVertexDistance;
in float cylindricalVertexDistance;
in vec4 vertexColor;
in vec4 lightMapColor;
in vec4 overlayColor;
in vec2 texCoord0;

out vec4 fragColor;

vec4 vanilla(vec4 startColor, bool forceEmissive);

void main() {
    ivec4 fileId = rgbFloatToInt(texture(Sampler0, vec2(0, 0)));

    // Check for the 'DqC' color in the fileId tag
    if (fileId.r != 68 || fileId.g != 113 || fileId.b != 67) {
        fragColor = vanilla(texture(Sampler0, texCoord0), false);
        return;
    }

    // Default/Humanoid -
    ivec2 programStart = ivec2(56, 32);
    ivec2 paletteStart = ivec2(56, 40);
    ivec2 textureSize = ivec2(64, 64);

    if (fileId.a == 255) {
        /** Default/Humanoid */
        programStart = ivec2(56, 32);
        paletteStart = ivec2(56, 40);
        textureSize = ivec2(64, 64);
    }
    else if (fileId.a == 254) {
        /** Tiny Mobs (Allay, Vex, etc.) */
        programStart = ivec2(24, 24);
        paletteStart = ivec2(24, 28);
        textureSize = ivec2(32, 32);
    } else if (fileId.a == 253) {
        /** Foxes */
        programStart = ivec2(0, 17);
        paletteStart = ivec2(20, 17);
        textureSize = ivec2(48, 32);
    } else if (fileId.a == 252) {
        /** Frogs */
        programStart = ivec2(40, 40);
        paletteStart = ivec2(40, 44);
        textureSize = ivec2(48, 48);
    } else if (fileId.a == 251) {
        /** Most Small Entities */
        programStart = ivec2(56, 24);
        paletteStart = ivec2(56, 28);
        textureSize = ivec2(64, 32);
    } else if (fileId.a == 250) {
        /** Chickens and Endermen */
        programStart = ivec2(48, 8);
        paletteStart = ivec2(48, 12);
        textureSize = ivec2(64, 32);
    } else if (fileId.a == 249) {
        /** Most Medium Mobs */
        programStart = ivec2(56, 56);
        paletteStart = ivec2(56, 60);
        textureSize = ivec2(64, 64);
    } else if (fileId.a == 248) {
        /** Cows and Creaking */
        programStart = ivec2(0, 56);
        paletteStart = ivec2(0, 60);
        textureSize = ivec2(64, 64);
    } else if (fileId.a == 247) {
        /** Goats and Pandas */
        programStart = ivec2(0, 30);
        paletteStart = ivec2(0, 34);
        textureSize = ivec2(64, 64);
    } else if (fileId.a == 246) {
        /** Horses */
        programStart = ivec2(56, 0);
        paletteStart = ivec2(56, 4);
        textureSize = ivec2(64, 64);
    } else if (fileId.a == 245) {
        /** Stiders and Witches */
        programStart = ivec2(56, 120);
        paletteStart = ivec2(56, 124);
        textureSize = ivec2(64, 128);
    } else if (fileId.a == 244) {
        /** Most Large Entities */
        programStart = ivec2(120, 56);
        paletteStart = ivec2(120, 60);
        textureSize = ivec2(128, 64);
    } else if (fileId.a == 243) {
        /** Hoglins and Zoglins */
        programStart = ivec2(120, 0);
        paletteStart = ivec2(120, 4);
        textureSize = ivec2(128, 64);
    } else if (fileId.a == 242) {
        /** Giant Entities */
        programStart = ivec2(112, 120);
        paletteStart = ivec2(120, 120);
        textureSize = ivec2(128, 128);
    } else if (fileId.a == 241) {
        /** Sniffers */
        programStart = ivec2(184, 0);
        paletteStart = ivec2(184, 4);
        textureSize = ivec2(192, 192);
    } else if (fileId.a == 240) {
        /** Dragon + Atlases? */
        programStart = ivec2(248, 0);
        paletteStart = ivec2(248, 4);
        textureSize = ivec2(256, 256);
    } else if (fileId.a == 239) {
        /** Tadpoles */
        programStart = ivec2(0, 8);
        paletteStart = ivec2(8, 12);
        textureSize = ivec2(16, 16);
    } else {
        /** Unknown */
        fragColor = vanilla(texture(Sampler0, texCoord0), false);
        return;
    }

    // Get information about this pixel
    ivec2 texCoord = coordFloatToInt(texCoord0, textureSize);

    // Check if we have an animation for the pixel
    ivec4 pixel = rgbFloatToInt(
        texture(Sampler0, coordIntToFloat(texCoord, textureSize)));

    ivec2 programOffset = ivec2(
        ((pixel.r & 1) << 2) + ((pixel.g & 1) << 1) + ((pixel.b & 1) << 0),
        ((pixel.r & 2) << 1) + ((pixel.g & 2) << 0) + ((pixel.b & 2) >> 1));

    int programAddress = programOffset.x + (programOffset.y << 3);

    // If no animation is indicated, return a base color
    if (programAddress == 0) {
        fragColor = vanilla(
            texture(Sampler0, coordIntToFloat(texCoord, textureSize)), false);
        return;
    }

    // Read the program data
    ivec2 programPos = programStart + programOffset;
    ivec4 programData = rgbFloatToInt(
        texture(Sampler0, coordIntToFloat(programPos, textureSize)));

    // Get the game time in seconds
    float gameTicks = GameTime * 24000.0;
    int programId = programData.b >> 4;
    int programSpeed = (programData.b & 7);

    // Get the two colors;
    ivec2 primaryPos = (programData.r & 63) == 0
                           ? texCoord
                           : paletteStart + ivec2((programData.r & 7),
                                                  (programData.r >> 3) & 7);
    ivec2 secondaryPos = (programData.g & 63) == 0
                             ? texCoord
                             : paletteStart + ivec2((programData.g & 7),
                                                    (programData.g >> 3 & 7));

    vec4 primaryColor =
        vanilla(texture(Sampler0, coordIntToFloat(primaryPos, textureSize)),
                (programData.r & 128) > 0);
    vec4 secondaryColor =
        vanilla(texture(Sampler0, coordIntToFloat(secondaryPos, textureSize)),
                (programData.g & 128) > 0);

    // Switch based on program
    float mixPercent = 1.0;

    if (programId == 0) {
        // No Program - But can be used to set an emissive flag!
        mixPercent = 0.0;
    } else {
        bool boolA = (programData.a & 128) > 0;
        bool boolB = (programData.a & 64) > 0;
        int crumb = (programData.a & 48) >> 4;
        int nibble = programData.a & 15;

        if (programId == 1) {
            // End Portal
            // boolA - Override Background Color
            // boolB - Override Particle Color
            // nibble - Particle Count

            float adjustedTime = GameTime * programSpeed / 4.0;
            adjustedTime = adjustedTime * adjustedTime;

            vec3 backgroundColor = boolA ? primaryColor.rgb : vec3(0.0,0.0,0.0);

            vec3 particleColor = backgroundColor.rgb;

            bool overrideBackground = false;
            for (int i = 0; i <= nibble; i++) {
                vec3 layerColor = (boolB ? secondaryColor.rgb : VOID_COLORS[i]);

                float layerMask = voidMask(
                    (gl_FragCoord * end_portal_layer(float(i + 1), adjustedTime))
                        .xy,
                    ScreenSize, adjustedTime);

                particleColor = ((1.0 - layerMask) * particleColor) + (layerMask * layerColor);

                // if (layerMask > 0) {
                //     overrideBackground = true;
                //     particleColor += layerMask * layerColor;
                // }
            }

            secondaryColor = vec4(particleColor, 1.0);
            mixPercent = 1.0;

            // Special case where we're just applying glow without changing color
            // if (boolB && ((programData.g & 63) == 0) && ((programData.r & 63) == 0))
            // {
            //     mixPercent = overrideBackground ? particleColor.g : 0.0;
            // }
            // else
            // {
            //     secondaryColor = vec4(overrideBackground ? particleColor : backgroundColor, 1.0);
            //     mixPercent = 1.0;
            // }

        } else if (programId == 2) {
            // Fluid
            // boolA - Use Subpixels
            // boolB - Has Tail
            // crumb - Direction
            // nibble - Density

            // fragColor = vec4(1.0, 0.0, 1.0, 1.0);
            // return;

            vec2 dir = crumb == 0   ? vec2(0, 1)
                       : crumb == 1 ? vec2(0, -1)
                       : crumb == 3 ? vec2(-1, 0)
                                    : vec2(1, 0);

            ivec2 scale = (boolA ? 2 : 1) * textureSize;
            mixPercent = fluidMask(texCoord0, scale, dir, nibble, boolB,
                                   programSpeed, gameTicks);
        } else if (programId == 3) {
            // Hue Shift
            // boolA - Reverse
            float step = (8 - programSpeed) * 20.0 / 16.0;
            float cycleTicks = (8 - programSpeed) * 80;
            float progress = mod(gameTicks, cycleTicks) / cycleTicks;

            if (boolA) progress = 1.0 - progress;

            secondaryColor = shiftHue(primaryColor, progress);
            mixPercent = 1.0;
        } else if (programId == 4) {
            // Impulse / Sequential
            // boolA - Invert
            // boolB - Mix
            // crumb - Delay
            // nibble - Offset

            float cycleTicks = (8 - programSpeed) * 20;
            float step = cycleTicks / 16.0;
            float maxTicks = (1 + crumb) * cycleTicks;
            float progress =
                mod(maxTicks + gameTicks - (step * nibble), maxTicks) /
                cycleTicks;

            mixPercent = impulseMask(progress);
            if (boolA) mixPercent = 1.0 - mixPercent;

            if (boolB) {
                float opacity = secondaryColor.a;
                secondaryColor = vec4(
                    (1 - opacity) * primaryColor.r + opacity * secondaryColor.r,
                    (1 - opacity) * primaryColor.g + opacity * secondaryColor.g,
                    (1 - opacity) * primaryColor.b + opacity * secondaryColor.b,
                    primaryColor.a);
            }
        } else if (programId == 5) {
            // Square Wave
            // boolA - Invert
            // boolB - Mix
            // crumb - Delay
            // nibble - Offset

            float step = (8 - programSpeed) * 20.0 / 16.0;
            float cycleTicks = (8 - programSpeed) * 20;
            float maxTicks = (1 + crumb) * cycleTicks;
            float progress =
                mod(maxTicks + gameTicks - (step * nibble), maxTicks) /
                cycleTicks;

            mixPercent = squareMask(progress);
            if (boolA) mixPercent = 1.0 - mixPercent;

            if (boolB) {
                float opacity = secondaryColor.a;
                secondaryColor = vec4(
                    (1 - opacity) * primaryColor.r + opacity * secondaryColor.r,
                    (1 - opacity) * primaryColor.g + opacity * secondaryColor.g,
                    (1 - opacity) * primaryColor.b + opacity * secondaryColor.b,
                    primaryColor.a);
            }
        } else if (programId == 6) {
            // Sine Wave
            // boolA - Invert
            // boolB - Mix
            // crumb - Delay
            // nibble - Offset

            float step = (8 - programSpeed) * 20.0 / 16.0;
            float cycleTicks = (8 - programSpeed) * 20;
            float maxTicks = (1 + crumb) * cycleTicks;
            float progress =
                mod(maxTicks + gameTicks - (step * nibble), maxTicks) /
                cycleTicks;

            mixPercent = sineMask(progress);
            if (boolA) mixPercent = 1.0 - mixPercent;

            if (boolB) {
                float opacity = secondaryColor.a;
                secondaryColor = vec4(
                    (1 - opacity) * primaryColor.r + opacity * secondaryColor.r,
                    (1 - opacity) * primaryColor.g + opacity * secondaryColor.g,
                    (1 - opacity) * primaryColor.b + opacity * secondaryColor.b,
                    primaryColor.a);
            }
        } else if (programId == 7) {
            // Sawtooth Wave
            // boolA - Invert
            // boolB - Mix
            // crumb - Delay
            // nibble - Offset

            float step = (8 - programSpeed) * 20.0 / 16.0;
            float cycleTicks = (8 - programSpeed) * 20;
            float maxTicks = (1 + crumb) * cycleTicks;
            float progress =
                mod(maxTicks + gameTicks - (step * nibble), maxTicks) /
                cycleTicks;

            mixPercent = sawtoothMask(progress);

            if (boolA) mixPercent = 1.0 - mixPercent;

            if (boolB) {
                float opacity = secondaryColor.a;
                secondaryColor = vec4(
                    (1 - opacity) * primaryColor.r + opacity * secondaryColor.r,
                    (1 - opacity) * primaryColor.g + opacity * secondaryColor.g,
                    (1 - opacity) * primaryColor.b + opacity * secondaryColor.b,
                    primaryColor.a);
            }
        } else if (programId == 8) {
            // Heartbeat
            // boolA - Inverted
            // boolB - Mix
            // crumb - Delay
            // nibble - Offset

            float step = (8 - programSpeed) * 20.0 / 16.0;
            float cycleTicks = (8 - programSpeed) * 20;
            float maxTicks = (1 + crumb) * cycleTicks;
            float progress =
                mod(maxTicks + gameTicks - (step * nibble), maxTicks) /
                cycleTicks;

            mixPercent = heartMask(progress);
            if (boolA) mixPercent = 1.0 - mixPercent;

            if (boolB) {
                float opacity = secondaryColor.a;
                secondaryColor = vec4(
                    (1 - opacity) * primaryColor.r + opacity * secondaryColor.r,
                    (1 - opacity) * primaryColor.g + opacity * secondaryColor.g,
                    (1 - opacity) * primaryColor.b + opacity * secondaryColor.b,
                    primaryColor.a);
            }
        }else if (programId == 9) {
            // Sweep
            // boolA - Reverse
            // boolB - Delayed
            // crumb - Style
            // nibble - Direction

            float step = (8 - programSpeed) * 20.0 / 32.0;
            float cycleTicks = (8 - programSpeed) * 20;
            float maxTicks = (1 + (boolB ? 1 : 0)) * cycleTicks;

            float offset = 0;

            if ((nibble & 1) != 0)
            {
                //add x to offset
            }

            if ((nibble & 2) != 0)
            {
                //add y to offset
            }

            if ((nibble & 4) != 0)
            {
                //add z to offset
            }

            float progress =
                mod(maxTicks + gameTicks - (step * nibble), maxTicks) /
                cycleTicks;
            
            mixPercent = 0;

            if (crumb == 0)
            {
                mixPercent = impulseMask(progress);
            }
            else if (crumb == 1)
            {
                mixPercent = squareMask(progress);
            }
            else if (crumb == 2)
            {
                mixPercent = sineMask(progress);
            }
            else if (crumb == 3)
            {
                mixPercent = sawtoothMask(progress);
            }

            mixPercent = heartMask(progress);
            if (boolA) mixPercent = 1.0 - mixPercent;

            if (boolB) {
                float opacity = secondaryColor.a;
                secondaryColor = vec4(
                    (1 - opacity) * primaryColor.r + opacity * secondaryColor.r,
                    (1 - opacity) * primaryColor.g + opacity * secondaryColor.g,
                    (1 - opacity) * primaryColor.b + opacity * secondaryColor.b,
                    primaryColor.a);
            }
        }
    }

    fragColor = mix(primaryColor, secondaryColor, mixPercent);
}

vec4 vanilla(vec4 startColor, bool forceEmissive) {
    vec4 color = startColor;
#ifdef ALPHA_CUTOUT
    if (color.a < ALPHA_CUTOUT) {
        discard;
    }
#endif
    color *= vertexColor * ColorModulator;
#ifndef NO_OVERLAY
    color.rgb = mix(overlayColor.rgb, color.rgb, overlayColor.a);
#endif
#ifndef EMISSIVE
    if (!forceEmissive) {
        color *= lightMapColor;
    }
#endif
    return apply_fog(color, sphericalVertexDistance, cylindricalVertexDistance, FogEnvironmentalStart, FogEnvironmentalEnd, FogRenderDistanceStart, FogRenderDistanceEnd, FogColor);
}
