#define M_PI 3.1415926535897932384626433832795

float impulseMask(float progress)
{
  return (progress <= (1 / 16.0)) ? 1.0 : 0.0;
}

float squareMask(float progress)
{
  return (progress <= (1 / 2.0)) ? 1.0 : 0.0;
}

float sineMask(float progress)
{
  if (progress >= 1.0) return 0.0;

  return 0.5 - 0.5 * cos(2 * M_PI * progress);
}

float sawtoothMask(float progress)
{
  if (progress >= 1.0) return 0.0;

  return 1.0 - progress;
}

float heartMask(float progress)
{
  if (progress >= 0.6) return 0.0;

  if (progress >= 0.1) return 1.2 - (2*progress);

  return 1.0 - (4*progress);
}