#define M_PI 3.1415926535897932384626433832795

float breatheMask(int sequence, int speed, float time) 
{
  // Convert time to ticks, then mod to a period of 5s.
  // Normalize value, so t is 'percent' of animation.
  float t = (mod(24000 * speed * time, 200.0)/100.0);

  float angle = (2 * M_PI * t);
  angle -= sequence * M_PI / 7.0;

  if (angle < M_PI || angle > 3 * M_PI)
  {
    angle = M_PI;
  }

  return 0.5 + (0.5 * cos(angle));

}