
float fluidMask(vec2 pos, ivec2 size, vec2 dir, int density, bool tail, int speed, float time)
{
  // float progress = mod(time, (20 * (8 -speed))) / (20 * (8 - speed));
  // vec2 maxOffset = vec2(abs(size.x * dir.x), abs(size.y * dir.y));
  // float offsetA = progress * max(maxOffset.x, maxOffset.y);

  float offsetA = 0.125 * speed * time;
  int offsetB = int(offsetA);
  int offsetC = offsetB - 1;
  offsetA = offsetA - offsetB;

  float oldValue = 0.0f;
  float newValue = 0.0f;

  int new_x = int(size.x * pos.x - offsetB * dir.x) % size.x;
  int new_y = int(size.y * pos.y - offsetB * dir.y) % size.y;
  int old_x = int(size.x * pos.x - offsetC * dir.x) % size.x;
  int old_y = int(size.y * pos.y - offsetC * dir.y) % size.y;

  float threshold = 0.90 - 0.05 * density;

  // Quick and dirty noise algorithm from https://stackoverflow.com/a/17075605

  // Calculate the value at the next time step.
  int seed = new_x * 73;
  seed ^= 0xE56FAA12;
  seed += new_y * 179;
  seed ^= 0x69628A2D;
  float result = float(int(seed % 201 + 201) % 201 - 100) / 100.0f;

  if (result > threshold)
  {
    newValue = 0.8f;
  }
  else if (result < 0.1f)
  {
    newValue = 0.1f;
  }

  if (tail)
  {
    seed = int(new_x + dir.x) * 73;
    seed ^= 0xE56FAA12;
    seed += int(new_y + dir.y) * 179;
    seed ^= 0x69628A2D;
    result = float(int(seed % 201 + 201) % 201 - 100) / 100.0f;

    if (result > threshold)
    {
      newValue += 0.6f;
    }

    seed = int(new_x + 2 * dir.x) * 73;
    seed ^= 0xE56FAA12;
    seed += int(new_y + 2 * dir.y) * 179;
    seed ^= 0x69628A2D;
    result = float(int(seed % 201 + 201) % 201 - 100) / 100.0f;

    if (result > threshold)
    {
      newValue += 0.4f;
    }

    seed = int(new_x + 3 * dir.x) * 73;
    seed ^= 0xE56FAA12;
    seed += int(new_y + 3 * dir.y) * 179;
    seed ^= 0x69628A2D;
    result = float(int(seed % 201 + 201) % 201 - 100) / 100.0f;

    if (result > threshold)
    {
      newValue += 0.2f;
    }
  }

  // Calculate the value at the old time step
  seed = old_x * 73;
  seed ^= 0xE56FAA12;
  seed += old_y * 179;
  seed ^= 0x69628A2D;
  result = float(int(seed % 201 + 201) % 201 - 100) / 100.0f;

  if (result > threshold)
  {
    oldValue = 0.8f;
  }
  else if (result < 0.1f)
  {
    oldValue = 0.1f;
  }

  if (tail)
  {
    seed = int(old_x + dir.x) * 73;
    seed ^= 0xE56FAA12;
    seed += int(old_y + dir.y) * 179;
    seed ^= 0x69628A2D;
    result = float(int(seed % 201 + 201) % 201 - 100) / 100.0f;

    if (result > threshold)
    {
      oldValue += 0.6f;
    }

    seed = int(old_x + 2 * dir.x) * 73;
    seed ^= 0xE56FAA12;
    seed += int(old_y + 2 * dir.y) * 179;
    seed ^= 0x69628A2D;
    result = float(int(seed % 201 + 201) % 201 - 100) / 100.0f;

    if (result > threshold)
    {
      oldValue += 0.4f;
    }

    seed = int(old_x + 3 * dir.x) * 73;
    seed ^= 0xE56FAA12;
    seed += int(old_y + 3 * dir.y) * 179;
    seed ^= 0x69628A2D;
    result = float(int(seed % 201 + 201) % 201 - 100) / 100.0f;

    if (result > threshold)
    {
      oldValue += 0.2f;
    }
  }

  // Interpolate
  return ((offsetA)*newValue) + (1.0 - (offsetA)) * oldValue;
}