/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.quicksort;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_2960;
import net.pcal.quicksort.QuicksortConfig;
import org.apache.logging.log4j.Level;

class QuicksortConfigParser {
    QuicksortConfigParser() {
    }

    static QuicksortConfig parse(InputStream in, QuicksortConfig.QuicksortChestConfig defaultChestConfig) throws IOException {
        ArrayList<QuicksortConfig.QuicksortChestConfig> chests = new ArrayList<QuicksortConfig.QuicksortChestConfig>();
        String rawJson = QuicksortConfigParser.stripComments(new String(in.readAllBytes(), StandardCharsets.UTF_8));
        Gson gson = new Gson();
        QuicksortConfigGson configGson = (QuicksortConfigGson)gson.fromJson(rawJson, QuicksortConfigGson.class);
        for (QuicksortChestConfigGson chestGson : configGson.quicksortChests) {
            defaultChestConfig = QuicksortConfigParser.createWithDefaults(defaultChestConfig, chestGson.baseBlockId, chestGson.range, chestGson.cooldownTicks, chestGson.animationTicks, chestGson.soundVolume, chestGson.soundPitch, chestGson.nbtMatchEnabledIds != null ? chestGson.nbtMatchEnabledIds : chestGson.enchantmentMatchingIds, chestGson.targetContainerIds);
            chests.add(defaultChestConfig);
        }
        String configuredLevel = configGson.logLevel;
        Level logLevel = Level.getLevel((String)configuredLevel);
        if (logLevel == null) {
            throw new IllegalArgumentException("Invalid logLevel " + configuredLevel);
        }
        return new QuicksortConfig(Collections.unmodifiableList(chests), logLevel);
    }

    static QuicksortConfig.QuicksortChestConfig createWithDefaults(QuicksortConfig.QuicksortChestConfig dflt, String baseBlockId, Integer range, Integer cooldownTicks, Integer animationTicks, Float soundVolume, Float soundPitch, Collection<String> enchantmentMatchingIds, Collection<String> targetContainerIds) {
        return new QuicksortConfig.QuicksortChestConfig(class_2960.method_60654((String)Objects.requireNonNull(baseBlockId, "baseBlockId is required")), Objects.requireNonNull(range != null ? range : (dflt == null ? null : Integer.valueOf(dflt.range())), "range is required"), Objects.requireNonNull(cooldownTicks != null ? cooldownTicks : (dflt == null ? null : Integer.valueOf(dflt.cooldownTicks())), "cooldownTicks is required"), Objects.requireNonNull(animationTicks != null ? animationTicks : (dflt == null ? null : Integer.valueOf(dflt.animationTicks())), "animationTicks is required"), Objects.requireNonNull(soundVolume != null ? soundVolume : (dflt == null ? null : Float.valueOf(dflt.soundVolume())), "soundVolume is required").floatValue(), Objects.requireNonNull(soundPitch != null ? soundPitch : (dflt == null ? null : Float.valueOf(dflt.soundPitch())), "soundPitch is required").floatValue(), Objects.requireNonNull(enchantmentMatchingIds != null ? QuicksortConfigParser.toIdentifierSet(enchantmentMatchingIds) : (dflt == null ? null : dflt.enchantmentMatchingIds()), "enchantmentMatchingIds"), Objects.requireNonNull(targetContainerIds != null ? QuicksortConfigParser.toIdentifierSet(targetContainerIds) : (dflt == null ? null : dflt.targetContainerIds()), "targetContainerIds"));
    }

    private static Set<class_2960> toIdentifierSet(Collection<String> enchantmentMatchingIds) {
        HashSet<class_2960> set = new HashSet<class_2960>();
        for (String id : enchantmentMatchingIds) {
            set.add(class_2960.method_60654((String)id));
        }
        return set;
    }

    private static String stripComments(String json) throws IOException {
        String line;
        StringBuilder out = new StringBuilder();
        BufferedReader br = new BufferedReader(new StringReader(json));
        while ((line = br.readLine()) != null) {
            if (line.strip().startsWith("//")) continue;
            out.append(line).append('\n');
        }
        return out.toString();
    }

    public static class QuicksortConfigGson {
        List<QuicksortChestConfigGson> quicksortChests;
        String logLevel;
    }

    public static class QuicksortChestConfigGson {
        String baseBlockId;
        Integer range;
        Integer cooldownTicks;
        Integer animationTicks;
        Float soundVolume;
        Float soundPitch;
        List<String> enchantmentMatchingIds;
        List<String> targetContainerIds;
        @Deprecated
        List<String> nbtMatchEnabledIds;
    }
}

