/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.quicksort;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2614;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_7923;
import net.minecraft.class_9299;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import net.pcal.quicksort.GhostItemEntity;
import net.pcal.quicksort.QuicksortConfig;
import org.apache.logging.log4j.Logger;

public class QuicksortService
implements ServerTickEvents.EndWorldTick {
    private static final QuicksortService INSTANCE = new QuicksortService();
    public static final String LOGGER_NAME = "Quicksort";
    public static final String LOG_PREFIX = "[Quicksort] ";
    private final List<QuicksorterJob> jobs = new ArrayList<QuicksorterJob>();
    private Map<class_2960, QuicksortConfig.QuicksortChestConfig> config = null;
    private Logger logger = null;

    public static QuicksortService getInstance() {
        return INSTANCE;
    }

    void init(QuicksortConfig config, Logger logger) {
        if (this.logger != null) {
            throw new IllegalStateException();
        }
        this.logger = Objects.requireNonNull(logger);
        if (this.config != null) {
            throw new IllegalStateException();
        }
        this.config = new HashMap<class_2960, QuicksortConfig.QuicksortChestConfig>();
        for (QuicksortConfig.QuicksortChestConfig chest : config.chestConfigs()) {
            this.config.put(chest.baseBlockId(), chest);
        }
    }

    public void onChestClosed(class_2595 e) {
        QuicksorterJob job;
        List<TargetContainer> visibles;
        class_3218 world = Objects.requireNonNull((class_3218)e.method_10997());
        QuicksortConfig.QuicksortChestConfig chestConfig = this.getChestConfigFor((class_1937)world, e.method_11016());
        if (chestConfig != null && !(visibles = this.getVisibleChestsNear(world, chestConfig, e, chestConfig.range())).isEmpty() && (job = QuicksorterJob.create(world, chestConfig, e, visibles)) != null) {
            this.jobs.add(job);
        }
    }

    public void onChestOpened(class_2595 chestEntity) {
        for (QuicksorterJob job : this.jobs) {
            if (!job.quicksorterPos.equals((Object)chestEntity.method_11016())) continue;
            job.stop();
        }
    }

    public void onEndTick(class_3218 world) {
        if (this.jobs.isEmpty()) {
            return;
        }
        Iterator<QuicksorterJob> i = this.jobs.iterator();
        while (i.hasNext()) {
            QuicksorterJob job = i.next();
            if (job.isDone()) {
                this.logger.debug("[Quicksort]  job completed for chest at " + String.valueOf(job.quicksorterPos));
                i.remove();
                continue;
            }
            if (!world.method_8597().equals((Object)job.dimension)) continue;
            job.tick(world);
        }
    }

    private QuicksortConfig.QuicksortChestConfig getChestConfigFor(class_1937 world, class_2338 chestPos) {
        class_2248 baseBlock = world.method_8320(chestPos.method_10074()).method_26204();
        class_2960 baseBlockId = class_7923.field_41175.method_10221((Object)baseBlock);
        return this.config.get(baseBlockId);
    }

    private List<TargetContainer> getVisibleChestsNear(class_3218 world, QuicksortConfig.QuicksortChestConfig chestConfig, class_2595 originChest, int distance) {
        GhostItemEntity itemEntity = new GhostItemEntity((class_1937)world, 0.0, 0.0, 0.0, new class_1799((class_1935)class_2246.field_10445));
        ArrayList<TargetContainer> out = new ArrayList<TargetContainer>();
        for (int d = originChest.method_11016().method_10263() - distance; d <= originChest.method_11016().method_10263() + distance; ++d) {
            for (int e = originChest.method_11016().method_10264() - distance; e <= originChest.method_11016().method_10264() + distance; ++e) {
                for (int f = originChest.method_11016().method_10260() - distance; f <= originChest.method_11016().method_10260() + distance; ++f) {
                    class_243 target;
                    class_243 origin;
                    class_3965 result;
                    if (d == originChest.method_11016().method_10263() && e == originChest.method_11016().method_10264() && f == originChest.method_11016().method_10260()) continue;
                    class_2338 targetPos = new class_2338(d, e, f);
                    class_2680 targetState = world.method_8320(new class_2338(d, e, f));
                    class_2248 targetBlock = targetState.method_26204();
                    class_2960 targetId = class_7923.field_41175.method_10221((Object)targetBlock);
                    if (!chestConfig.targetContainerIds().contains(targetId) || targetBlock instanceof class_2281 && this.getChestConfigFor((class_1937)world, targetPos) != null || !(result = world.method_17742(new class_3959(origin = QuicksortService.getTransferPoint(originChest.method_11016(), targetPos), target = QuicksortService.getTransferPoint(targetPos, originChest.method_11016()), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)itemEntity))).method_17784().equals((Object)target)) continue;
                    this.logger.debug(() -> "[Quicksort]  visible chest found at " + String.valueOf(result.method_17777()) + " " + String.valueOf(targetPos));
                    class_243 itemVelocity = new class_243((target.method_10216() - origin.method_10216()) / (double)chestConfig.animationTicks(), (target.method_10214() - origin.method_10214()) / (double)chestConfig.animationTicks(), (target.method_10215() - origin.method_10215()) / (double)chestConfig.animationTicks());
                    out.add(new TargetContainer(targetPos, origin, target, itemVelocity));
                }
            }
        }
        return out;
    }

    private static class_243 getTransferPoint(class_2338 origin, class_2338 target) {
        class_243 origin3d = class_243.method_24953((class_2382)origin);
        class_243 target3d = class_243.method_24953((class_2382)target);
        class_243 vector = target3d.method_1020(origin3d).method_1029();
        return origin3d.method_1019(vector).method_1031(0.0, -0.5, 0.0);
    }

    private static class QuicksorterJob {
        private final class_2338 quicksorterPos;
        private final QuicksortConfig.QuicksortChestConfig quicksorterConfig;
        private final List<GhostItemEntity> ghostItems = new ArrayList<GhostItemEntity>();
        private final List<SlotJob> slotJobs;
        private final class_2874 dimension;
        private boolean isTransferComplete = false;
        int tick = 0;

        static QuicksorterJob create(class_3218 world, QuicksortConfig.QuicksortChestConfig chestConfig, class_2595 originChest, List<TargetContainer> visibleTargets) {
            ArrayList<SlotJob> slotJobs = new ArrayList<SlotJob>();
            for (int slot = 0; slot < originChest.method_5439(); ++slot) {
                SlotJob slotJob = SlotJob.create(world, chestConfig, (class_2621)originChest, slot, visibleTargets);
                if (slotJob == null) continue;
                slotJobs.add(slotJob);
            }
            return slotJobs.isEmpty() ? null : new QuicksorterJob(chestConfig, world.method_8597(), originChest.method_11016(), slotJobs);
        }

        QuicksorterJob(QuicksortConfig.QuicksortChestConfig chestConfig, class_2874 dimension, class_2338 quicksorterPos, List<SlotJob> slotJobs) {
            this.quicksorterConfig = Objects.requireNonNull(chestConfig);
            this.dimension = Objects.requireNonNull(dimension);
            this.quicksorterPos = Objects.requireNonNull(quicksorterPos);
            this.slotJobs = Objects.requireNonNull(slotJobs);
        }

        public boolean isDone() {
            return this.isTransferComplete && this.ghostItems.isEmpty();
        }

        public void tick(class_3218 world) {
            Iterator<GhostItemEntity> g = this.ghostItems.iterator();
            while (g.hasNext()) {
                GhostItemEntity e = g.next();
                if (e.method_6985() <= this.quicksorterConfig.animationTicks()) continue;
                e.method_6987();
                g.remove();
            }
            if (!this.isTransferComplete && this.tick++ > this.quicksorterConfig.cooldownTicks()) {
                this.tick = 0;
                if (!this.doOneTransfer(world)) {
                    this.isTransferComplete = true;
                }
            }
        }

        private boolean doOneTransfer(class_3218 world) {
            Objects.requireNonNull(world);
            do {
                int jobIndex;
                SlotJob slotJob;
                if ((slotJob = this.slotJobs.get(jobIndex = new Random().nextInt(this.slotJobs.size()))).doOneTransfer(world, this::createGhost)) {
                    return true;
                }
                this.slotJobs.remove(jobIndex);
            } while (!this.slotJobs.isEmpty());
            return false;
        }

        private void createGhost(class_3218 world, class_1792 item, TargetContainer targetChest) {
            world.method_8396(null, this.quicksorterPos, class_3417.field_14641, class_3419.field_15245, this.quicksorterConfig.soundVolume(), this.quicksorterConfig.soundPitch());
            class_1799 ghostStack = new class_1799((class_1935)item, 1);
            GhostItemEntity itemEntity = new GhostItemEntity((class_1937)world, targetChest.originItemPos.method_10216(), targetChest.originItemPos.method_10214(), targetChest.originItemPos.method_10215(), ghostStack);
            this.ghostItems.add(itemEntity);
            itemEntity.method_5875(true);
            itemEntity.method_24830(false);
            itemEntity.method_5684(true);
            itemEntity.method_18799(targetChest.itemVelocity);
            world.method_8649((class_1297)itemEntity);
        }

        public void stop() {
            this.isTransferComplete = true;
            this.slotJobs.clear();
        }
    }

    private record TargetContainer(class_2338 blockPos, class_243 originItemPos, class_243 targetItemPos, class_243 itemVelocity) {
    }

    private static class SlotJob {
        private final QuicksortConfig.QuicksortChestConfig quicksorterConfig;
        private final class_2338 quicksorterPos;
        private final int slot;
        private final List<TargetContainer> targets;

        static SlotJob create(class_3218 world, QuicksortConfig.QuicksortChestConfig chestConfig, class_2621 originChest, int slot, List<TargetContainer> allVisibleContainers) {
            class_1799 originStack = originChest.method_5438(slot);
            if (originStack == null || originStack.method_7960()) {
                return null;
            }
            ArrayList<TargetContainer> targetContainers = new ArrayList<TargetContainer>();
            for (TargetContainer visibleContainer : allVisibleContainers) {
                class_1263 targetInventory = SlotJob.getInventoryFor(world, visibleContainer.blockPos());
                if (targetInventory == null || !SlotJob.isValidTarget(originStack, targetInventory, chestConfig.enchantmentMatchingIds())) continue;
                targetContainers.add(visibleContainer);
            }
            return targetContainers.isEmpty() ? null : new SlotJob(chestConfig, originChest.method_11016(), slot, targetContainers);
        }

        private SlotJob(QuicksortConfig.QuicksortChestConfig chestConfig, class_2338 quicksorterPos, int slot, List<TargetContainer> candidateChests) {
            this.quicksorterConfig = Objects.requireNonNull(chestConfig);
            this.quicksorterPos = Objects.requireNonNull(quicksorterPos);
            this.targets = Objects.requireNonNull(candidateChests);
            this.slot = slot;
        }

        boolean doOneTransfer(class_3218 world, GhostCreator gc) {
            Objects.requireNonNull(world, "null gc");
            class_1263 quicksorterInventory = SlotJob.getInventoryFor(world, this.quicksorterPos);
            if (quicksorterInventory == null) {
                return false;
            }
            class_1799 originStack = quicksorterInventory.method_5438(this.slot);
            if (originStack.method_7960()) {
                return false;
            }
            while (!this.targets.isEmpty()) {
                class_1799 copy = originStack.method_7972();
                class_1792 ghostItem = copy.method_7909();
                copy.method_7939(1);
                int candidateIndex = new Random().nextInt(this.targets.size());
                TargetContainer candidate = this.targets.get(candidateIndex);
                class_1263 targetInventory = SlotJob.getInventoryFor(world, candidate.blockPos());
                if (targetInventory == null) {
                    this.targets.remove(candidateIndex);
                    continue;
                }
                class_1799 itemStack2 = class_2614.method_11260((class_1263)null, (class_1263)targetInventory, (class_1799)copy, (class_2350)null);
                if (!itemStack2.method_7960()) {
                    this.targets.remove(candidateIndex);
                    continue;
                }
                originStack.method_7934(1);
                quicksorterInventory.method_5431();
                if (this.quicksorterConfig.animationTicks() > 0) {
                    gc.createGhost(world, ghostItem, candidate);
                }
                return true;
            }
            return false;
        }

        private static class_1263 getInventoryFor(class_3218 world, class_2338 blockPos) {
            Objects.requireNonNull(world, "null world");
            Objects.requireNonNull(blockPos, "null blockPos");
            class_2586 entity = world.method_8321(blockPos);
            if (entity instanceof class_1263) {
                class_1263 inventory = (class_1263)entity;
                if (entity instanceof class_2595) {
                    class_2680 blockState = world.method_8320(blockPos);
                    class_2248 block = blockState.method_26204();
                    return class_2281.method_17458((class_2281)((class_2281)block), (class_2680)blockState, (class_1937)world, (class_2338)blockPos, (boolean)true);
                }
                return inventory;
            }
            return null;
        }

        private static boolean isValidTarget(class_1799 originStack, class_1263 targetInventory, Collection<class_2960> enchantmentMatchingIds) {
            Objects.requireNonNull(targetInventory, "inventory");
            Objects.requireNonNull(originStack, "item");
            Integer firstEmptySlot = null;
            boolean hasMatchingItem = false;
            for (int slot = 0; slot < targetInventory.method_5439(); ++slot) {
                class_1799 targetStack = Objects.requireNonNull(targetInventory.method_5438(slot));
                if (targetStack.method_7960()) {
                    if (hasMatchingItem) {
                        return true;
                    }
                    if (firstEmptySlot != null) continue;
                    firstEmptySlot = slot;
                    continue;
                }
                if (!SlotJob.isMatch(originStack, targetStack, enchantmentMatchingIds)) continue;
                if (firstEmptySlot != null) {
                    return true;
                }
                if (!SlotJob.isFull(targetStack)) {
                    return true;
                }
                hasMatchingItem = true;
            }
            return false;
        }

        private static boolean isMatch(class_1799 first, class_1799 second, Collection<class_2960> enchantmentMatchEnabledIds) {
            return first.method_31574(second.method_7909()) && (!enchantmentMatchEnabledIds.contains(class_7923.field_41178.method_10221((Object)first.method_7909())) || SlotJob.areEnchantmentsEqual(first, second));
        }

        private static boolean areEnchantmentsEqual(class_1799 left, class_1799 right) {
            if (left.method_7960() && right.method_7960()) {
                return true;
            }
            if (!left.method_7960() && !right.method_7960()) {
                return ((class_9304)left.method_58695(class_9334.field_49633, (Object)class_9304.field_49385)).equals(right.method_58695(class_9334.field_49633, (Object)class_9304.field_49385)) && ((class_9304)left.method_58695(class_9334.field_49643, (Object)class_9304.field_49385)).equals(right.method_58695(class_9334.field_49643, (Object)class_9304.field_49385)) && ((class_9299)left.method_58695(class_9334.field_49651, (Object)class_9304.field_49385)).equals(right.method_58695(class_9334.field_49651, (Object)class_9304.field_49385));
            }
            return false;
        }

        private static boolean isFull(class_1799 stack) {
            return stack.method_7947() == stack.method_7914();
        }
    }

    @FunctionalInterface
    static interface GhostCreator {
        public void createGhost(class_3218 var1, class_1792 var2, TargetContainer var3);
    }
}

