/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_bnz.compat.jei;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import uwu.lopyluna.create_bnz.content.items.zapper.BlockZapperItem;
import uwu.lopyluna.create_bnz.content.modifiers.ModifierTier;
import uwu.lopyluna.create_bnz.content.modifiers.Modifiers;
import uwu.lopyluna.create_bnz.content.recipes.ZapperRecipe;
import uwu.lopyluna.create_bnz.registry.BZItems;
import uwu.lopyluna.create_bnz.registry.BZRecipeTypes;

public final class ZapperRecipeMaker {
    private final RecipeManager recipeManager;

    public List<CraftingRecipe> createRecipes() {
        List allRecipes = this.recipeManager.m_44013_(BZRecipeTypes.ZAPPER_RECIPE.getType());
        ArrayList<CraftingRecipe> capturedRecipes = new ArrayList<CraftingRecipe>();
        for (CraftingRecipe recipe : allRecipes) {
            if (!(recipe instanceof ZapperRecipe)) continue;
            ZapperRecipe zapperRecipe = (ZapperRecipe)recipe;
            Modifiers modifier = zapperRecipe.getUpgradedComponent();
            ModifierTier tier = zapperRecipe.getTier();
            NonNullList<Ingredient> ingredients = zapperRecipe.m_7527_();
            if (tier.require_level != 0) {
                for (Ingredient ingredient : ingredients) {
                    for (ItemStack itemStack : ingredient.m_43908_()) {
                        if (!(itemStack.m_41720_() instanceof BlockZapperItem)) continue;
                        CompoundTag nbt = itemStack.m_41784_();
                        nbt.m_128405_(modifier.baseName, tier.require_level);
                        nbt.m_128379_("jeiView", true);
                        NBTHelper.writeEnum((CompoundTag)nbt, (String)"AppliedModifiers0", (Enum)modifier);
                    }
                }
            }
            ItemStack handgun = new ItemStack((ItemLike)BZItems.BLOCK_ZAPPER.get());
            handgun.m_41784_().m_128379_("jeiView", true);
            BlockZapperItem zapperItem = (BlockZapperItem)handgun.m_41720_();
            capturedRecipes.add((CraftingRecipe)new ShapedRecipe(zapperRecipe.m_6423_(), zapperRecipe.m_6076_(), CraftingBookCategory.MISC, zapperRecipe.getRecipeWidth(), zapperRecipe.getRecipeHeight(), ingredients, zapperItem.setModifierToTier(modifier, tier, handgun)));
        }
        return capturedRecipes;
    }

    public ZapperRecipeMaker() {
        Minecraft minecraft = Minecraft.m_91087_();
        this.checkNotNull(minecraft, "minecraft");
        ClientLevel world = minecraft.f_91073_;
        this.checkNotNull(world, "minecraft world");
        this.recipeManager = world.m_7465_();
    }

    public <T> void checkNotNull(@Nullable T object, String name) {
        if (object == null) {
            throw new NullPointerException(name + " must not be null.");
        }
    }
}

