/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_bnz.content.items.zapper;

import com.google.common.base.Predicates;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.equipment.zapper.PlacementPatterns;
import com.simibubi.create.content.equipment.zapper.ShootableGadgetItemMethods;
import com.simibubi.create.content.equipment.zapper.ZapperBeamPacket;
import com.simibubi.create.content.equipment.zapper.ZapperItem;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.SimpleCustomRenderer;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.gui.ScreenOpener;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.checkerframework.checker.nullness.qual.NonNull;
import uwu.lopyluna.create_bnz.BZUtils;
import uwu.lopyluna.create_bnz.config.BZConfig;
import uwu.lopyluna.create_bnz.content.items.zapper.BlockZapperItemRenderer;
import uwu.lopyluna.create_bnz.content.items.zapper.BlockZapperScreen;
import uwu.lopyluna.create_bnz.content.items.zapper.TerrainTools;
import uwu.lopyluna.create_bnz.content.items.zapper.tools.Brush;
import uwu.lopyluna.create_bnz.content.items.zapper.tools.CuboidBrush;
import uwu.lopyluna.create_bnz.content.items.zapper.tools.CylinderBrush;
import uwu.lopyluna.create_bnz.content.items.zapper.tools.DynamicBrush;
import uwu.lopyluna.create_bnz.content.items.zapper.tools.PlacementOptions;
import uwu.lopyluna.create_bnz.content.items.zapper.tools.SphereBrush;
import uwu.lopyluna.create_bnz.content.items.zapper.tools.TerrainBrushes;
import uwu.lopyluna.create_bnz.content.modifiers.ModifierTier;
import uwu.lopyluna.create_bnz.content.modifiers.Modifiers;
import uwu.lopyluna.create_bnz.registry.BZItems;

@ParametersAreNonnullByDefault
public class BlockZapperItem
extends ZapperItem {
    public static List<Modifiers> MODIFIERS = new ArrayList<Modifiers>();
    public static List<ModifierTier> TIERS = new ArrayList<ModifierTier>();
    static final String APPLIED_MODIFIER = "AppliedModifiers";
    static final String APPLIED_UPGRADES = "AppliedUpgrades";
    static final String MAX_SLOTS = "MaxSlots";
    static final String BRUSH_PARAMS = "BrushParams";
    static final String BRUSH = "Brush";
    static final String TOOL = "Tool";
    static final String PLACEMENT = "Placement";

    public BlockZapperItem(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flagIn) {
        CompoundTag nbt = stack.m_41784_();
        boolean jeiDisplay = nbt.m_128441_("jeiView");
        if (!jeiDisplay) {
            tooltip.add((Component)BZUtils.holdCtrl());
        }
        if ((!Screen.m_96638_() || jeiDisplay) && (Screen.m_96637_() || jeiDisplay)) {
            Modifiers modifiers;
            int j;
            int slots = 0;
            int maxSlots = this.getMaxModifierSlots(nbt);
            for (j = 0; j < maxSlots; ++j) {
                modifiers = (Modifiers)NBTHelper.readEnum((CompoundTag)nbt, (String)(APPLIED_MODIFIER + j), Modifiers.class);
                if (modifiers == Modifiers.EMPTY) continue;
                int tier = modifiers.getLevel(nbt);
                tooltip.add((Component)modifiers.getName().m_130946_((String)(tier != 0 ? " " + tier + "/" + modifiers.maxLevel + " Lvl" : "")).m_130948_(TooltipHelper.styleFromColor((int)modifiers.getTierFromModifier((CompoundTag)nbt).color.getRGB())));
                tooltip.add((Component)modifiers.getDescription().m_130940_(ChatFormatting.DARK_GRAY));
                ++slots;
            }
            if (!jeiDisplay) {
                for (j = 0; j < 3; ++j) {
                    modifiers = (Modifiers)NBTHelper.readEnum((CompoundTag)nbt, (String)(APPLIED_UPGRADES + j), Modifiers.class);
                    if (modifiers == Modifiers.EMPTY) continue;
                    tooltip.add((Component)modifiers.getName().m_130948_(TooltipHelper.styleFromColor((int)modifiers.getTierFromModifier((CompoundTag)nbt).color.getRGB())));
                    tooltip.add((Component)modifiers.getDescription().m_130940_(ChatFormatting.DARK_GRAY));
                }
                if (slots == 0) {
                    tooltip.add((Component)Component.m_237115_((String)"create_bnz.handheld_block_zapper.no_modifiers").m_130940_(ChatFormatting.GRAY));
                }
                tooltip.add((Component)Component.m_237119_().m_7220_((Component)Component.m_237115_((String)"create_bnz.handheld_block_zapper.modifiers").m_130946_(" ").m_130940_(ChatFormatting.DARK_GRAY)).m_7220_((Component)Component.m_237113_((String)("" + slots)).m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)"/").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)(maxSlots + ".")).m_130940_(ChatFormatting.DARK_GRAY)));
            }
        }
        if (!(Screen.m_96638_() || Screen.m_96637_() || jeiDisplay)) {
            int amount = nbt.m_128451_("Amount");
            int size = nbt.m_128451_("Size");
            int n = size = size == 999999 ? 0 : size;
            if (stack.m_41782_() && stack.m_41784_().m_128441_("BlockUsed")) {
                MutableComponent usedBlock = NbtUtils.m_247651_((HolderGetter)level.m_246945_(Registries.f_256747_), (CompoundTag)stack.m_41784_().m_128469_("BlockUsed")).m_60734_().m_49954_();
                ChatFormatting color = amount >= size ? ChatFormatting.GOLD : ChatFormatting.RED;
                tooltip.add((Component)Component.m_237119_().m_7220_((Component)CreateLang.translateDirect((String)"terrainzapper.usingBlock", (Object[])new Object[]{usedBlock.m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.DARK_GRAY)).m_7220_((Component)Component.m_237119_().m_130946_(" : ").m_130940_(ChatFormatting.DARK_GRAY)).m_7220_((Component)Component.m_237113_((String)("" + amount)).m_130940_(color)).m_7220_((Component)Component.m_237113_((String)"/").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)(size + ".")).m_130940_(ChatFormatting.DARK_GRAY)));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void openHandgunGUI(ItemStack item, InteractionHand hand) {
        ScreenOpener.open((Screen)new BlockZapperScreen(item, hand));
    }

    public Component validateUsage(ItemStack item) {
        if (!item.m_41784_().m_128441_(BRUSH_PARAMS)) {
            return CreateLang.translateDirect((String)"terrainzapper.shiftRightClickToSet", (Object[])new Object[0]);
        }
        return super.validateUsage(item);
    }

    public boolean canActivateWithoutSelectedBlock(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        TerrainTools tool = (TerrainTools)NBTHelper.readEnum((CompoundTag)tag, (String)TOOL, TerrainTools.class);
        return !tool.requiresSelectedBlock();
    }

    protected boolean activate(Level world, Player player, ItemStack item, BlockState stateToUse, BlockHitResult raytrace, CompoundTag data) {
        return false;
    }

    public float activate(BlockPos targetPos, Brush brush, PlacementOptions option, CompoundTag tag, Level world, Player player, ItemStack stack, BlockState stateToUse, BlockHitResult raytrace, CompoundTag data, BlockZapperItem zapperItem, InteractionHand hand) {
        ArrayList<BlockPos> affectedPositions = new ArrayList<BlockPos>();
        BlockPos params = this.fixSize(NbtUtils.m_129239_((CompoundTag)tag.m_128469_(BRUSH_PARAMS)), brush, stack);
        float multiplier = this.sizeMultiplier(params, brush, stack);
        TerrainTools tool = (TerrainTools)NBTHelper.readEnum((CompoundTag)tag, (String)TOOL, TerrainTools.class);
        brush.set(params.m_123341_(), params.m_123342_(), params.m_123343_());
        targetPos = targetPos.m_121955_((Vec3i)brush.getOffset(player.m_20154_(), raytrace.m_82434_(), option));
        if (tag.m_128425_("BrushOffset", 10)) {
            BlockPos offset = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("BrushOffset"));
            targetPos = targetPos.m_121955_((Vec3i)offset);
        }
        brush.addToGlobalPositions((LevelAccessor)world, targetPos, raytrace.m_82434_(), affectedPositions, tool);
        brush.redirectTool(tool).run(world, affectedPositions, stateToUse, data, player, stack, zapperItem, hand, BlockZapperItem.applyPattern(affectedPositions, stack));
        return multiplier;
    }

    public int activateCalculation(Level world, Player player, ItemStack stack, BlockState stateToUse, BlockHitResult raytrace, BlockZapperItem zapperItem) {
        BlockPos targetPos = raytrace.m_82425_();
        ArrayList<BlockPos> affectedPositions = new ArrayList<BlockPos>();
        CompoundTag tag = stack.m_41784_();
        Brush brush = ((TerrainBrushes)NBTHelper.readEnum((CompoundTag)tag, (String)BRUSH, TerrainBrushes.class)).get();
        BlockPos params = this.fixSize(NbtUtils.m_129239_((CompoundTag)tag.m_128469_(BRUSH_PARAMS)), brush, stack);
        PlacementOptions option = (PlacementOptions)NBTHelper.readEnum((CompoundTag)tag, (String)PLACEMENT, PlacementOptions.class);
        TerrainTools tool = (TerrainTools)NBTHelper.readEnum((CompoundTag)tag, (String)TOOL, TerrainTools.class);
        brush.set(params.m_123341_(), params.m_123342_(), params.m_123343_());
        targetPos = targetPos.m_121955_((Vec3i)brush.getOffset(player.m_20154_(), raytrace.m_82434_(), option));
        if (tag.m_128425_("BrushOffset", 10)) {
            BlockPos offset = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("BrushOffset"));
            targetPos = targetPos.m_121955_((Vec3i)offset);
        }
        brush.addToGlobalPositions((LevelAccessor)world, targetPos, raytrace.m_82434_(), affectedPositions, tool);
        return brush.redirectTool(tool).runCalculate(world, affectedPositions, stateToUse, stack, zapperItem);
    }

    public static PlacementPatterns applyPattern(List<BlockPos> blocksIn, ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        PlacementPatterns pattern = !tag.m_128441_("Pattern") ? PlacementPatterns.Solid : PlacementPatterns.valueOf((String)tag.m_128461_("Pattern"));
        Object filter = Predicates.alwaysFalse();
        switch (pattern) {
            case Checkered: {
                filter = pos -> (pos.m_123341_() + pos.m_123342_() + pos.m_123343_()) % 2 == 0;
                break;
            }
            case InverseCheckered: {
                filter = pos -> (pos.m_123341_() + pos.m_123342_() + pos.m_123343_()) % 2 != 0;
                break;
            }
        }
        blocksIn.removeIf((Predicate<BlockPos>)filter);
        return pattern;
    }

    public static void configureSettings(ItemStack stack, PlacementPatterns pattern, TerrainBrushes brush, int brushParamX, int brushParamY, int brushParamZ, int offsetX, int offsetY, int offsetZ, TerrainTools tool, PlacementOptions placement) {
        ZapperItem.configureSettings((ItemStack)stack, (PlacementPatterns)pattern);
        CompoundTag nbt = stack.m_41784_();
        NBTHelper.writeEnum((CompoundTag)nbt, (String)BRUSH, (Enum)brush);
        nbt.m_128365_(BRUSH_PARAMS, (Tag)NbtUtils.m_129224_((BlockPos)new BlockPos(brushParamX, brushParamY, brushParamZ)));
        nbt.m_128365_("BrushOffset", (Tag)NbtUtils.m_129224_((BlockPos)new BlockPos(offsetX, offsetY, offsetZ)));
        NBTHelper.writeEnum((CompoundTag)nbt, (String)TOOL, (Enum)tool);
        NBTHelper.writeEnum((CompoundTag)nbt, (String)PLACEMENT, (Enum)placement);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        BlockZapperItemRenderer.renderModels();
        consumer.accept((IClientItemExtensions)SimpleCustomRenderer.create((Item)this, (CustomRenderedItemModelRenderer)new BlockZapperItemRenderer()));
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        super.m_6883_(pStack, pLevel, pEntity, pSlotId, pIsSelected);
        CompoundTag nbt = pStack.m_41784_();
        if (BZItems.BLOCK_ZAPPER.isIn(pStack) && pIsSelected) {
            MODIFIERS.forEach(modifier -> modifier.update(nbt));
            int max = this.getMaxModifierSlots(nbt);
            if (!nbt.m_128441_(MAX_SLOTS) || nbt.m_128451_(MAX_SLOTS) != max) {
                nbt.m_128405_(MAX_SLOTS, max);
            }
        }
        if (pEntity instanceof Player) {
            Player player = (Player)pEntity;
            BlockState stateToUse = Blocks.f_50016_.m_49966_();
            if (nbt.m_128441_("BlockUsed")) {
                stateToUse = NbtUtils.m_247651_((HolderGetter)pLevel.m_246945_(Registries.f_256747_), (CompoundTag)nbt.m_128469_("BlockUsed"));
            }
            stateToUse = BlockHelper.setZeroAge((BlockState)stateToUse);
            Vec3 start = player.m_20182_().m_82520_(0.0, (double)player.m_20192_(), 0.0);
            Vec3 range = player.m_20154_().m_82490_((double)this.getZappingRange(pStack));
            BlockHitResult raytrace = pLevel.m_45547_(new ClipContext(start, start.m_82549_(range), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
            int invAmount = TerrainTools.calculateItemsInInventory(stateToUse.m_60734_(), true, player, nbt.m_128451_(Modifiers.GENERATOR.baseName) > 0);
            int selSize = this.activateCalculation(pLevel, player, pStack, stateToUse, raytrace, (BlockZapperItem)pStack.m_41720_());
            if (!nbt.m_128441_("Amount") || nbt.m_128451_("Amount") != invAmount) {
                nbt.m_128405_("Amount", invAmount);
            }
            if (!nbt.m_128441_("Size") || nbt.m_128451_("Size") != selSize) {
                nbt.m_128405_("Size", selSize);
            }
        }
    }

    public @NonNull Rarity m_41460_(ItemStack pStack) {
        CompoundTag nbt = pStack.m_41784_();
        int echo_slots = 0;
        for (int j = 0; j < 5; ++j) {
            if (((Modifiers)NBTHelper.readEnum((CompoundTag)nbt, (String)(APPLIED_MODIFIER + j), Modifiers.class)).getLevel(nbt) < ModifierTier.ECHO.level) continue;
            ++echo_slots;
        }
        if (echo_slots == 5) {
            return Rarity.EPIC;
        }
        if (echo_slots > 0) {
            return Rarity.RARE;
        }
        return Rarity.UNCOMMON;
    }

    public @NonNull InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        boolean lookingAtBlock;
        int size;
        ItemStack item = player.m_21120_(hand);
        CompoundTag nbt = item.m_41784_();
        boolean mainHand = hand == InteractionHand.MAIN_HAND;
        BlockState stateToUse = Blocks.f_50016_.m_49966_();
        if (nbt.m_128441_("BlockUsed")) {
            stateToUse = NbtUtils.m_247651_((HolderGetter)level.m_246945_(Registries.f_256747_), (CompoundTag)nbt.m_128469_("BlockUsed"));
        }
        stateToUse = BlockHelper.setZeroAge((BlockState)stateToUse);
        CompoundTag data = nbt.m_128469_("BlockData");
        if (nbt.m_128425_("BlockData", 10)) {
            data = nbt.m_128469_("BlockData");
        }
        Vec3 start = player.m_20182_().m_82520_(0.0, (double)player.m_20192_(), 0.0);
        Vec3 range = player.m_20154_().m_82490_((double)this.getZappingRange(item));
        BlockHitResult raytrace = level.m_45547_(new ClipContext(start, start.m_82549_(range), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        Vec3 barrelPos = ShootableGadgetItemMethods.getGunBarrelVec((Player)player, (boolean)mainHand, (Vec3)new Vec3((double)0.35f, (double)-0.1f, 1.0));
        BlockPos lookingPos = raytrace.m_82425_();
        int amount = nbt.m_128451_("Amount");
        boolean items = (amount >= (size = nbt.m_128451_("Size")) || player.m_7500_()) && size != 0 || size == 999999;
        boolean bl = lookingAtBlock = level.m_6857_().m_61937_(lookingPos) && raytrace.m_6662_() != HitResult.Type.MISS;
        if (level.f_46443_) {
            if (!(player.m_6144_() || items && lookingAtBlock)) {
                if (size != 0 && size != 999999 && lookingAtBlock) {
                    player.m_5661_((Component)Component.m_237115_((String)"create_bnz.handheld_block_zapper.not_enough_blocks").m_130946_(" " + nbt.m_128451_("Amount") + "/" + nbt.m_128451_("Size")).m_130940_(ChatFormatting.RED), true);
                }
                AllSoundEvents.DENY.play(level, player, (Vec3i)player.m_20183_());
                return new InteractionResultHolder(InteractionResult.FAIL, (Object)item);
            }
            CreateClient.ZAPPER_RENDER_HANDLER.dontAnimateItem(hand);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)item);
        }
        if (!(player.m_6144_() || items && lookingAtBlock)) {
            player.m_36335_().m_41524_(item.m_41720_(), 10);
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)item);
        }
        if (!player.m_6144_() && items && lookingAtBlock) {
            Vec3 target = raytrace.m_82450_();
            BlockPos targetPos = raytrace.m_82425_();
            CompoundTag tag = item.m_41784_();
            Brush brush = ((TerrainBrushes)NBTHelper.readEnum((CompoundTag)tag, (String)BRUSH, TerrainBrushes.class)).get();
            PlacementOptions option = (PlacementOptions)NBTHelper.readEnum((CompoundTag)tag, (String)PLACEMENT, PlacementOptions.class);
            float multiplier = this.activate(targetPos, brush, option, tag, level, player, item, stateToUse, raytrace, data, (BlockZapperItem)item.m_41720_(), hand);
            targetPos = targetPos.m_121955_((Vec3i)brush.getOffset(player.m_20154_(), raytrace.m_82434_(), option));
            if (tag.m_128425_("BrushOffset", 10)) {
                BlockPos offset = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("BrushOffset"));
                target = targetPos.m_121955_((Vec3i)offset).m_252807_();
            }
            int cooldown = (int)(multiplier * (float)this.getCooldownDelay(item));
            ShootableGadgetItemMethods.applyCooldown((Player)player, (ItemStack)item, (InteractionHand)hand, arg_0 -> ((BlockZapperItem)this).isZapper(arg_0), (int)Math.max(cooldown, 5));
            Vec3 finalTarget = target;
            ShootableGadgetItemMethods.sendPackets((Player)player, b -> new ZapperBeamPacket(barrelPos, finalTarget, hand, b.booleanValue()));
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)item);
        }
        return super.m_7203_(level, player, hand);
    }

    public ItemStack setModifierToTier(Modifiers modifier, ModifierTier tier, ItemStack pStack) {
        CompoundTag nbt = pStack.m_41784_();
        String id = modifier.baseName;
        nbt.m_128405_(id, tier.require_level + 1);
        NBTHelper.writeEnum((CompoundTag)nbt, (String)"AppliedModifiers0", (Enum)modifier);
        return pStack;
    }

    public int applyModifier(Modifiers modifier, ItemStack pStack) {
        if (modifier.isUpgrade) {
            return this.applyUpgrade(modifier, pStack);
        }
        CompoundTag nbt = pStack.m_41784_();
        String id = modifier.baseName;
        modifier.update(nbt);
        int i = modifier.getLevel(nbt);
        int f = 2;
        for (int j = 0; j < this.getMaxModifierSlots(nbt); ++j) {
            String slot = APPLIED_MODIFIER + j;
            Modifiers modifiers = (Modifiers)NBTHelper.readEnum((CompoundTag)nbt, (String)slot, Modifiers.class);
            if (modifiers == modifier && i < modifier.maxLevel) {
                if (i + 1 == modifier.maxLevel) {
                    f = 3;
                }
                nbt.m_128405_(id, i + 1);
                return f;
            }
            if (modifiers == modifier) {
                return 0;
            }
            if (modifiers != Modifiers.EMPTY) continue;
            NBTHelper.writeEnum((CompoundTag)nbt, (String)slot, (Enum)modifier);
            nbt.m_128405_(id, 1);
            return 1;
        }
        return 0;
    }

    public int applyUpgrade(Modifiers modifier, ItemStack pStack) {
        CompoundTag nbt = pStack.m_41784_();
        String id = modifier.baseName;
        int i = modifier.getLevel(nbt);
        int max = modifier.maxLevel;
        for (int j = 0; j < 3; ++j) {
            String upgrades = APPLIED_UPGRADES + j;
            Modifiers modifiers = (Modifiers)NBTHelper.readEnum((CompoundTag)nbt, (String)upgrades, Modifiers.class);
            if (modifiers != Modifiers.EMPTY) continue;
            NBTHelper.writeEnum((CompoundTag)nbt, (String)upgrades, (Enum)modifier);
            break;
        }
        int f = 4;
        if (i < max) {
            if (i + 1 == max) {
                f = 5;
            }
            nbt.m_128405_(id, i + 1);
            return f;
        }
        return 0;
    }

    public BlockPos fixSize(BlockPos params, Brush brush, ItemStack stack) {
        int size = this.getMaxSize(stack);
        int radius = this.getMaxRadius(stack);
        int radiusSize = (int)((double)radius * 1.25);
        int max = 1;
        if (brush instanceof CuboidBrush) {
            max = size;
        }
        if (brush instanceof SphereBrush) {
            max = radiusSize;
        }
        if (brush instanceof CylinderBrush) {
            max = radius;
        }
        if (brush instanceof DynamicBrush) {
            max = radiusSize;
        }
        int x = Math.min(params.m_123341_(), max);
        int y = Math.min(params.m_123342_(), max);
        int z = Math.min(params.m_123343_(), max);
        return new BlockPos(x, y, z);
    }

    public float sizeMultiplier(BlockPos params, Brush brush, ItemStack stack) {
        float size = this.getMaxSize(stack);
        float radius = this.getMaxRadius(stack);
        float radiusSize = (int)((double)radius * 1.25);
        float max = 1.0f;
        if (brush instanceof CuboidBrush) {
            max = size;
        }
        if (brush instanceof SphereBrush) {
            max = radiusSize;
        }
        if (brush instanceof CylinderBrush) {
            max = radius;
        }
        if (brush instanceof DynamicBrush) {
            max = radiusSize;
        }
        float x = params.m_123341_();
        float y = params.m_123342_();
        float z = params.m_123343_();
        return x * y * z / (max * max * max);
    }

    public int indexMax(int index, Brush brush, ItemStack stack) {
        int size = this.getMaxSize(stack);
        int radius = this.getMaxRadius(stack);
        int radiusSize = (int)((double)radius * 1.25);
        int max = 1;
        if (brush instanceof CuboidBrush) {
            max = size;
        }
        if (brush instanceof SphereBrush) {
            max = radiusSize;
        }
        if (brush instanceof CylinderBrush) {
            max = radius;
        }
        if (brush instanceof DynamicBrush) {
            max = radiusSize;
        }
        return Math.min(index, max);
    }

    public int[] fixSize(int[] params, Brush brush, ItemStack stack) {
        int size = this.getMaxSize(stack);
        int radius = this.getMaxRadius(stack);
        int radiusSize = (int)((double)radius * 1.25);
        int max = 1;
        if (brush instanceof CuboidBrush) {
            max = size;
        }
        if (brush instanceof SphereBrush) {
            max = radiusSize;
        }
        if (brush instanceof CylinderBrush) {
            max = radius;
        }
        if (brush instanceof DynamicBrush) {
            max = radiusSize;
        }
        int x = Math.min(params[0], max);
        int y = Math.min(params[1], max);
        int z = Math.min(params[2], max);
        return new int[]{x, y, z};
    }

    public int getMaxSize(ItemStack pStack) {
        CompoundTag nbt = pStack.m_41784_();
        return switch (Modifiers.AMPLIFIER.getLevel(nbt)) {
            case 1 -> (Integer)BZConfig.BZCommonConfig.AMPLIFIER_LEVEL_1_MAX_SIZE.get();
            case 2 -> (Integer)BZConfig.BZCommonConfig.AMPLIFIER_LEVEL_2_MAX_SIZE.get();
            case 3 -> (Integer)BZConfig.BZCommonConfig.AMPLIFIER_LEVEL_3_MAX_SIZE.get();
            case 4 -> (Integer)BZConfig.BZCommonConfig.AMPLIFIER_LEVEL_4_MAX_SIZE.get();
            default -> (Integer)BZConfig.BZCommonConfig.AMPLIFIER_DEFAULT_MAX_SIZE.get();
        };
    }

    public int getMaxRadius(ItemStack pStack) {
        CompoundTag nbt = pStack.m_41784_();
        return switch (Modifiers.AMPLIFIER.getLevel(nbt)) {
            case 1 -> (Integer)BZConfig.BZCommonConfig.AMPLIFIER_LEVEL_1_MAX_RADIUS.get();
            case 2 -> (Integer)BZConfig.BZCommonConfig.AMPLIFIER_LEVEL_2_MAX_RADIUS.get();
            case 3 -> (Integer)BZConfig.BZCommonConfig.AMPLIFIER_LEVEL_3_MAX_RADIUS.get();
            case 4 -> (Integer)BZConfig.BZCommonConfig.AMPLIFIER_LEVEL_4_MAX_RADIUS.get();
            default -> (Integer)BZConfig.BZCommonConfig.AMPLIFIER_DEFAULT_MAX_RADIUS.get();
        };
    }

    public int getHardnessSupport(ItemStack pStack) {
        CompoundTag nbt = pStack.m_41784_();
        return switch (Modifiers.BODY.getLevel(nbt)) {
            case 1 -> (Integer)BZConfig.BZCommonConfig.BODY_LEVEL_1_HARDNESS.get();
            case 2 -> (Integer)BZConfig.BZCommonConfig.BODY_LEVEL_2_HARDNESS.get();
            case 3 -> (Integer)BZConfig.BZCommonConfig.BODY_LEVEL_3_HARDNESS.get();
            case 4 -> (Integer)BZConfig.BZCommonConfig.BODY_LEVEL_4_HARDNESS.get();
            default -> (Integer)BZConfig.BZCommonConfig.BODY_DEFAULT_HARDNESS.get();
        };
    }

    public int getMaxModifierSlots(CompoundTag nbt) {
        return nbt.m_128451_(Modifiers.APPLICATOR.baseName) > 0 ? (Integer)BZConfig.BZCommonConfig.APPLICATOR_UPGRADED_SLOTS.get() : (Integer)BZConfig.BZCommonConfig.APPLICATOR_BASE_SLOTS.get();
    }

    public boolean isDamageable(ItemStack pStack) {
        CompoundTag nbt = pStack.m_41784_();
        return (Boolean)BZConfig.BZCommonConfig.REINFORCER_LEVEL_4_UNBREAKABLE.get() == false || Modifiers.REINFORCER.getLevel(nbt) < 4;
    }

    public int getMaxDamage(ItemStack pStack) {
        CompoundTag nbt = pStack.m_41784_();
        int level = Modifiers.REINFORCER.getLevel(nbt);
        int baseDurability = (Integer)BZConfig.BZCommonConfig.REINFORCER_BASE_DURABILITY.get();
        return switch (level) {
            case 1 -> baseDurability * (Integer)BZConfig.BZCommonConfig.REINFORCER_LEVEL_1_MULTIPLIER.get() / 100;
            case 2 -> baseDurability * (Integer)BZConfig.BZCommonConfig.REINFORCER_LEVEL_2_MULTIPLIER.get() / 100;
            case 3 -> baseDurability * (Integer)BZConfig.BZCommonConfig.REINFORCER_LEVEL_3_MULTIPLIER.get() / 100;
            case 4 -> baseDurability * (Integer)BZConfig.BZCommonConfig.REINFORCER_LEVEL_4_MULTIPLIER.get() / 100;
            default -> baseDurability;
        };
    }

    public int getZappingRange(ItemStack pStack) {
        CompoundTag nbt = pStack.m_41784_();
        int baseRange = (Integer)BZConfig.BZCommonConfig.SCOPE_BASE_RANGE.get();
        int multiplier = (Integer)BZConfig.BZCommonConfig.SCOPE_RANGE_MULTIPLIER.get();
        return baseRange + multiplier * Modifiers.SCOPE.getLevel(nbt);
    }

    public int getCooldownDelay(ItemStack pStack) {
        CompoundTag nbt = pStack.m_41784_();
        int baseCooldown = switch (Modifiers.ACCELERATOR.getLevel(nbt)) {
            case 1 -> (Integer)BZConfig.BZCommonConfig.ACCELERATOR_LEVEL_1_COOLDOWN.get();
            case 2 -> (Integer)BZConfig.BZCommonConfig.ACCELERATOR_LEVEL_2_COOLDOWN.get();
            case 3 -> (Integer)BZConfig.BZCommonConfig.ACCELERATOR_LEVEL_3_COOLDOWN.get();
            case 4 -> (Integer)BZConfig.BZCommonConfig.ACCELERATOR_LEVEL_4_COOLDOWN.get();
            default -> (Integer)BZConfig.BZCommonConfig.ACCELERATOR_DEFAULT_COOLDOWN.get();
        };
        int efficiencyLevel = pStack.getEnchantmentLevel(Enchantments.f_44984_);
        if (efficiencyLevel > 0) {
            baseCooldown = (int)((double)baseCooldown * (1.0 - (double)efficiencyLevel * 0.1));
        }
        return Math.max(baseCooldown, 1);
    }

    public boolean m_8120_(ItemStack stack) {
        return true;
    }

    public int m_6473_() {
        return 15;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.f_44985_ || enchantment == Enchantments.f_44987_ || enchantment == Enchantments.f_44984_ || enchantment == Enchantments.f_44986_ || enchantment == Enchantments.f_44962_ || enchantment == Enchantments.f_44963_;
    }
}

