/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_bnz.content.items.zapper;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.equipment.zapper.ZapperItemRenderer;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModel;
import com.simibubi.create.foundation.item.render.PartialItemModelRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import uwu.lopyluna.create_bnz.CreateBZ;
import uwu.lopyluna.create_bnz.content.modifiers.ModifierTier;
import uwu.lopyluna.create_bnz.content.modifiers.Modifiers;
import uwu.lopyluna.create_bnz.infrastructure.ZapperModel;

public class BlockZapperItemRenderer
extends ZapperItemRenderer {
    protected static final PartialModel CORE = PartialModel.of((ResourceLocation)CreateBZ.loc("item/handheld_block_zapper/core"));
    protected static final PartialModel CORE_GLOW = PartialModel.of((ResourceLocation)CreateBZ.loc("item/handheld_block_zapper/core_glow"));
    protected static final PartialModel CORE_BULK = PartialModel.of((ResourceLocation)CreateBZ.loc("item/handheld_block_zapper/augments/glow/core_bulk"));
    protected static final PartialModel CORE_GLOW_BULK = PartialModel.of((ResourceLocation)CreateBZ.loc("item/handheld_block_zapper/augments/glow/core_glow_bulk"));
    public static List<ZapperModel> MODELS = new ArrayList<ZapperModel>();

    protected void render(ItemStack stack, CustomRenderedItemModel model, PartialItemModelRenderer renderer, ItemDisplayContext transformType, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.render(stack, model, renderer, transformType, ms, buffer, light, overlay);
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player != null) {
            int glowLight;
            CompoundTag nbt = stack.m_41784_();
            float pt = AnimationTickHolder.getPartialTicks();
            float worldTime = AnimationTickHolder.getRenderTime() / 20.0f;
            float cooldown = player.m_36335_().m_41521_(stack.m_41720_(), mc.m_91296_());
            renderer.renderSolid(model.getOriginalModel(), light);
            this.renderSolidModifierModel(renderer, Modifiers.BODY, nbt, light, false);
            this.renderSolidModifierModel(renderer, Modifiers.AMPLIFIER, nbt, light, true);
            this.renderSolidModifierModel(renderer, Modifiers.RETRIEVER, nbt, light, true);
            this.renderSolidModifierModel(renderer, Modifiers.SCOPE, nbt, light, true);
            this.renderSolidModifierModel(renderer, Modifiers.REINFORCER, nbt, light, true);
            boolean leftHanded = player.m_5737_() == HumanoidArm.LEFT;
            boolean mainHand = player.m_21205_() == stack;
            boolean offHand = player.m_21206_() == stack;
            float animation = this.getAnimationProgress(pt, leftHanded, mainHand);
            int lightIntensity = (int)(15.0f * Mth.m_14036_((float)Mth.m_14031_((float)(worldTime * 5.0f)), (float)0.0f, (float)1.0f));
            if (mainHand || offHand) {
                lightIntensity = 15 - (int)(15.0f * Mth.m_14036_((float)cooldown, (float)0.0f, (float)1.0f));
            }
            glowLight = (double)((glowLight = LightTexture.m_109885_((int)lightIntensity, (int)Math.max(lightIntensity, 4))) - 1) > (double)glowLight * 0.5 ? glowLight - 1 : glowLight;
            renderer.renderSolidGlowing(CORE.get(), glowLight);
            renderer.renderGlowing(CORE_GLOW.get(), glowLight);
            if (Modifiers.AMPLIFIER.getLevel(nbt) > 0) {
                renderer.renderSolidGlowing(CORE_BULK.get(), glowLight);
                renderer.renderGlowing(CORE_GLOW_BULK.get(), glowLight);
            }
            float angle = worldTime * -25.0f;
            if (mainHand || offHand) {
                angle += 360.0f * animation;
            }
            float offset = -0.155f;
            ms.m_252880_(0.0f, offset, 0.0f);
            ms.m_252781_(Axis.f_252403_.m_252977_(angle %= 360.0f));
            ms.m_252880_(0.0f, -offset, 0.0f);
            this.renderModifierModel(renderer, Modifiers.ACCELERATOR, nbt, light, false);
        }
    }

    public void renderModifierModel(PartialItemModelRenderer renderer, Modifiers modifiers, CompoundTag nbt, int light, boolean ignoreDefault) {
        ModifierTier tier = modifiers.getTierFromModifier(nbt);
        if (tier.isntTier() && ignoreDefault) {
            return;
        }
        Optional<ZapperModel> z = MODELS.stream().filter(m -> m.get(modifiers, tier)).findFirst();
        z.ifPresent(zModel -> renderer.render(zModel.get(), light));
    }

    public void renderSolidModifierModel(PartialItemModelRenderer renderer, Modifiers modifiers, CompoundTag nbt, int light, boolean ignoreDefault) {
        ModifierTier tier = modifiers.getTierFromModifier(nbt);
        if (tier.isntTier() && ignoreDefault) {
            return;
        }
        Optional<ZapperModel> z = MODELS.stream().filter(m -> m.get(modifiers, tier)).findFirst();
        z.ifPresent(zModel -> renderer.renderSolid(zModel.get(), light));
    }

    protected float getAnimationProgress(float pt, boolean leftHanded, boolean mainHand) {
        float animation = CreateClient.ZAPPER_RENDER_HANDLER.getAnimation(mainHand ^ leftHanded, pt);
        return Mth.m_14036_((float)(animation * 2.5f), (float)0.0f, (float)1.0f);
    }

    public static void renderModels() {
        String path = "item/handheld_block_zapper/augments/";
        for (Modifiers modifier : Modifiers.values()) {
            for (ModifierTier tier : ModifierTier.values()) {
                if (modifier == Modifiers.EMPTY || (!modifier.isUpgrade || tier != ModifierTier.SPECIAL) && (modifier.isUpgrade || tier == ModifierTier.SPECIAL)) continue;
                String tierPath = tier == ModifierTier.NONE ? "" : tier.id + "/";
                String augPath = path + tierPath + modifier.id;
                MODELS.add(new ZapperModel(PartialModel.of((ResourceLocation)CreateBZ.loc(augPath)), modifier, tier));
            }
        }
    }
}

