/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_bnz.content.items.zapper;

import com.simibubi.create.AllSpecialTextures;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import net.createmod.catnip.nbt.NBTHelper;
import net.createmod.catnip.outliner.Outliner;
import net.createmod.catnip.render.BindableTexture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import uwu.lopyluna.create_bnz.content.items.zapper.BlockZapperItem;
import uwu.lopyluna.create_bnz.content.items.zapper.TerrainTools;
import uwu.lopyluna.create_bnz.content.items.zapper.tools.Brush;
import uwu.lopyluna.create_bnz.content.items.zapper.tools.PlacementOptions;
import uwu.lopyluna.create_bnz.content.items.zapper.tools.TerrainBrushes;
import uwu.lopyluna.create_bnz.registry.BZItems;

public class BlockZapperRenderHandler {
    private static Supplier<Collection<BlockPos>> renderedPositions;

    public static void tick() {
        BlockZapperRenderHandler.gatherSelectedBlocks();
        if (renderedPositions == null) {
            return;
        }
        Outliner.getInstance().showCluster((Object)"terrainZapper", (Iterable)renderedPositions.get()).colored(0xBFBFBF).disableLineNormals().lineWidth(0.03125f).withFaceTexture((BindableTexture)AllSpecialTextures.CHECKERED);
    }

    protected static void gatherSelectedBlocks() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            CompoundTag tag;
            ItemStack heldMain = player.m_21205_();
            ItemStack heldOff = player.m_21206_();
            boolean zapperInMain = BZItems.BLOCK_ZAPPER.isIn(heldMain);
            boolean zapperInOff = BZItems.BLOCK_ZAPPER.isIn(heldOff);
            if (!(!zapperInMain || (tag = heldMain.m_41784_()).m_128441_("_Swap") && zapperInOff)) {
                BlockZapperRenderHandler.createBrushOutline(tag, player, heldMain);
                return;
            }
            if (zapperInOff) {
                tag = heldOff.m_41784_();
                BlockZapperRenderHandler.createBrushOutline(tag, player, heldOff);
                return;
            }
            renderedPositions = null;
        }
    }

    public static void createBrushOutline(CompoundTag tag, LocalPlayer player, ItemStack held) {
        if (!tag.m_128441_("BrushParams")) {
            renderedPositions = null;
            return;
        }
        Level level = player.m_9236_();
        BlockZapperItem zapperItem = (BlockZapperItem)held.m_41720_();
        Brush brush = ((TerrainBrushes)NBTHelper.readEnum((CompoundTag)tag, (String)"Brush", TerrainBrushes.class)).get();
        PlacementOptions placement = (PlacementOptions)NBTHelper.readEnum((CompoundTag)tag, (String)"Placement", PlacementOptions.class);
        TerrainTools tool = (TerrainTools)NBTHelper.readEnum((CompoundTag)tag, (String)"Tool", TerrainTools.class);
        BlockPos params = zapperItem.fixSize(NbtUtils.m_129239_((CompoundTag)tag.m_128469_("BrushParams")), brush, held);
        brush.set(params.m_123341_(), params.m_123342_(), params.m_123343_());
        Vec3 start = player.m_20182_().m_82520_(0.0, (double)player.m_20192_(), 0.0);
        Vec3 range = player.m_20154_().m_82490_((double)zapperItem.getZappingRange(held));
        BlockHitResult raytrace = level.m_45547_(new ClipContext(start, start.m_82549_(range), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        if (raytrace.m_6662_() == HitResult.Type.MISS) {
            renderedPositions = null;
            return;
        }
        BlockPos pos = raytrace.m_82425_().m_121955_((Vec3i)brush.getOffset(player.m_20154_(), raytrace.m_82434_(), placement));
        if (tag.m_128425_("BrushOffset", 10)) {
            BlockPos offset = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("BrushOffset"));
            pos = pos.m_121955_((Vec3i)offset);
        }
        BlockPos finalPos = pos;
        renderedPositions = () -> brush.addToGlobalPositions((LevelAccessor)level, finalPos, raytrace.m_82434_(), new ArrayList<BlockPos>(), tool);
    }
}

