/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_bnz.content.items.zapper;

import com.simibubi.create.content.equipment.zapper.ConfigureZapperPacket;
import com.simibubi.create.content.equipment.zapper.PlacementPatterns;
import com.simibubi.create.content.equipment.zapper.ZapperScreen;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.Indicator;
import com.simibubi.create.foundation.gui.widget.Label;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.simibubi.create.foundation.gui.widget.SelectionScrollInput;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import java.util.Vector;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.gui.element.ScreenElement;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import uwu.lopyluna.create_bnz.content.items.zapper.BlockZapperItem;
import uwu.lopyluna.create_bnz.content.items.zapper.ConfigureBlockZapperPacket;
import uwu.lopyluna.create_bnz.content.items.zapper.TerrainTools;
import uwu.lopyluna.create_bnz.content.items.zapper.tools.Brush;
import uwu.lopyluna.create_bnz.content.items.zapper.tools.PlacementOptions;
import uwu.lopyluna.create_bnz.content.items.zapper.tools.TerrainBrushes;
import uwu.lopyluna.create_bnz.registry.BZGuiTexture;
import uwu.lopyluna.create_bnz.registry.BZPackets;

public class BlockZapperScreen
extends ZapperScreen {
    protected BZGuiTexture background;
    protected final Component placementSection = CreateLang.translateDirect((String)"gui.terrainzapper.placement", (Object[])new Object[0]);
    protected final Component toolSection = CreateLang.translateDirect((String)"gui.terrainzapper.tool", (Object[])new Object[0]);
    protected final List<Component> brushOptions = CreateLang.translatedOptions((String)"gui.terrainzapper.brush", (String[])new String[]{"cuboid", "sphere", "cylinder", "surface", "cluster"});
    protected Vector<IconButton> toolButtons;
    protected Vector<IconButton> placementButtons;
    protected ScrollInput brushInput;
    protected Label brushLabel;
    protected Vector<ScrollInput> brushParams = new Vector(3);
    protected Vector<Label> brushParamLabels = new Vector(3);
    protected Vector<ScrollInput> offsetParams = new Vector(3);
    protected Vector<Label> offsetParamLabels = new Vector(3);
    protected IconButton followDiagonals;
    protected IconButton acrossMaterials;
    protected Indicator followDiagonalsIndicator;
    protected Indicator acrossMaterialsIndicator;
    protected TerrainBrushes currentBrush;
    protected int[] currentBrushParams = new int[]{1, 1, 1};
    protected int[] currentOffsetParams = new int[]{0, 0, 0};
    protected boolean currentFollowDiagonals;
    protected boolean currentAcrossMaterials;
    protected TerrainTools currentTool;
    protected PlacementOptions currentPlacement;

    public BlockZapperScreen(ItemStack zapper, InteractionHand hand) {
        super(AllGuiTextures.TERRAINZAPPER, zapper, hand);
        this.background = BZGuiTexture.BLOCK_ZAPPER;
        this.fontColor = 0x767676;
        this.title = zapper.m_41786_();
        CompoundTag nbt = zapper.m_41784_();
        this.currentBrush = (TerrainBrushes)NBTHelper.readEnum((CompoundTag)nbt, (String)"Brush", TerrainBrushes.class);
        if (nbt.m_128425_("BrushParams", 10)) {
            BlockPos paramsData = ((BlockZapperItem)this.zapper.m_41720_()).fixSize(NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("BrushParams")), this.currentBrush.get(), this.zapper);
            this.currentBrushParams[0] = paramsData.m_123341_();
            this.currentBrushParams[1] = paramsData.m_123342_();
            this.currentBrushParams[2] = paramsData.m_123343_();
            if (this.currentBrushParams[1] == 0) {
                this.currentFollowDiagonals = true;
            }
            if (this.currentBrushParams[2] == 0) {
                this.currentAcrossMaterials = true;
            }
        }
        if (nbt.m_128425_("BrushOffset", 10)) {
            BlockPos offsetData = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("BrushOffset"));
            this.currentOffsetParams[0] = offsetData.m_123341_();
            this.currentOffsetParams[1] = offsetData.m_123342_();
            this.currentOffsetParams[2] = offsetData.m_123343_();
        }
        this.currentTool = (TerrainTools)NBTHelper.readEnum((CompoundTag)nbt, (String)"Tool", TerrainTools.class);
        this.currentPlacement = (PlacementOptions)NBTHelper.readEnum((CompoundTag)nbt, (String)"Placement", PlacementOptions.class);
    }

    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int x = this.guiLeft;
        int y = this.guiTop;
        this.background.render(graphics, x, y);
        this.drawOnBackground(graphics, x, y);
        this.renderBlock(graphics, x, y);
        this.renderZapper(graphics, x, y);
    }

    protected void renderZapper(GuiGraphics graphics, int x, int y) {
        GuiGameElement.of((ItemStack)this.zapper).scale(4.0).at((float)(x + this.background.width), (float)(y + this.background.height - 48), -200.0f).render(graphics);
    }

    protected void m_7856_() {
        this.setWindowSize(this.background.width, this.background.height);
        this.setWindowOffset(-10, 0);
        this.guiLeft = (this.f_96543_ - this.windowWidth) / 2;
        this.guiTop = (this.f_96544_ - this.windowHeight) / 2;
        this.guiLeft += this.windowXOffset;
        this.guiTop += this.windowYOffset;
        this.animationProgress = 0.0f;
        int x = this.guiLeft;
        int y = this.guiTop;
        IconButton confirmButton = new IconButton(x + this.background.width - 33, y + this.background.height - 24, (ScreenElement)AllIcons.I_CONFIRM);
        confirmButton.withCallback(() -> ((BlockZapperScreen)this).m_7379_());
        this.m_142416_((GuiEventListener)confirmButton);
        this.patternButtons.clear();
        for (int row = 0; row <= 1; ++row) {
            for (int col = 0; col <= 2; ++col) {
                int id = this.patternButtons.size();
                PlacementPatterns pattern = PlacementPatterns.values()[id];
                IconButton patternButton = new IconButton(x + this.background.width - 76 + col * 18, y + 21 + row * 18, (ScreenElement)pattern.icon);
                patternButton.withCallback(() -> {
                    this.patternButtons.forEach(b -> {
                        b.green = false;
                    });
                    patternButton.green = true;
                    this.currentPattern = pattern;
                });
                patternButton.setToolTip((Component)CreateLang.translateDirect((String)("gui.terrainzapper.pattern." + pattern.translationKey), (Object[])new Object[0]));
                this.patternButtons.add(patternButton);
            }
        }
        ((IconButton)this.patternButtons.get((int)this.currentPattern.ordinal())).green = true;
        this.addRenderableWidgets(this.patternButtons);
        this.brushLabel = new Label(x + 61, y + 25, CommonComponents.f_237098_).withShadow();
        this.brushInput = new SelectionScrollInput(x + 56, y + 20, 77, 18).forOptions(this.brushOptions).titled(CreateLang.translateDirect((String)"gui.terrainzapper.brush", (Object[])new Object[0])).writingTo(this.brushLabel).calling(brushIndex -> {
            this.currentBrush = TerrainBrushes.values()[brushIndex];
            this.initBrushParams(x, y);
        });
        this.brushInput.setState(this.currentBrush.ordinal());
        this.m_142416_((GuiEventListener)this.brushLabel);
        this.m_142416_((GuiEventListener)this.brushInput);
        this.initBrushParams(x, y);
        this.initOffsetParams(x, y);
    }

    protected void initBrushParams(int x, int y) {
        Brush currentBrush = this.currentBrush.get();
        BlockZapperItem zapperItem = (BlockZapperItem)this.zapper.m_41720_();
        this.removeWidgets(this.brushParamLabels);
        this.removeWidgets(this.brushParams);
        this.brushParamLabels.clear();
        this.brushParams.clear();
        for (int index = 0; index < 3; ++index) {
            Label label = new Label(x + 65 + 20 * index, y + 45, CommonComponents.f_237098_).withShadow();
            int finalIndex = index;
            ScrollInput input = new ScrollInput(x + 56 + 20 * index, y + 40, 18, 18).withRange(currentBrush.getMin(index), zapperItem.indexMax(currentBrush.getMax(index), currentBrush, this.zapper) + 1).writingTo(label).titled(currentBrush.getParamLabel(index).m_6879_()).calling(state -> {
                this.currentBrushParams[finalIndex] = state;
                label.m_252865_(x + 65 + 20 * finalIndex - this.f_96547_.m_92852_((FormattedText)label.text) / 2);
            });
            input.setState(this.currentBrushParams[index]);
            input.onChanged();
            if (index >= currentBrush.amtParams) {
                input.f_93624_ = false;
                label.f_93624_ = false;
                input.f_93623_ = false;
            }
            this.brushParamLabels.add(label);
            this.brushParams.add(input);
        }
        this.addRenderableWidgets(this.brushParamLabels);
        this.addRenderableWidgets(this.brushParams);
        if (this.followDiagonals != null) {
            this.m_169411_((GuiEventListener)this.followDiagonals);
            this.m_169411_((GuiEventListener)this.followDiagonalsIndicator);
            this.m_169411_((GuiEventListener)this.acrossMaterials);
            this.m_169411_((GuiEventListener)this.acrossMaterialsIndicator);
            this.followDiagonals = null;
            this.followDiagonalsIndicator = null;
            this.acrossMaterials = null;
            this.acrossMaterialsIndicator = null;
        }
        if (currentBrush.hasConnectivityOptions()) {
            int x1 = x + 7 + 72;
            int y1 = y + 79;
            this.followDiagonalsIndicator = new Indicator(x1, y1 - 6, CommonComponents.f_237098_);
            this.followDiagonals = new IconButton(x1, y1, (ScreenElement)AllIcons.I_FOLLOW_DIAGONAL);
            this.acrossMaterialsIndicator = new Indicator(x1 += 18, y1 - 6, CommonComponents.f_237098_);
            this.acrossMaterials = new IconButton(x1, y1, (ScreenElement)AllIcons.I_FOLLOW_MATERIAL);
            this.followDiagonals.withCallback(() -> {
                this.followDiagonalsIndicator.state = this.followDiagonalsIndicator.state == Indicator.State.OFF ? Indicator.State.ON : Indicator.State.OFF;
                this.currentFollowDiagonals = !this.currentFollowDiagonals;
            });
            this.followDiagonals.setToolTip((Component)CreateLang.translateDirect((String)"gui.terrainzapper.searchDiagonal", (Object[])new Object[0]));
            this.acrossMaterials.withCallback(() -> {
                this.acrossMaterialsIndicator.state = this.acrossMaterialsIndicator.state == Indicator.State.OFF ? Indicator.State.ON : Indicator.State.OFF;
                this.currentAcrossMaterials = !this.currentAcrossMaterials;
            });
            this.acrossMaterials.setToolTip((Component)CreateLang.translateDirect((String)"gui.terrainzapper.searchFuzzy", (Object[])new Object[0]));
            this.m_142416_((GuiEventListener)this.followDiagonals);
            this.m_142416_((GuiEventListener)this.followDiagonalsIndicator);
            this.m_142416_((GuiEventListener)this.acrossMaterials);
            this.m_142416_((GuiEventListener)this.acrossMaterialsIndicator);
            if (this.currentFollowDiagonals) {
                this.followDiagonalsIndicator.state = Indicator.State.ON;
            }
            if (this.currentAcrossMaterials) {
                this.acrossMaterialsIndicator.state = Indicator.State.ON;
            }
        }
        if (this.toolButtons != null) {
            this.removeWidgets(this.toolButtons);
        }
        TerrainTools[] toolValues = currentBrush.getSupportedTools();
        this.toolButtons = new Vector(toolValues.length);
        for (int id = 0; id < toolValues.length; ++id) {
            TerrainTools tool = toolValues[id];
            IconButton toolButton = new IconButton(x + 7 + id * 18, y + 99, (ScreenElement)tool.icon);
            toolButton.withCallback(() -> {
                this.toolButtons.forEach(b -> {
                    b.green = false;
                });
                toolButton.green = true;
                this.currentTool = tool;
            });
            toolButton.setToolTip((Component)CreateLang.translateDirect((String)("gui.terrainzapper.tool." + tool.translationKey), (Object[])new Object[0]));
            this.toolButtons.add(toolButton);
        }
        int toolIndex = -1;
        for (int i = 0; i < toolValues.length; ++i) {
            if (this.currentTool != toolValues[i]) continue;
            toolIndex = i;
        }
        if (toolIndex == -1) {
            this.currentTool = toolValues[0];
            toolIndex = 0;
        }
        this.toolButtons.get((int)toolIndex).green = true;
        this.addRenderableWidgets(this.toolButtons);
        if (this.placementButtons != null) {
            this.removeWidgets(this.placementButtons);
        }
        if (currentBrush.hasPlacementOptions()) {
            PlacementOptions[] placementValues = PlacementOptions.values();
            this.placementButtons = new Vector(placementValues.length);
            for (int id = 0; id < placementValues.length; ++id) {
                PlacementOptions option = placementValues[id];
                IconButton placementButton = new IconButton(x + 136 + id * 18, y + 99, (ScreenElement)option.icon);
                placementButton.withCallback(() -> {
                    this.placementButtons.forEach(b -> {
                        b.green = false;
                    });
                    placementButton.green = true;
                    this.currentPlacement = option;
                });
                placementButton.setToolTip((Component)CreateLang.translateDirect((String)("gui.terrainzapper.placement." + option.translationKey), (Object[])new Object[0]));
                this.placementButtons.add(placementButton);
            }
            this.placementButtons.get((int)this.currentPlacement.ordinal()).green = true;
            this.addRenderableWidgets(this.placementButtons);
        }
    }

    protected void initOffsetParams(int x, int y) {
        Brush currentBrush = this.currentBrush.get();
        BlockZapperItem zapperItem = (BlockZapperItem)this.zapper.m_41720_();
        this.removeWidgets(this.offsetParamLabels);
        this.removeWidgets(this.offsetParams);
        this.offsetParamLabels.clear();
        this.offsetParams.clear();
        Component[] offsetLabels = new Component[]{Component.m_237115_((String)"generic.offset_x"), Component.m_237115_((String)"generic.offset_y"), Component.m_237115_((String)"generic.offset_z")};
        for (int index = 0; index < 3; ++index) {
            int max = zapperItem.indexMax(currentBrush.getMax(index), currentBrush, this.zapper);
            Label label = new Label(x + 65 + 20 * index, y + 65, CommonComponents.f_237098_).withShadow();
            int finalIndex = index;
            ScrollInput input = new ScrollInput(x + 56 + 20 * index, y + 60, 18, 18).withRange(max * -1, max + 1).writingTo(label).titled(offsetLabels[index].m_6879_()).calling(state -> {
                this.currentOffsetParams[finalIndex] = state;
                label.m_252865_(x + 65 + 20 * finalIndex - this.f_96547_.m_92852_((FormattedText)label.text) / 2);
            });
            input.setState(this.currentOffsetParams[index]);
            input.onChanged();
            this.offsetParamLabels.add(label);
            this.offsetParams.add(input);
        }
        this.addRenderableWidgets(this.offsetParamLabels);
        this.addRenderableWidgets(this.offsetParams);
    }

    protected void drawOnBackground(GuiGraphics graphics, int x, int y) {
        graphics.m_280614_(this.f_96547_, this.title, x + (this.background.width - this.f_96547_.m_92852_((FormattedText)this.title)) / 2, y + 4, 5841956, false);
        Brush currentBrush = this.currentBrush.get();
        for (int index = 2; index >= currentBrush.amtParams; --index) {
            BZGuiTexture.BLOCK_ZAPPER_INACTIVE_PARAM.render(graphics, x + 56 + 20 * index, y + 40);
        }
        graphics.m_280614_(this.f_96547_, this.toolSection, x + 7, y + 89, this.fontColor, false);
        if (currentBrush.hasPlacementOptions()) {
            graphics.m_280614_(this.f_96547_, this.placementSection, x + 136, y + 89, this.fontColor, false);
        }
    }

    protected ConfigureZapperPacket getConfigurationPacket() {
        int brushParamY;
        this.currentBrushParams = ((BlockZapperItem)this.zapper.m_41720_()).fixSize(this.currentBrushParams, this.currentBrush.get(), this.zapper);
        int brushParamX = this.currentBrushParams[0];
        int n = this.followDiagonalsIndicator != null ? (this.followDiagonalsIndicator.state == Indicator.State.ON ? 0 : 1) : (brushParamY = this.currentBrushParams[1]);
        int brushParamZ = this.acrossMaterialsIndicator != null ? (this.acrossMaterialsIndicator.state == Indicator.State.ON ? 0 : 1) : this.currentBrushParams[2];
        int offsetX = this.currentOffsetParams[0];
        int offsetY = this.currentOffsetParams[1];
        int offsetZ = this.currentOffsetParams[2];
        return new ConfigureBlockZapperPacket(this.hand, this.currentPattern, this.currentBrush, brushParamX, brushParamY, brushParamZ, offsetX, offsetY, offsetZ, this.currentTool, this.currentPlacement);
    }

    public void m_7861_() {
        ConfigureZapperPacket packet = this.getConfigurationPacket();
        packet.configureZapper(this.zapper);
        BZPackets.getChannel().sendToServer((Object)packet);
    }
}

