/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_bnz.content.items.zapper;

import com.simibubi.create.AllTags;
import com.simibubi.create.content.equipment.zapper.PlacementPatterns;
import com.simibubi.create.content.equipment.zapper.ZapperItem;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import uwu.lopyluna.create_bnz.BZUtils;
import uwu.lopyluna.create_bnz.content.items.zapper.BlockZapperItem;
import uwu.lopyluna.create_bnz.content.modifiers.Modifiers;
import uwu.lopyluna.create_bnz.registry.BZTags;

public enum TerrainTools {
    Fill(AllIcons.I_FILL),
    Place(AllIcons.I_PLACE),
    Replace(AllIcons.I_REPLACE),
    Clear(AllIcons.I_CLEAR),
    Overlay(AllIcons.I_OVERLAY);

    public final String translationKey = CreateLang.asId((String)this.name());
    public final AllIcons icon;
    static int tick;

    private TerrainTools(AllIcons icon) {
        this.icon = icon;
    }

    public boolean requiresSelectedBlock() {
        return this != Clear;
    }

    public void run(Level world, List<BlockPos> targetPositions, BlockState paintedState, CompoundTag data, Player player, ItemStack stack, BlockZapperItem zapperItem, InteractionHand hand, PlacementPatterns patterns) {
        int size = targetPositions.size();
        boolean valid = false;
        switch (this) {
            case Clear: {
                for (BlockPos p : targetPositions) {
                    TerrainTools.zapperFunction(world, Blocks.f_50016_.m_49966_(), p, world.m_8055_(p), stack, player, hand, data, patterns);
                }
                break;
            }
            case Fill: {
                for (BlockPos p : targetPositions) {
                    BlockState toReplace = world.m_8055_(p);
                    if (!TerrainTools.isReplaceable(toReplace)) continue;
                    TerrainTools.zapperFunction(world, paintedState, p, toReplace, stack, player, hand, data, patterns);
                }
                break;
            }
            case Overlay: {
                for (BlockPos p : targetPositions) {
                    BlockState toReplace;
                    BlockState toOverlay = world.m_8055_(p);
                    if (TerrainTools.isReplaceable(toOverlay) || toOverlay == paintedState || !TerrainTools.isReplaceable(toReplace = world.m_8055_(p = p.m_7494_()))) continue;
                    TerrainTools.zapperFunction(world, paintedState, p, toReplace, stack, player, hand, data, patterns);
                }
                break;
            }
            case Place: {
                for (BlockPos p : targetPositions) {
                    TerrainTools.zapperFunction(world, paintedState, p, world.m_8055_(p), stack, player, hand, data, patterns);
                }
                break;
            }
            case Replace: {
                for (BlockPos p : targetPositions) {
                    BlockState toReplace = world.m_8055_(p);
                    if (TerrainTools.isReplaceable(toReplace)) continue;
                    TerrainTools.zapperFunction(world, paintedState, p, toReplace, stack, player, hand, data, patterns);
                }
                break;
            }
        }
    }

    public int runCalculate(Level world, List<BlockPos> targetPositions, BlockState paintedState, ItemStack stack, BlockZapperItem zapperItem) {
        int size = 0;
        switch (this) {
            case Clear: {
                return 999999;
            }
            case Place: {
                for (BlockPos p : targetPositions) {
                    if (TerrainTools.meetRequirements(world, paintedState, p, world.m_8055_(p), stack, zapperItem) != 0) continue;
                    ++size;
                }
                break;
            }
            case Fill: {
                for (BlockPos p : targetPositions) {
                    BlockState toReplace = world.m_8055_(p);
                    if (!TerrainTools.isReplaceable(toReplace) || TerrainTools.meetRequirements(world, paintedState, p, toReplace, stack, zapperItem) != 0) continue;
                    ++size;
                }
                break;
            }
            case Overlay: {
                for (BlockPos p : targetPositions) {
                    BlockState toReplace;
                    BlockState toOverlay = world.m_8055_(p);
                    if (TerrainTools.isReplaceable(toOverlay) || toOverlay == paintedState || !TerrainTools.isReplaceable(toReplace = world.m_8055_(p = p.m_7494_())) || TerrainTools.meetRequirements(world, paintedState, p, toReplace, stack, zapperItem) != 0) continue;
                    ++size;
                }
                break;
            }
            case Replace: {
                for (BlockPos p : targetPositions) {
                    BlockState toReplace = world.m_8055_(p);
                    if (TerrainTools.isReplaceable(toReplace) || TerrainTools.meetRequirements(world, paintedState, p, toReplace, stack, zapperItem) != 0) continue;
                    ++size;
                }
                break;
            }
        }
        return size;
    }

    public static boolean isReplaceable(BlockState toReplace) {
        return toReplace.m_247087_();
    }

    public static void zapperFunction(Level pLevel, BlockState paintState, BlockPos replacePos, BlockState replaceState, ItemStack stack, Player player, InteractionHand hand, CompoundTag data, PlacementPatterns patterns) {
        boolean hasGenerator;
        block15: {
            Random r = new Random();
            switch (patterns) {
                case Chance25: {
                    if (r.nextBoolean() || r.nextBoolean()) {
                        break;
                    }
                    break block15;
                }
                case Chance50: {
                    if (r.nextBoolean()) {
                        break;
                    }
                    break block15;
                }
                case Chance75: {
                    if (r.nextBoolean() && r.nextBoolean()) {
                        break;
                    }
                    break block15;
                }
                default: {
                    break block15;
                }
            }
            return;
        }
        if (TerrainTools.meetRequirements(pLevel, paintState, replacePos, replaceState, stack, (BlockZapperItem)stack.m_41720_()) != 0) {
            return;
        }
        CompoundTag nbt = stack.m_41784_();
        int retTier = Modifiers.RETRIEVER.getLevel(nbt);
        boolean stasis = Modifiers.STASIS.getLevel(nbt) > 0;
        Block paintBlock = paintState.m_60734_();
        boolean creative = player.m_7500_();
        boolean bl = hasGenerator = Modifiers.GENERATOR.getLevel(nbt) > 0;
        if (!(creative || paintState.m_60795_() || TerrainTools.hasItemInInventory(paintBlock, player, hasGenerator))) {
            return;
        }
        if (!creative && !paintState.m_60795_()) {
            TerrainTools.calculateItemsInInventory(paintBlock, false, player, hasGenerator);
        }
        if (retTier > 0) {
            TerrainTools.dropResources(replaceState, pLevel, replacePos, replaceState.m_155947_() ? pLevel.m_7702_(replacePos) : null, (Entity)player, stack, retTier);
        }
        paintBlock.m_6402_(pLevel, replacePos, paintState, (LivingEntity)player, stack);
        pLevel.m_220407_(GameEvent.f_157797_, replacePos, GameEvent.Context.m_223719_((Entity)player, (BlockState)paintState));
        if (stasis) {
            pLevel.m_7731_(replacePos, paintState, 2);
        } else {
            pLevel.m_46597_(replacePos, paintState);
        }
        ZapperItem.setBlockEntityData((Level)pLevel, (BlockPos)replacePos, (BlockState)paintState, (CompoundTag)data, (Player)player);
        if (!creative) {
            stack.m_41622_(1, (LivingEntity)player, b -> b.m_21190_(hand));
        }
    }

    public static boolean hasItemInInventory(Block paintBlock, Player player, boolean generator) {
        Inventory inv = player.m_150109_();
        int size = inv.m_6643_();
        if (BZTags.AllItemTags.RENEWABLE_GENERATING.matches(paintBlock.m_5456_()) && generator) {
            return true;
        }
        for (int slot = 0; slot < size; ++slot) {
            ItemStack item = inv.m_8020_(slot);
            if (item.m_41619_() || !item.m_150930_(paintBlock.m_5456_())) continue;
            return true;
        }
        return false;
    }

    public static int calculateItemsInInventory(Block paintBlock, boolean calculate, Player player, boolean generator) {
        int amount = 0;
        Inventory inv = player.m_150109_();
        int size = inv.m_6643_();
        if (BZTags.AllItemTags.RENEWABLE_GENERATING.matches(paintBlock.m_5456_()) && generator) {
            amount = size * 128;
        } else {
            for (int slot = 0; slot < size; ++slot) {
                ItemStack item = inv.m_8020_(slot);
                if (item.m_41619_() || !item.m_150930_(paintBlock.m_5456_())) continue;
                if (!calculate) {
                    item.m_41774_(1);
                    return 1;
                }
                amount += item.m_41613_();
            }
        }
        return amount;
    }

    public static boolean blacklist(BlockState toBlacklist) {
        return toBlacklist.m_204336_(BZTags.AllBlockTags.BLOCK_ZAPPER_BLACKLIST.tag) || toBlacklist.m_204336_(AllTags.AllBlockTags.NON_MOVABLE.tag) || AllTags.AllBlockTags.SAFE_NBT.matches(toBlacklist);
    }

    public static int meetRequirements(Level pLevel, BlockState paintState, BlockPos replacePos, BlockState replaceState, ItemStack stack, BlockZapperItem zapperItem) {
        if (paintState == replaceState) {
            return 8;
        }
        float hardness = replaceState.m_60734_().m_155943_();
        if (hardness < 0.0f && !replaceState.m_60795_()) {
            return 6;
        }
        if (hardness > (float)zapperItem.getHardnessSupport(stack) && !replaceState.m_60795_()) {
            return 6;
        }
        if (TerrainTools.blacklist(replaceState)) {
            return 4;
        }
        if (!paintState.m_60710_((LevelReader)pLevel, replacePos)) {
            return 4;
        }
        return pLevel.m_6857_().m_61937_(replacePos) ? 0 : 4;
    }

    public static void dropResources(BlockState pState, Level pLevel, BlockPos pPos, @Nullable BlockEntity pBlockEntity, @Nullable Entity pEntity, ItemStack pTool, int retrieverLevel) {
        if (pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            BlockPos dropPos = retrieverLevel == 4 && pEntity != null ? pEntity.m_20097_().m_7494_() : pPos;
            Block.m_49874_((BlockState)pState, (ServerLevel)serverLevel, (BlockPos)pPos, (BlockEntity)pBlockEntity, (Entity)pEntity, (ItemStack)pTool).forEach(p_49944_ -> TerrainTools.popResource(pLevel, dropPos, p_49944_, retrieverLevel));
            pState.m_222967_(serverLevel, pPos, pTool, false);
            int fortuneLevel = pTool.getEnchantmentLevel(Enchantments.f_44987_);
            int silkTouchLevel = pTool.getEnchantmentLevel(Enchantments.f_44985_);
            int exp = pState.getExpDrop((LevelReader)serverLevel, serverLevel.f_46441_, pPos, fortuneLevel, silkTouchLevel);
            if (exp > 0) {
                pState.m_60734_().m_49805_(serverLevel, dropPos, exp);
            }
        }
    }

    public static void itemTransferTick(Level pLevel, Player player) {
        ++tick;
        if ((tick %= 2) == 1) {
            Vec3 center = BZUtils.getCenterPos((Entity)player);
            AABB bb = new AABB(center, center).m_82400_(64.0);
            for (ItemEntity entity : pLevel.m_45976_(ItemEntity.class, bb)) {
                float limit;
                int range;
                if (entity == null || entity.m_213877_() || !entity.m_19880_().contains("sendToNearestPlayer")) continue;
                boolean fast = entity.m_19880_().contains("sendToNearestPlayerInstant");
                Vec3 diff = BZUtils.getCenterPos((Entity)entity).m_82546_(center);
                double distance = diff.m_82553_();
                int n = range = fast ? 64 : 32;
                if (distance > (double)range) continue;
                Vec3 pushVec = diff.m_82541_().m_82490_(((double)range - distance) * -1.0);
                float forceFactor = 0.0078125f;
                Vec3 force = pushVec.m_82490_((double)forceFactor * (fast ? 1.0 : 0.5));
                entity.m_5997_(force.f_82479_, force.f_82480_, force.f_82481_);
                entity.f_19789_ = 0.0f;
                entity.f_19864_ = true;
                float f = limit = fast ? 4.0f : 2.0f;
                Vec3 currentMovement = entity.m_20184_();
                if (!(currentMovement.m_82553_() > (double)limit)) continue;
                Vec3 limitedMovement = currentMovement.m_82541_().m_82490_((double)limit);
                entity.m_20256_(limitedMovement);
            }
        }
    }

    public static void popResource(Level pLevel, BlockPos pPos, ItemStack pStack, int retrieverLevel) {
        double d0 = (double)EntityType.f_20461_.m_20679_() / 2.0;
        double d1 = (double)pPos.m_123341_() + 0.5 + Mth.m_216263_((RandomSource)pLevel.f_46441_, (double)-0.25, (double)0.25);
        double d2 = (double)pPos.m_123342_() + 0.5 + Mth.m_216263_((RandomSource)pLevel.f_46441_, (double)-0.25, (double)0.25) - d0;
        double d3 = (double)pPos.m_123343_() + 0.5 + Mth.m_216263_((RandomSource)pLevel.f_46441_, (double)-0.25, (double)0.25);
        ItemEntity item = new ItemEntity(pLevel, d1, d2, d3, pStack);
        if (retrieverLevel >= 2) {
            item.m_20049_("sendToNearestPlayer");
        }
        if (retrieverLevel == 3) {
            item.m_20242_(true);
        }
        if (retrieverLevel >= 3) {
            item.m_32061_();
        }
        if (retrieverLevel >= 4) {
            item.m_20049_("sendToNearestPlayerInstant");
        }
        TerrainTools.popResource(pLevel, () -> item, pStack);
    }

    private static void popResource(Level pLevel, Supplier<ItemEntity> pItemEntitySupplier, ItemStack pStack) {
        if (!pLevel.f_46443_ && !pStack.m_41619_() && pLevel.m_46469_().m_46207_(GameRules.f_46136_) && !pLevel.restoringBlockSnapshots) {
            ItemEntity itementity = pItemEntitySupplier.get();
            itementity.m_32060_();
            pLevel.m_7967_((Entity)itementity);
        }
    }

    static {
        tick = 0;
    }
}

