/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_bnz.content.modifiers;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import uwu.lopyluna.create_bnz.content.items.zapper.BlockZapperItem;
import uwu.lopyluna.create_bnz.content.modifiers.ModifierTier;
import uwu.lopyluna.create_bnz.registry.BZLangPartial;

public enum Modifiers {
    EMPTY,
    BODY("Body", "Reinforce to use Stronger Blocks", 4),
    AMPLIFIER("Amplifier", "Increases Placement Size", 4),
    ACCELERATOR("Accelerator", "Reduces Cooldown", 4),
    RETRIEVER("Retriever", "Ability to Obtain Blocks", 4),
    SCOPE("Scope", "Increases Zapping Range", 4),
    REINFORCER("Reinforcer", "Reinforce Durability", 4),
    STASIS("Stasis", "Disallow Block Updates"),
    APPLICATOR("Applicator", "Adds Modifier Slots"),
    GENERATOR("Generator", "Certain renewable Blocks are infinite");

    public final String id;
    public final ResourceLocation loc;
    public final String langDescription;
    public final String langName;
    public final String baseDescription;
    public final String baseName;
    public final int maxLevel;
    public final boolean isUpgrade;

    private Modifiers() {
        this("", "");
    }

    private Modifiers(String baseName, String baseDescription) {
        this(baseName, baseDescription, 1, true);
    }

    private Modifiers(String baseName, String baseDescription, int maxLevel) {
        this(baseName, baseDescription, maxLevel, false);
    }

    private Modifiers(String baseName, String baseDescription, int maxLevel, boolean isUpgrade) {
        this.id = baseName.replaceAll(" ", "_").toLowerCase();
        this.langName = "modifier.create_bnz." + this.id;
        this.langDescription = this.langName + ".desc";
        this.baseName = baseName;
        this.baseDescription = baseDescription;
        this.maxLevel = maxLevel;
        this.isUpgrade = isUpgrade;
        this.loc = new ResourceLocation("create_bnz", this.id);
        BZLangPartial.LANG.put(this.langName, this.baseName);
        BZLangPartial.LANG.put(this.langDescription, this.baseDescription);
        BlockZapperItem.MODIFIERS.add(this);
    }

    public ModifierTier getTierFromModifier(CompoundTag nbt) {
        if (this.isUpgrade) {
            return ModifierTier.SPECIAL;
        }
        return switch (this.getLevel(nbt)) {
            case 1 -> ModifierTier.BRASS;
            case 2 -> ModifierTier.ROSE_QUARTZ;
            case 3 -> ModifierTier.OBSIDIAN;
            case 4 -> ModifierTier.ECHO;
            default -> ModifierTier.NONE;
        };
    }

    public MutableComponent getDescription() {
        return Component.m_264568_((String)this.langDescription, (String)this.baseDescription);
    }

    public MutableComponent getName() {
        return Component.m_264568_((String)this.langName, (String)this.baseName);
    }

    public void update(CompoundTag nbt) {
        if (!nbt.m_128441_(this.baseName)) {
            nbt.m_128405_(this.baseName, 0);
        }
    }

    public int getLevel(CompoundTag nbt) {
        return nbt.m_128441_(this.baseName) ? nbt.m_128451_(this.baseName) : 0;
    }
}

