/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_bnz.content.recipes;

import com.google.gson.JsonObject;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import uwu.lopyluna.create_bnz.content.items.zapper.BlockZapperItem;
import uwu.lopyluna.create_bnz.content.modifiers.ModifierTier;
import uwu.lopyluna.create_bnz.content.modifiers.Modifiers;
import uwu.lopyluna.create_bnz.registry.BZItems;
import uwu.lopyluna.create_bnz.registry.BZRecipeTypes;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ZapperRecipe
extends ShapedRecipe {
    private final ShapedRecipe recipe;
    private final Modifiers component;
    private final ModifierTier tier;

    public ZapperRecipe(ShapedRecipe recipe, Modifiers component, ModifierTier tier) {
        super(recipe.m_6423_(), recipe.m_6076_(), CraftingBookCategory.MISC, recipe.m_44220_(), recipe.m_44221_(), recipe.m_7527_(), recipe.m_8043_(null));
        this.recipe = recipe;
        this.component = component;
        this.tier = tier;
    }

    public boolean m_5818_(CraftingContainer inv, Level world) {
        return this.getRecipe().m_5818_(inv, world);
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.recipe.m_7527_();
    }

    public ItemStack m_5874_(CraftingContainer inv, RegistryAccess pRegistryAccess) {
        for (int slot = 0; slot < inv.m_6643_(); ++slot) {
            Item item;
            ItemStack handgun = inv.m_8020_(slot).m_41777_();
            if (!BZItems.BLOCK_ZAPPER.isIn(handgun) || !((item = handgun.m_41720_()) instanceof BlockZapperItem)) continue;
            BlockZapperItem zapperItem = (BlockZapperItem)item;
            CompoundTag nbt = handgun.m_41784_();
            Modifiers modifier = this.getUpgradedComponent();
            ModifierTier tier = this.getTier();
            if (modifier.getLevel(nbt) != tier.require_level || zapperItem.applyModifier(modifier, handgun) == 0) continue;
            return handgun;
        }
        return ItemStack.f_41583_;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        ItemStack handgun = new ItemStack((ItemLike)BZItems.BLOCK_ZAPPER.get());
        BlockZapperItem zapperItem = (BlockZapperItem)handgun.m_41720_();
        CompoundTag nbt = handgun.m_41784_();
        Modifiers modifier = this.getUpgradedComponent();
        ModifierTier tier = this.getTier();
        if (modifier.getLevel(nbt) == tier.require_level && zapperItem.applyModifier(modifier, handgun) != 0) {
            return handgun;
        }
        return ItemStack.f_41583_;
    }

    public boolean m_5598_() {
        return true;
    }

    public ResourceLocation m_6423_() {
        return this.getRecipe().m_6423_();
    }

    public RecipeType<?> m_6671_() {
        return BZRecipeTypes.ZAPPER_RECIPE.getType();
    }

    public RecipeSerializer<?> m_7707_() {
        return BZRecipeTypes.ZAPPER_RECIPE.getSerializer();
    }

    private static ZapperRecipe fromJsonShaped(ShapedRecipe recipe, JsonObject json) {
        Modifiers component = Modifiers.valueOf(GsonHelper.m_13906_((JsonObject)json, (String)"component"));
        ModifierTier tier = ModifierTier.valueOf(GsonHelper.m_13906_((JsonObject)json, (String)"tier"));
        return new ZapperRecipe(recipe, component, tier);
    }

    private static ZapperRecipe fromNetworkShaped(ShapedRecipe recipe, FriendlyByteBuf buffer) {
        Modifiers component = Modifiers.valueOf(buffer.m_130136_(buffer.readInt()));
        ModifierTier tier = ModifierTier.valueOf(buffer.m_130136_(buffer.readInt()));
        return new ZapperRecipe(recipe, component, tier);
    }

    public boolean m_8004_(int width, int height) {
        return this.getRecipe().m_8004_(width, height);
    }

    public ShapedRecipe getRecipe() {
        return this.recipe;
    }

    public Modifiers getUpgradedComponent() {
        return this.component;
    }

    public ModifierTier getTier() {
        return this.tier;
    }

    @ParametersAreNonnullByDefault
    public static class Serializer
    extends ShapedRecipe.Serializer {
        @Nonnull
        public ShapedRecipe m_6729_(ResourceLocation recipeId, JsonObject json) {
            return ZapperRecipe.fromJsonShaped(super.m_6729_(recipeId, json), json);
        }

        public ShapedRecipe m_8005_(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            return ZapperRecipe.fromNetworkShaped(Objects.requireNonNull(super.m_8005_(recipeId, buffer)), buffer);
        }

        public void m_6178_(FriendlyByteBuf byteBuf, ShapedRecipe recipe) {
            super.m_6178_(byteBuf, recipe);
            if (recipe instanceof ZapperRecipe) {
                ZapperRecipe zapperRecipe = (ZapperRecipe)recipe;
                String name = zapperRecipe.getUpgradedComponent().name();
                String name2 = zapperRecipe.getTier().name();
                byteBuf.writeInt(name.length());
                byteBuf.m_130070_(name);
                byteBuf.writeInt(name2.length());
                byteBuf.m_130070_(name2);
            }
        }
    }
}

