/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_bnz.registry;

import com.simibubi.create.foundation.utility.CreateLang;
import java.util.Collections;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class BZTags {
    public static <T> TagKey<T> optionalTag(IForgeRegistry<T> registry, ResourceLocation id) {
        return Objects.requireNonNull(registry.tags()).createOptionalTagKey(id, Collections.emptySet());
    }

    public static <T> TagKey<T> forgeTag(IForgeRegistry<T> registry, String path) {
        return BZTags.optionalTag(registry, new ResourceLocation("forge", path));
    }

    public static <T> TagKey<T> mcTag(IForgeRegistry<T> registry, String path) {
        return BZTags.optionalTag(registry, new ResourceLocation("minecraft", path));
    }

    public static TagKey<Item> regItemTag(String pNamespace, String pPath) {
        return BZTags.optionalTag(ForgeRegistries.ITEMS, new ResourceLocation(pNamespace, pPath));
    }

    public static TagKey<Block> regBlockTag(String pNamespace, String pPath) {
        return BZTags.optionalTag(ForgeRegistries.BLOCKS, new ResourceLocation(pNamespace, pPath));
    }

    public static TagKey<Block> mcBlockTag(String path) {
        return BZTags.mcTag(ForgeRegistries.BLOCKS, path);
    }

    public static TagKey<Item> mcItemTag(String path) {
        return BZTags.mcTag(ForgeRegistries.ITEMS, path);
    }

    public static TagKey<Block> forgeBlockTag(String path) {
        return BZTags.forgeTag(ForgeRegistries.BLOCKS, path);
    }

    public static TagKey<Item> forgeItemTag(String path) {
        return BZTags.forgeTag(ForgeRegistries.ITEMS, path);
    }

    public static TagKey<Fluid> forgeFluidTag(String path) {
        return BZTags.forgeTag(ForgeRegistries.FLUIDS, path);
    }

    public static void init() {
        AllBlockTags.init();
        AllItemTags.init();
        AllFluidTags.init();
        BZEntityTags.init();
        BZRecipeSerializerTags.init();
    }

    public static enum AllBlockTags {
        BLOCK_ZAPPER_REPLACEABLE,
        BLOCK_ZAPPER_BLACKLIST;

        public final TagKey<Block> tag;
        public final boolean alwaysDatagen;

        private AllBlockTags() {
            this(NameSpace.MOD);
        }

        private AllBlockTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllBlockTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllBlockTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private AllBlockTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? CreateLang.asId((String)this.name()) : path);
            this.tag = optional ? BZTags.optionalTag(ForgeRegistries.BLOCKS, id) : BlockTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(Block block) {
            return block.m_204297_().m_203656_(this.tag);
        }

        public boolean matches(ItemStack stack) {
            BlockItem blockItem;
            Item item;
            return stack != null && (item = stack.m_41720_()) instanceof BlockItem && this.matches((blockItem = (BlockItem)item).m_40614_());
        }

        public boolean matches(BlockState state) {
            return state.m_204336_(this.tag);
        }

        private static void init() {
        }
    }

    public static enum AllItemTags {
        RENEWABLE_GENERATING;

        public final TagKey<Item> tag;
        public final boolean alwaysDatagen;

        private AllItemTags() {
            this(NameSpace.MOD);
        }

        private AllItemTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllItemTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllItemTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private AllItemTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? CreateLang.asId((String)this.name()) : path);
            this.tag = optional ? BZTags.optionalTag(ForgeRegistries.ITEMS, id) : ItemTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(Item item) {
            return item.m_204114_().m_203656_(this.tag);
        }

        public boolean matches(ItemStack stack) {
            return stack.m_204117_(this.tag);
        }

        private static void init() {
        }
    }

    public static final class AllFluidTags
    extends Enum<AllFluidTags> {
        public final TagKey<Fluid> tag;
        public final boolean alwaysDatagen;
        private static final /* synthetic */ AllFluidTags[] $VALUES;

        public static AllFluidTags[] values() {
            return (AllFluidTags[])$VALUES.clone();
        }

        public static AllFluidTags valueOf(String name) {
            return Enum.valueOf(AllFluidTags.class, name);
        }

        private AllFluidTags() {
            this(NameSpace.MOD);
        }

        private AllFluidTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllFluidTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllFluidTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private AllFluidTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? CreateLang.asId((String)this.name()) : path);
            this.tag = optional ? BZTags.optionalTag(ForgeRegistries.FLUIDS, id) : FluidTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(Fluid fluid) {
            return fluid.m_205067_(this.tag);
        }

        public boolean matches(FluidState state) {
            return state.m_205070_(this.tag);
        }

        private static void init() {
        }

        private static /* synthetic */ AllFluidTags[] $values() {
            return new AllFluidTags[0];
        }

        static {
            $VALUES = AllFluidTags.$values();
        }
    }

    public static final class BZEntityTags
    extends Enum<BZEntityTags> {
        public final TagKey<EntityType<?>> tag;
        public final boolean alwaysDatagen;
        private static final /* synthetic */ BZEntityTags[] $VALUES;

        public static BZEntityTags[] values() {
            return (BZEntityTags[])$VALUES.clone();
        }

        public static BZEntityTags valueOf(String name) {
            return Enum.valueOf(BZEntityTags.class, name);
        }

        private BZEntityTags() {
            this(NameSpace.MOD);
        }

        private BZEntityTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private BZEntityTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private BZEntityTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private BZEntityTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? CreateLang.asId((String)this.name()) : path);
            this.tag = optional ? BZTags.optionalTag(ForgeRegistries.ENTITY_TYPES, id) : TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(EntityType<?> type) {
            return type.m_204039_(this.tag);
        }

        public boolean matches(Entity entity) {
            return this.matches(entity.m_6095_());
        }

        private static void init() {
        }

        private static /* synthetic */ BZEntityTags[] $values() {
            return new BZEntityTags[0];
        }

        static {
            $VALUES = BZEntityTags.$values();
        }
    }

    public static final class BZRecipeSerializerTags
    extends Enum<BZRecipeSerializerTags> {
        public final TagKey<RecipeSerializer<?>> tag;
        public final boolean alwaysDatagen;
        private static final /* synthetic */ BZRecipeSerializerTags[] $VALUES;

        public static BZRecipeSerializerTags[] values() {
            return (BZRecipeSerializerTags[])$VALUES.clone();
        }

        public static BZRecipeSerializerTags valueOf(String name) {
            return Enum.valueOf(BZRecipeSerializerTags.class, name);
        }

        private BZRecipeSerializerTags() {
            this(NameSpace.MOD);
        }

        private BZRecipeSerializerTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private BZRecipeSerializerTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private BZRecipeSerializerTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private BZRecipeSerializerTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? CreateLang.asId((String)this.name()) : path);
            this.tag = optional ? BZTags.optionalTag(ForgeRegistries.RECIPE_SERIALIZERS, id) : TagKey.m_203882_((ResourceKey)Registries.f_256764_, (ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(RecipeSerializer<?> recipeSerializer) {
            return ((Holder)ForgeRegistries.RECIPE_SERIALIZERS.getHolder(recipeSerializer).orElseThrow()).m_203656_(this.tag);
        }

        private static void init() {
        }

        private static /* synthetic */ BZRecipeSerializerTags[] $values() {
            return new BZRecipeSerializerTags[0];
        }

        static {
            $VALUES = BZRecipeSerializerTags.$values();
        }
    }

    public static enum NameSpace {
        MOD("create_bnz", false, true),
        CREATE("create"),
        FORGE("forge"),
        TIC("tconstruct"),
        QUARK("quark");

        public final String id;
        public final boolean optionalDefault;
        public final boolean alwaysDatagenDefault;

        private NameSpace(String id) {
            this(id, true, false);
        }

        private NameSpace(String id, boolean optionalDefault, boolean alwaysDatagenDefault) {
            this.id = id;
            this.optionalDefault = optionalDefault;
            this.alwaysDatagenDefault = alwaysDatagenDefault;
        }
    }
}

