/*
 * Decompiled with CFR 0.152.
 */
package de.julianweinelt.ubm;

import de.julianweinelt.ubm.blocks.ModBlocks;
import de.julianweinelt.ubm.blocks.api.sign.TileEntityModSign;
import de.julianweinelt.ubm.blocks.interactable.smithing.GuiHandler;
import de.julianweinelt.ubm.blocks.interactable.smithing.TileEntitySmithingTable;
import de.julianweinelt.ubm.blocks.tiles.TileEntitySculkSensor;
import de.julianweinelt.ubm.configuration.ModConfig;
import de.julianweinelt.ubm.entities.ModEntities;
import de.julianweinelt.ubm.misc.CommonProxy;
import de.julianweinelt.ubm.misc.KeyBindings;
import de.julianweinelt.ubm.misc.ModRecipes;
import de.julianweinelt.ubm.misc.ModSounds;
import de.julianweinelt.ubm.worldgen.PowderSnowWorldGen;
import de.julianweinelt.ubm.worldgen.StructureWorldGen;
import de.julianweinelt.ubm.worldgen.structure.village.ModCustomVillage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.logging.log4j.Logger;

@Mod(modid="ubm", name="Ultimate Backport Mod", version="1.2.0", acceptedMinecraftVersions="[1.12.2]")
public class UBM {
    public static final String MODID = "ubm";
    public static final String NAME = "Ultimate Backport Mod";
    public static final String VERSION = "1.2.0";
    private static Logger logger;
    public static UBM instance;
    @SidedProxy(clientSide="de.julianweinelt.ubm.misc.ClientProxy", serverSide="de.julianweinelt.ubm.misc.CommonProxy")
    public static CommonProxy proxy;
    public static String[] colorPalettes;
    public static File configDir;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        instance = this;
        proxy.preInit(event);
        configDir = event.getModConfigurationDirectory();
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
        KeyBindings.init();
        File configFile = new File(configDir, "ubm.cfg");
        if (!configFile.exists()) {
            try (InputStream in = this.getClass().getResourceAsStream("/assets/ubm/ubm.cfg");){
                if (in != null) {
                    Files.copy(in, configFile.toPath(), new CopyOption[0]);
                } else {
                    logger.fatal("Failed to load ubm.cfg! The file seems not to be in the mod itself. That is a problem.");
                }
            }
            catch (IOException e) {
                logger.error("Failed to load config file!", (Throwable)e);
            }
        }
        ModConfig.init(configFile);
        ModEntities.init();
        ModEntities.addSpawns();
        GameRegistry.registerWorldGenerator((IWorldGenerator)new PowderSnowWorldGen(), (int)0);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new StructureWorldGen(), (int)0);
        GameRegistry.registerTileEntity(TileEntitySmithingTable.class, (ResourceLocation)new ResourceLocation(MODID, "smithing_table"));
        GameRegistry.registerTileEntity(TileEntityModSign.class, (ResourceLocation)new ResourceLocation(MODID, "sign_te"));
        GameRegistry.registerTileEntity(TileEntitySculkSensor.class, (ResourceLocation)new ResourceLocation(MODID, "sculk_sensor_te"));
        ModCustomVillage.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        proxy.init(event);
        ModBlocks.WAXED_VARIANTS.put(ModBlocks.COPPER_BLOCK.getRegistryName(), ModBlocks.WAXED_COPPER_BLOCK.getRegistryName());
        ModBlocks.WAXED_VARIANTS.put(ModBlocks.EXPOSED_COPPER_BLOCK.getRegistryName(), ModBlocks.WAXED_EXPOSED_COPPER_BLOCK.getRegistryName());
        ModBlocks.WAXED_VARIANTS.put(ModBlocks.WEATHERED_COPPER_BLOCK.getRegistryName(), ModBlocks.WAXED_WEATHERED_COPPER_BLOCK.getRegistryName());
        ModBlocks.WAXED_VARIANTS.put(ModBlocks.OXIDIZED_COPPER_BLOCK.getRegistryName(), ModBlocks.WAXED_OXIDIZED_COPPER_BLOCK.getRegistryName());
        ModBlocks.UNWAXED_VARIANTS.put(ModBlocks.WAXED_COPPER_BLOCK.getRegistryName(), ModBlocks.COPPER_BLOCK.getRegistryName());
        ModBlocks.UNWAXED_VARIANTS.put(ModBlocks.WAXED_EXPOSED_COPPER_BLOCK.getRegistryName(), ModBlocks.EXPOSED_COPPER_BLOCK.getRegistryName());
        ModBlocks.UNWAXED_VARIANTS.put(ModBlocks.WAXED_WEATHERED_COPPER_BLOCK.getRegistryName(), ModBlocks.WEATHERED_COPPER_BLOCK.getRegistryName());
        ModBlocks.UNWAXED_VARIANTS.put(ModBlocks.WAXED_OXIDIZED_COPPER_BLOCK.getRegistryName(), ModBlocks.OXIDIZED_COPPER_BLOCK.getRegistryName());
        ModBlocks.PREVIOUS_OXIDATION.put(ModBlocks.EXPOSED_COPPER_BLOCK.getRegistryName(), ModBlocks.COPPER_BLOCK.getRegistryName());
        ModBlocks.PREVIOUS_OXIDATION.put(ModBlocks.WEATHERED_COPPER_BLOCK.getRegistryName(), ModBlocks.EXPOSED_COPPER_BLOCK.getRegistryName());
        ModBlocks.PREVIOUS_OXIDATION.put(ModBlocks.OXIDIZED_COPPER_BLOCK.getRegistryName(), ModBlocks.WEATHERED_COPPER_BLOCK.getRegistryName());
        ModRecipes.init();
        ModSounds.SoundTypes.init();
        ModBlocks.AMETHYST_BLOCK.soundType(ModSounds.SoundTypes.AMETHYST_BLOCK);
    }

    public static Logger getLogger() {
        return logger;
    }

    static {
        colorPalettes = new String[]{"amethyst", "copper", "diamond", "emerald", "gold", "iron", "lapis", "netherite", "quartz", "redstone", "resin"};
    }
}

