/*
 * Decompiled with CFR 0.152.
 */
package de.julianweinelt.ubm.blocks;

import de.julianweinelt.ubm.entities.EntityBee;
import de.julianweinelt.ubm.items.ModItems;
import de.julianweinelt.ubm.misc.ModCreativeTabs;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockBeeNest
extends Block {
    public static final PropertyInteger BEES = PropertyInteger.func_177719_a((String)"bees", (int)0, (int)3);
    public static final PropertyInteger HONEY_LEVEL = PropertyInteger.func_177719_a((String)"honey_level", (int)0, (int)5);

    public BlockBeeNest() {
        super(Material.field_151575_d);
        this.func_149663_c("bee_nest");
        this.setRegistryName("bee_nest");
        this.func_149647_a(ModCreativeTabs.UBM_TAB_BEES);
        this.func_149752_b(0.3f);
        this.func_149711_c(0.3f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BEES, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)HONEY_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BEES, HONEY_LEVEL});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BEES, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)HONEY_LEVEL, (Comparable)Integer.valueOf(0));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)BEES);
    }

    @Nonnull
    public List<ItemStack> getDrops(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        int bees = (Integer)state.func_177229_b((IProperty)BEES);
        int honey = (Integer)state.func_177229_b((IProperty)HONEY_LEVEL);
        ItemStack stack = new ItemStack((Block)this);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("Bees", bees);
        tag.func_74768_a("HoneyLevel", honey);
        stack.func_77982_d(tag);
        drops.add(stack);
        return drops;
    }

    public void func_180633_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityLivingBase placer, @Nonnull ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p();
            if (tag == null) {
                return;
            }
            int bees = tag.func_74762_e("Bees");
            int honey = tag.func_74762_e("HoneyLevel");
            world.func_180501_a(pos, state.func_177226_a((IProperty)BEES, (Comparable)Integer.valueOf(bees)).func_177226_a((IProperty)HONEY_LEVEL, (Comparable)Integer.valueOf(honey)), 2);
        }
    }

    public void func_180657_a(@Nonnull World world, @Nonnull EntityPlayer player, @Nonnull BlockPos pos, IBlockState state, @Nullable TileEntity te, @Nonnull ItemStack stack) {
        boolean hasSilk;
        int bees = (Integer)state.func_177229_b((IProperty)BEES);
        boolean bl = hasSilk = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0;
        if (!hasSilk && !world.field_72995_K) {
            for (int i = 0; i < bees; ++i) {
                EntityBee bee = new EntityBee(world);
                bee.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
                world.func_72838_d((Entity)bee);
            }
        }
        super.func_180657_a(world, player, pos, state, te, stack);
    }

    public boolean func_149653_t() {
        return true;
    }

    public void func_180645_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random rand) {
        super.func_180645_a(world, pos, state, rand);
        int bees = (Integer)state.func_177229_b((IProperty)BEES);
        int honey = (Integer)state.func_177229_b((IProperty)HONEY_LEVEL);
        if (bees > 0 && honey < 5) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)HONEY_LEVEL, (Comparable)Integer.valueOf(honey + 1)), 2);
        }
        if (bees > 0) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)BEES, (Comparable)Integer.valueOf(bees - 1)), 2);
            EntityBee bee = new EntityBee(world);
            bee.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() - 0.5);
            world.func_72838_d((Entity)bee);
            bee.setNestPos(pos);
        }
    }

    public boolean func_180639_a(@Nonnull World world, @Nonnull BlockPos pos, IBlockState state, EntityPlayer player, @Nonnull EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack held = player.func_184586_b(hand);
        if ((Integer)state.func_177229_b((IProperty)HONEY_LEVEL) >= 5) {
            if (held.func_77973_b() == Items.field_151069_bo) {
                if (!world.field_72995_K) {
                    player.func_191521_c(new ItemStack(ModItems.HONEY_BOTTLE));
                    world.func_180501_a(pos, state.func_177226_a((IProperty)HONEY_LEVEL, (Comparable)Integer.valueOf(0)), 2);
                    if (this.noCampfireNearby(world, pos)) {
                        int bees = (Integer)state.func_177229_b((IProperty)BEES);
                        for (int i = 0; i < bees; ++i) {
                            EntityBee bee = new EntityBee(world);
                            bee.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
                            world.func_72838_d((Entity)bee);
                            bee.setAggressive(player);
                            bee.setNestPos(pos);
                        }
                    }
                }
                return true;
            }
            if (held.func_77973_b() == Items.field_151097_aZ) {
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new ItemStack(ModItems.HONEYCOMB, 1)));
                    world.func_180501_a(pos, state.func_177226_a((IProperty)HONEY_LEVEL, (Comparable)Integer.valueOf(0)), 2);
                    if (this.noCampfireNearby(world, pos)) {
                        int bees = (Integer)state.func_177229_b((IProperty)BEES);
                        for (int i = 0; i < bees; ++i) {
                            EntityBee bee = new EntityBee(world);
                            bee.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
                            world.func_72838_d((Entity)bee);
                            bee.setAggressive(player);
                            bee.setNestPos(pos);
                        }
                    }
                }
                return true;
            }
        }
        return false;
    }

    private boolean noCampfireNearby(World worldIn, BlockPos pos) {
        int posY;
        for (int y = posY = pos.func_177956_o(); y > posY - 5; --y) {
            if (worldIn.func_180495_p(new BlockPos(pos.func_177958_n(), y, pos.func_177952_p())).func_177230_c() != Blocks.field_150480_ab) continue;
            return false;
        }
        return true;
    }
}

