/*
 * Decompiled with CFR 0.152.
 */
package de.julianweinelt.ubm.blocks;

import de.julianweinelt.ubm.blocks.api.EnumHorizontalFacing;
import de.julianweinelt.ubm.blocks.tiles.TileEntityCampfire;
import de.julianweinelt.ubm.misc.ModCreativeTabs;
import de.julianweinelt.ubm.particles.ParticleCampfireSmoke;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCampFire
extends Block {
    public static final AxisAlignedBB CAMPFIRE_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    public static final PropertyEnum<EnumHorizontalFacing> FACING = PropertyEnum.func_177709_a((String)"facing", EnumHorizontalFacing.class);
    public static final PropertyBool LIT = PropertyBool.func_177716_a((String)"lit");

    public BlockCampFire(boolean soul) {
        super(Material.field_151575_d);
        this.setRegistryName("ubm", (soul ? "soul_" : "") + "campfire");
        this.func_149663_c((soul ? "soul_" : "") + "campfire");
        this.func_149715_a(1.0f);
        this.func_149647_a(ModCreativeTabs.UBM_TAB_PILLAGE);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(FACING, (Comparable)((Object)EnumHorizontalFacing.NORTH)).func_177226_a((IProperty)LIT, (Comparable)Boolean.TRUE));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, LIT});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        boolean lit = (meta & 4) != 0;
        EnumHorizontalFacing facing = EnumHorizontalFacing.values()[meta & 3];
        return this.func_176223_P().func_177226_a(FACING, (Comparable)((Object)facing)).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(lit));
    }

    public int func_176201_c(IBlockState state) {
        int i = ((EnumHorizontalFacing)((Object)state.func_177229_b(FACING))).ordinal();
        if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            i |= 4;
        }
        return i;
    }

    @Nonnull
    public IBlockState func_180642_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a(FACING, (Comparable)((Object)EnumHorizontalFacing.fromFacing(placer.func_174811_aO().func_176734_d()))).func_177226_a((IProperty)LIT, (Comparable)Boolean.TRUE);
    }

    @Nonnull
    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        EnumFacing facing = rot.func_185831_a(((EnumHorizontalFacing)((Object)state.func_177229_b(FACING))).toEnumFacing());
        return state.func_177226_a(FACING, (Comparable)((Object)EnumHorizontalFacing.fromEnumFacing(facing)));
    }

    @Nonnull
    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        EnumFacing facing = mirrorIn.func_185800_a(((EnumHorizontalFacing)((Object)state.func_177229_b(FACING))).toEnumFacing()).func_185831_a(EnumFacing.NORTH);
        return state.func_177226_a(FACING, (Comparable)((Object)EnumHorizontalFacing.fromEnumFacing(facing)));
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        return false;
    }

    public boolean func_149686_d(@Nonnull IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean func_176225_a(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        return true;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(@Nonnull IBlockState state, @Nonnull IBlockAccess source, @Nonnull BlockPos pos) {
        return CAMPFIRE_AABB;
    }

    public AxisAlignedBB func_180646_a(@Nonnull IBlockState blockState, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return CAMPFIRE_AABB;
    }

    public boolean func_180639_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer playerIn, @Nonnull EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = playerIn.func_184586_b(hand);
        if (heldItem != null) {
            TileEntity te;
            if (heldItem.func_77973_b() instanceof ItemSpade && ((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
                if (!worldIn.field_72995_K) {
                    worldIn.func_175656_a(pos, state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
                }
                return true;
            }
            if (heldItem.func_77973_b() == Items.field_151033_d && !((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
                if (!worldIn.field_72995_K) {
                    worldIn.func_175656_a(pos, state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)));
                }
                return true;
            }
            Item[] beef = new Item[]{Items.field_151082_bd, Items.field_151076_bf, Items.field_179561_bm, Items.field_179558_bo, Items.field_151174_bG};
            Item[] cooked = new Item[]{Items.field_151083_be, Items.field_151077_bg, Items.field_179557_bn, Items.field_179559_bp, Items.field_151168_bH};
            List<Item> beefList = Arrays.asList(beef);
            int beefSlot = beefList.indexOf(heldItem.func_77973_b());
            if (!heldItem.func_190926_b() && beefList.contains(heldItem.func_77973_b()) && (te = worldIn.func_175625_s(pos)) instanceof TileEntityCampfire) {
                boolean added = ((TileEntityCampfire)te).addItem(heldItem.func_77979_a(1), new ItemStack(cooked[beefSlot]));
                if (added && !worldIn.field_72995_K) {
                    worldIn.func_184138_a(pos, state, state, 3);
                }
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Random rand) {
        if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            double x = (double)pos.func_177958_n() + 0.5;
            double y = (double)pos.func_177956_o() + 0.6;
            double z = (double)pos.func_177952_p() + 0.5;
            double offsetX = (rand.nextDouble() - 0.5) * 0.3;
            double offsetZ = (rand.nextDouble() - 0.5) * 0.3;
            double velocityY = 0.05 + rand.nextDouble() * 0.05;
            Minecraft.func_71410_x().func_152344_a(() -> Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleCampfireSmoke(worldIn, x + offsetX, y + 0.5, z + offsetZ, 0.0, velocityY, 0.0)));
        }
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityCampfire();
    }
}

