/*
 * Decompiled with CFR 0.152.
 */
package de.julianweinelt.ubm.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCandle
extends Block {
    public static final PropertyInteger CANDLES = PropertyInteger.func_177719_a((String)"candles", (int)1, (int)4);
    public static final PropertyBool LIT = PropertyBool.func_177716_a((String)"lit");
    private static final AxisAlignedBB[] BOUNDING_BOXES = new AxisAlignedBB[]{new AxisAlignedBB(0.4, 0.0, 0.4, 0.6, 0.5, 0.6), new AxisAlignedBB(0.3, 0.0, 0.3, 0.7, 0.5, 0.7), new AxisAlignedBB(0.2, 0.0, 0.2, 0.8, 0.5, 0.8), new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 0.5, 0.9)};
    private static final Vec3d[][] PARTICLE_OFFSETS = new Vec3d[][]{{new Vec3d(0.0, 0.0, 0.0)}, {new Vec3d(-0.1, 0.0, 0.0), new Vec3d(0.1, 0.0, 0.0)}, {new Vec3d(-0.1, 0.0, -0.1), new Vec3d(0.1, 0.0, -0.1), new Vec3d(0.0, 0.0, 0.1)}, {new Vec3d(-0.1, 0.0, -0.1), new Vec3d(0.1, 0.0, -0.1), new Vec3d(-0.1, 0.0, 0.1), new Vec3d(0.1, 0.0, 0.1)}};

    public BlockCandle() {
        super(Material.field_151594_q);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)CANDLES, (Comparable)Integer.valueOf(1)).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
        this.func_149713_g(0);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{CANDLES, LIT});
    }

    public IBlockState func_176203_a(int meta) {
        int candles = (meta & 3) + 1;
        boolean lit = (meta & 4) != 0;
        return this.func_176223_P().func_177226_a((IProperty)CANDLES, (Comparable)Integer.valueOf(candles)).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(lit));
    }

    public int func_176201_c(IBlockState state) {
        int meta = (Integer)state.func_177229_b((IProperty)CANDLES) - 1;
        if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            meta |= 4;
        }
        return meta;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            int candles;
            if (heldItem.func_77973_b() == Items.field_151033_d) {
                boolean lit = true;
                world.func_180501_a(pos, state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(lit)), 3);
                this.func_149715_a(1.0f);
                if (!player.func_184812_l_()) {
                    heldItem.func_77972_a(1, (EntityLivingBase)player);
                }
                return true;
            }
            if (heldItem.func_190926_b()) {
                boolean lit = false;
                world.func_180501_a(pos, state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(lit)), 3);
                this.func_149715_a(0.0f);
            } else if (heldItem.func_77973_b() == Items.field_151036_c && (candles = ((Integer)state.func_177229_b((IProperty)CANDLES)).intValue()) < 4) {
                if (!world.field_72995_K) {
                    world.func_180501_a(pos, state.func_177226_a((IProperty)CANDLES, (Comparable)Integer.valueOf(candles + 1)), 3);
                    if (!player.func_184812_l_()) {
                        heldItem.func_77972_a(1, (EntityLivingBase)player);
                    }
                }
                return true;
            }
        }
        return true;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_185481_k(IBlockState state) {
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOXES[(Integer)state.func_177229_b((IProperty)CANDLES) - 1];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (!((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            return;
        }
        int candles = (Integer)state.func_177229_b((IProperty)CANDLES);
        for (Vec3d offset : PARTICLE_OFFSETS[candles - 1]) {
            double x = (double)pos.func_177958_n() + 0.5 + offset.field_72450_a;
            double y = (double)pos.func_177956_o() + 0.5 + offset.field_72448_b;
            double z = (double)pos.func_177952_p() + 0.5 + offset.field_72449_c;
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x, y, z, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.FLAME, x, y, z, 0.0, 0.0, 0.0, new int[0]);
        }
    }
}

