/*
 * Decompiled with CFR 0.152.
 */
package de.julianweinelt.ubm.blocks;

import de.julianweinelt.ubm.blocks.tiles.TileEntityDecoratedPot;
import de.julianweinelt.ubm.items.ItemPotterySherd;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.animation.FastTESR;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderDecoratedPottery
extends FastTESR<TileEntityDecoratedPot> {
    private static final ModelResourceLocation BASE_MODEL = new ModelResourceLocation("ubm:block/decorated_pot");
    private static final ResourceLocation[] PATTERN_TEXTURES = new ResourceLocation[24];

    public void renderTileEntityFast(@Nonnull TileEntityDecoratedPot te, double x, double y, double z, float partialTicks, int destroyStage, float alpha, @Nonnull BufferBuilder buffer) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        Minecraft mc = Minecraft.func_71410_x();
        BlockRendererDispatcher brd = mc.func_175602_ab();
        IBakedModel baseModel = brd.func_175023_a().func_178126_b().func_174953_a(BASE_MODEL);
        brd.func_175019_b().func_178262_a(baseModel, 1.0f, 1.0f, 1.0f, 1.0f);
        for (EnumFacing side : EnumFacing.field_176754_o) {
            int id = te.getSherdForSide(side);
            if (id < 0 || id >= PATTERN_TEXTURES.length) continue;
            mc.func_110434_K().func_110577_a(PATTERN_TEXTURES[id]);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)0.5, (double)0.5, (double)0.5);
            GlStateManager.func_179114_b((float)this.getRotationFor(side), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)-0.5);
            brd.func_175019_b().func_178262_a(baseModel, 1.0f, 1.0f, 1.0f, 1.0f);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
    }

    private float getRotationFor(EnumFacing side) {
        switch (side) {
            case SOUTH: {
                return 180.0f;
            }
            case WEST: {
                return 90.0f;
            }
            case EAST: {
                return -90.0f;
            }
        }
        return 0.0f;
    }

    static {
        for (int i = 0; i < 24; ++i) {
            RenderDecoratedPottery.PATTERN_TEXTURES[i] = new ResourceLocation("ubm", "textures/blocks/decorated_pot/" + ItemPotterySherd.SherdType.byId(i).getName() + "_pottery_pattern.png");
        }
    }
}

