/*
 * Decompiled with CFR 0.152.
 */
package de.julianweinelt.ubm.blocks.api;

import de.julianweinelt.ubm.UBM;
import de.julianweinelt.ubm.blocks.BlockLightningRod;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="ubm")
public class LightningRodHandler {
    private static final int RANGE = 128;

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (!(event.getEntity() instanceof EntityLightningBolt)) {
            return;
        }
        EntityLightningBolt bolt = (EntityLightningBolt)event.getEntity();
        BlockPos pos = bolt.func_180425_c();
        BlockPos rodPos = LightningRodHandler.findNearestRod(bolt.field_70170_p, pos);
        if (rodPos != null) {
            UBM.getLogger().info("Lightning Rod found at " + rodPos);
            event.setCanceled(true);
            EntityLightningBolt rodBolt = new EntityLightningBolt(bolt.field_70170_p, (double)rodPos.func_177958_n() + 0.5, (double)rodPos.func_177956_o(), (double)rodPos.func_177952_p() + 0.5, false);
            bolt.field_70170_p.func_72942_c((Entity)rodBolt);
        }
    }

    private static BlockPos findNearestRod(World world, BlockPos center) {
        BlockPos closest = null;
        double closestDist = Double.MAX_VALUE;
        for (int x = -128; x <= 128; ++x) {
            for (int y = -128; y <= 128; ++y) {
                for (int z = -128; z <= 128; ++z) {
                    double dist;
                    BlockPos pos = center.func_177982_a(x, y, z);
                    IBlockState state = world.func_180495_p(pos);
                    if (!(state.func_177230_c() instanceof BlockLightningRod) || !((dist = center.func_177951_i((Vec3i)pos)) < closestDist)) continue;
                    closestDist = dist;
                    closest = pos;
                }
            }
        }
        return closest;
    }
}

