/*
 * Decompiled with CFR 0.152.
 */
package de.julianweinelt.ubm.blocks.interactable;

import de.julianweinelt.ubm.blocks.BlockSculkSensor;
import de.julianweinelt.ubm.blocks.tiles.TileEntitySculkSensor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class SculkSensorEventHandler {
    @SubscribeEvent
    public static void onBlockPlace(BlockEvent.PlaceEvent event) {
        SculkSensorEventHandler.triggerNearbySensors(event.getWorld(), event.getPos());
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        SculkSensorEventHandler.triggerNearbySensors(event.getWorld(), event.getPos());
    }

    @SubscribeEvent
    public static void onEntityMove(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity.func_70093_af()) {
            return;
        }
        double speed = Math.abs(entity.field_70159_w) + Math.abs(entity.field_70181_x) + Math.abs(entity.field_70179_y);
        if (speed > 0.1) {
            SculkSensorEventHandler.triggerNearbySensors(entity.field_70170_p, entity.func_180425_c());
        }
    }

    private static boolean inRange(double value, double min, double max) {
        return value >= min && value <= max;
    }

    private static boolean inRange(double value, double bound) {
        return SculkSensorEventHandler.inRange(value, value - bound, value + bound);
    }

    private static void triggerNearbySensors(World world, BlockPos sourcePos) {
        if (world.field_72995_K) {
            return;
        }
        int radius = 6;
        Iterable area = BlockPos.func_177980_a((BlockPos)sourcePos.func_177982_a(-radius, -radius, -radius), (BlockPos)sourcePos.func_177982_a(radius, radius, radius));
        for (BlockPos pos : area) {
            TileEntity te;
            IBlockState state = world.func_180495_p(pos);
            if (!(state.func_177230_c() instanceof BlockSculkSensor) || !((te = world.func_175625_s(pos)) instanceof TileEntitySculkSensor)) continue;
            ((TileEntitySculkSensor)te).triggerOnce();
        }
    }
}

