/*
 * Decompiled with CFR 0.152.
 */
package de.julianweinelt.ubm.blocks.plant;

import de.julianweinelt.ubm.misc.ModCreativeTabs;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockGlowLichen
extends Block {
    private static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.875, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.125);
    private static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 1.0, 1.0);
    private static final AxisAlignedBB UP_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
    private static final AxisAlignedBB DOWN_AABB = new AxisAlignedBB(0.0, 0.875, 0.0, 1.0, 1.0, 1.0);
    public static final PropertyEnum<AttachSide> SIDE = PropertyEnum.func_177709_a((String)"side", AttachSide.class);

    public BlockGlowLichen() {
        super(Material.field_151585_k);
        this.func_149663_c("glow_lichen");
        this.setRegistryName("glow_lichen");
        this.func_149647_a(ModCreativeTabs.UBM_TAB_CAVES);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149715_a(0.4f);
        this.func_149711_c(0.2f);
        this.func_149752_b(0.2f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(SIDE, (Comparable)((Object)AttachSide.NORTH)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, @Nonnull IBlockAccess source, @Nonnull BlockPos pos) {
        switch ((AttachSide)((Object)state.func_177229_b(SIDE))) {
            case NORTH: {
                return SOUTH_AABB;
            }
            case SOUTH: {
                return NORTH_AABB;
            }
            case EAST: {
                return WEST_AABB;
            }
            case WEST: {
                return EAST_AABB;
            }
            case UP: {
                return DOWN_AABB;
            }
            case DOWN: {
                return UP_AABB;
            }
        }
        return field_185505_j;
    }

    public AxisAlignedBB func_180646_a(@Nonnull IBlockState blockState, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return field_185506_k;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SIDE});
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(SIDE, (Comparable)((Object)AttachSide.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((AttachSide)((Object)state.func_177229_b(SIDE))).getMetadata();
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a(SIDE, (Comparable)((Object)AttachSide.fromFacing(facing)));
    }

    public static enum AttachSide implements IStringSerializable
    {
        NORTH(0, "north"),
        SOUTH(1, "south"),
        EAST(2, "east"),
        WEST(3, "west"),
        UP(4, "up"),
        DOWN(5, "down");

        private final int meta;
        private final String name;

        private AttachSide(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String func_176610_l() {
            return this.name;
        }

        public static AttachSide byMetadata(int meta) {
            for (AttachSide side : AttachSide.values()) {
                if (side.meta != meta) continue;
                return side;
            }
            return NORTH;
        }

        public static AttachSide fromFacing(EnumFacing facing) {
            switch (facing) {
                case NORTH: {
                    return SOUTH;
                }
                case SOUTH: {
                    return NORTH;
                }
                case EAST: {
                    return WEST;
                }
                case WEST: {
                    return EAST;
                }
                case UP: {
                    return DOWN;
                }
                case DOWN: {
                    return UP;
                }
            }
            return NORTH;
        }
    }
}

