/*
 * Decompiled with CFR 0.152.
 */
package de.julianweinelt.ubm.blocks.plant;

import de.julianweinelt.ubm.blocks.ModBlocks;
import de.julianweinelt.ubm.items.ModItems;
import de.julianweinelt.ubm.misc.ModCreativeTabs;
import de.julianweinelt.ubm.misc.ModSounds;
import java.util.Arrays;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockSweetBerry
extends BlockBush
implements IGrowable {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)3);

    public BlockSweetBerry() {
        super(Material.field_151585_k);
        this.func_149663_c("sweet_berry_bush");
        this.setRegistryName("sweet_berry_bush");
        this.func_149711_c(0.0f);
        this.func_149752_b(0.0f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149647_a(ModCreativeTabs.UBM_TAB_PILLAGE);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return true;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 60;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        Block[] possibleBlocks = new Block[]{Blocks.field_150346_d, Blocks.field_150349_c, Blocks.field_150458_ak, Blocks.field_150391_bh, ModBlocks.MOSS_BLOCK};
        BlockPos down = pos.func_177977_b();
        Block block = worldIn.func_180495_p(down).func_177230_c();
        return Arrays.asList(possibleBlocks).contains(block);
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        entityIn.field_70159_w *= 0.4;
        entityIn.field_70179_y *= 0.4;
        if (!worldIn.field_72995_K && entityIn instanceof EntityPlayer && entityIn.field_70173_aa % 10 == 0) {
            entityIn.func_70097_a(DamageSource.field_76367_g, 1.0f);
        }
    }

    public boolean func_149698_L() {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(worldIn, pos, state, rand);
        int age = (Integer)state.func_177229_b((IProperty)AGE);
        if (age < 3 && rand.nextInt(40) == 0) {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(age + 1)), 2);
        }
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return (Integer)state.func_177229_b((IProperty)AGE) < 3;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        int age = (Integer)state.func_177229_b((IProperty)AGE);
        if (age < 3) {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(age + 1)), 2);
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ModItems.SWEET_BERRY;
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        int age = (Integer)state.func_177229_b((IProperty)AGE);
        if (age == 2) {
            return random.nextInt(1) + 1;
        }
        if (age == 3) {
            return 2 + random.nextInt(1);
        }
        return 0;
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        return ModSounds.SoundTypes.SWEET_BERRY_BUSH;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            int age = (Integer)state.func_177229_b((IProperty)AGE);
            if (age <= 2) {
                return false;
            }
            ItemStack berries = new ItemStack(ModItems.SWEET_BERRY, new Random().nextInt(2) + 1);
            BlockSweetBerry.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)berries);
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(1)), 2);
        }
        return true;
    }
}

