/*
 * Decompiled with CFR 0.152.
 */
package de.julianweinelt.ubm.configuration;

import de.julianweinelt.ubm.UBM;
import de.julianweinelt.ubm.configuration.section.ConfigSectionEntity;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraftforge.common.config.Configuration;

public class ModConfig {
    public static Configuration config;
    private static final Map<String, ConfigSectionEntity> entities;

    public static void init(File file) {
        config = new Configuration(file);
        ModConfig.sync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sync() {
        try {
            config.load();
            int entLoaded = 0;
            for (String category : config.getCategoryNames()) {
                if (!category.startsWith("entities.")) continue;
                String entityName = category.substring("entities.".length());
                ConfigSectionEntity section = new ConfigSectionEntity(config, entityName);
                entities.put(entityName, section);
                ++entLoaded;
            }
            UBM.getLogger().info("Loaded configuration data for {} entities", (Object)entLoaded);
        }
        catch (Exception e) {
            UBM.getLogger().error("Failed to load configuration file!", (Throwable)e);
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    @Nonnull
    public static ConfigSectionEntity getEntityConfig(String entityName) {
        return entities.getOrDefault(entityName, new ConfigSectionEntity(entityName));
    }

    static {
        entities = new HashMap<String, ConfigSectionEntity>();
    }
}

