/*
 * Decompiled with CFR 0.152.
 */
package de.julianweinelt.ubm.configuration.section;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ConfigSectionEntity {
    private final Configuration config;
    private final String entity;
    private final Map<String, Object> values = new HashMap<String, Object>();
    private boolean enabled;
    private int spawnWeight;
    private int health;
    private int damage = 0;
    private final List<String> feedItems = new ArrayList<String>();

    public ConfigSectionEntity(Configuration config, String entity) {
        this.config = config;
        this.entity = entity;
        this.load();
    }

    public ConfigSectionEntity(String entity) {
        this.config = null;
        this.entity = entity;
        this.enabled = false;
        this.spawnWeight = 0;
        this.health = 1;
    }

    private void load() {
        this.enabled = this.config.getBoolean("enabled", "entities." + this.entity, true, "");
        this.spawnWeight = this.config.getInt("spawnWeight", "entities." + this.entity, 0, 0, 100, "");
        this.health = this.config.getInt("health", "entities." + this.entity, 0, 1, Integer.MAX_VALUE, "");
        this.damage = this.config.getInt("damage", "entities." + this.entity, 0, 0, Integer.MAX_VALUE, "");
        this.feedItems.clear();
        this.feedItems.addAll(Arrays.asList(this.config.getStringList("feedItems", "entities." + this.entity, new String[0], "")));
        ConfigCategory cat = this.config.getCategory("entities." + this.entity);
        for (String s : cat.getValues().keySet()) {
            Property p = cat.get(s);
            if (p == null) continue;
            if (p.getType().equals((Object)Property.Type.BOOLEAN)) {
                this.values.put(s, p.getBoolean());
            }
            if (p.getType().equals((Object)Property.Type.STRING)) {
                this.values.put(s, p.getString());
            }
            if (p.getType().equals((Object)Property.Type.DOUBLE)) {
                this.values.put(s, p.getDouble());
            }
            if (!p.getType().equals((Object)Property.Type.INTEGER)) continue;
            this.values.put(s, p.getInt());
        }
    }

    public int getAsInt(String key) {
        Object value = this.values.get(key);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return 0;
    }

    public boolean getAsBoolean(String key) {
        Object value = this.values.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }

    public String getAsString(String key) {
        Object value = this.values.get(key);
        if (value instanceof String) {
            return (String)value;
        }
        return "";
    }

    public List<String> getAsStringList(String key) {
        Object value = this.values.get(key);
        if (value instanceof List) {
            List list = (List)value;
            ArrayList<String> strings = new ArrayList<String>();
            for (Object o : list) {
                if (!(o instanceof String)) continue;
                strings.add((String)o);
            }
            return strings;
        }
        return Collections.emptyList();
    }

    public Map<String, Object> getValues() {
        return this.values;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getSpawnWeight() {
        return this.spawnWeight;
    }

    public int getHealth() {
        return this.health;
    }

    public int getDamage() {
        return this.damage;
    }

    public List<String> getFeedItems() {
        return this.feedItems;
    }

    public String getEntity() {
        return this.entity;
    }
}

