/*
 * Decompiled with CFR 0.152.
 */
package de.julianweinelt.ubm.entities;

import de.julianweinelt.ubm.configuration.ModConfig;
import de.julianweinelt.ubm.items.ModItems;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntityFox
extends EntityAnimal {
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(EntityFox.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation("ubm:textures/entity/fox/fox.png"), new ResourceLocation("ubm:textures/entity/fox/snow_fox.png")};

    public EntityFox(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 0.7f);
        this.field_70728_aV = 1;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 0.5));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
    }

    public IEntityLivingData func_180482_a(@Nonnull DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        super.func_180482_a(difficulty, livingdata);
        int variant = 0;
        if (this.func_130014_f_().func_180494_b(this.func_180425_c()).func_150559_j()) {
            variant = 1;
        }
        this.setVariant(variant);
        return livingdata;
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    public void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    public ResourceLocation getTexture() {
        int variant = this.getVariant();
        if (variant < 0 || variant >= TEXTURES.length) {
            variant = 0;
        }
        return TEXTURES[variant];
    }

    public void func_70014_b(@Nonnull NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
    }

    public void func_70037_a(@Nonnull NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("Variant")) {
            this.setVariant(compound.func_74762_e("Variant"));
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)ModConfig.getEntityConfig("fox").getHealth() / 2.0);
    }

    public boolean func_184652_a(@Nonnull EntityPlayer player) {
        return true;
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == ModItems.SWEET_BERRY;
    }

    public EntityAgeable func_90011_a(@Nullable EntityAgeable ageable) {
        EntityFox child = new EntityFox(this.field_70170_p);
        child.func_70873_a(-24000);
        return child;
    }

    public void func_70636_d() {
        super.func_70636_d();
    }
}

