/*
 * Decompiled with CFR 0.152.
 */
package de.julianweinelt.ubm.entities;

import de.julianweinelt.ubm.configuration.ModConfig;
import de.julianweinelt.ubm.entities.ai.EntityAIEatSlime;
import de.julianweinelt.ubm.entities.ai.EntityAISpontaneousJump;
import de.julianweinelt.ubm.misc.ModSounds;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class EntityFrog
extends EntityAnimal {
    public static final DataParameter<Integer> STATE = EntityDataManager.func_187226_a(EntityFrog.class, (DataSerializer)DataSerializers.field_187192_b);
    private FrogType frogType;
    private int jumpCooldown = 0;
    public Random field_70146_Z = new Random();

    public EntityFrog(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.5f, 0.5f);
        this.field_70728_aV = 1;
        this.updateType(worldIn);
    }

    private void updateType(World world) {
        Biome biome = world.func_180494_b(this.func_180425_c());
        if (biome.func_150561_m().equals((Object)Biome.TempCategory.COLD)) {
            this.setType(FrogType.COOL);
            System.out.println("Frog cool");
        } else if (biome.func_150561_m().equals((Object)Biome.TempCategory.WARM)) {
            this.setType(FrogType.WARM);
        } else {
            this.setType(FrogType.TEMPERATE);
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STATE, (Object)0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.2, Items.field_151123_aH, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.1));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAISpontaneousJump(this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIEatSlime(this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)ModConfig.getEntityConfig("frog").getHealth() / 2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
    }

    public boolean func_184652_a(EntityPlayer player) {
        return true;
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151123_aH;
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return new EntityFrog(this.field_70170_p);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.jumpCooldown > 0) {
            --this.jumpCooldown;
        }
    }

    public boolean canJump() {
        return this.jumpCooldown <= 0;
    }

    public void resetJumpCooldown() {
        this.jumpCooldown = 40 + this.field_70146_Z.nextInt(40);
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return ModSounds.FROG_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return ModSounds.FROG_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.FROG_DEATH;
    }

    public void setType(FrogType type) {
        this.field_70180_af.func_187227_b(STATE, (Object)type.ordinal());
    }

    public FrogType getFrogType() {
        return FrogType.values()[(Integer)this.field_70180_af.func_187225_a(STATE)];
    }

    public static enum FrogType {
        TEMPERATE,
        WARM,
        COOL;

    }
}

