/*
 * Decompiled with CFR 0.152.
 */
package de.julianweinelt.ubm.entities;

import de.julianweinelt.ubm.configuration.ModConfig;
import de.julianweinelt.ubm.entities.ai.EntityAISwimAround;
import java.awt.Color;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateSwimmer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntityTropicalFish
extends EntityWaterMob {
    private static final DataParameter<Integer> MODEL = EntityDataManager.func_187226_a(EntityTropicalFish.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> BASE_COLOR = EntityDataManager.func_187226_a(EntityTropicalFish.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> PATTERN = EntityDataManager.func_187226_a(EntityTropicalFish.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> PATTERN_COLOR = EntityDataManager.func_187226_a(EntityTropicalFish.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityTropicalFish(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.5f, 0.5f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MODEL, (Object)this.field_70146_Z.nextInt(1));
        this.field_70180_af.func_187214_a(BASE_COLOR, (Object)this.getRandomDyeColor().getRGB());
        this.field_70180_af.func_187214_a(PATTERN, (Object)this.field_70146_Z.nextInt(6));
        this.field_70180_af.func_187214_a(PATTERN_COLOR, (Object)this.getRandomDyeColor().getRGB());
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimAround(this, 1.0));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)ModConfig.getEntityConfig("tropicalfish").getHealth() / 2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.0);
    }

    @Nonnull
    protected PathNavigate func_175447_b(@Nonnull World worldIn) {
        return new PathNavigateSwimmer((EntityLiving)this, worldIn);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70090_H()) {
            this.field_70181_x += 0.02;
        } else if (this.field_70122_E) {
            this.field_70181_x += 0.3;
            this.field_70159_w += (this.field_70146_Z.nextDouble() - 0.5) * 0.4;
            this.field_70179_y += (this.field_70146_Z.nextDouble() - 0.5) * 0.4;
        }
    }

    public int getFishModel() {
        return (Integer)this.field_70180_af.func_187225_a(MODEL);
    }

    public void setFishModel(int model) {
        this.field_70180_af.func_187227_b(MODEL, (Object)model);
    }

    public Color getBaseColor() {
        return new Color((Integer)this.field_70180_af.func_187225_a(BASE_COLOR));
    }

    public void setBaseColor(Color color) {
        this.field_70180_af.func_187227_b(BASE_COLOR, (Object)color.getRGB());
    }

    public int getPattern() {
        return (Integer)this.field_70180_af.func_187225_a(PATTERN);
    }

    public void setPattern(int pattern) {
        this.field_70180_af.func_187227_b(PATTERN, (Object)pattern);
    }

    public Color getPatternColor() {
        return new Color((Integer)this.field_70180_af.func_187225_a(PATTERN_COLOR));
    }

    public void setPatternColor(Color color) {
        this.field_70180_af.func_187227_b(PATTERN_COLOR, (Object)color.getRGB());
    }

    public void func_70014_b(@Nonnull NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Model", this.getFishModel());
        compound.func_74768_a("BaseColor", this.getBaseColor().getRGB());
        compound.func_74768_a("Pattern", this.getPattern());
        compound.func_74768_a("PatternColor", this.getPatternColor().getRGB());
    }

    public void func_70037_a(@Nonnull NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setFishModel(compound.func_74762_e("Model"));
        this.setBaseColor(new Color(compound.func_74762_e("BaseColor")));
        this.setPattern(compound.func_74762_e("Pattern"));
        this.setPatternColor(new Color(compound.func_74762_e("PatternColor")));
    }

    public IEntityLivingData func_180482_a(@Nonnull DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        super.func_180482_a(difficulty, livingdata);
        this.setFishModel(this.field_70146_Z.nextBoolean() ? 0 : 1);
        this.setBaseColor(this.getRandomDyeColor());
        this.setPattern(this.field_70146_Z.nextInt(6));
        this.setPatternColor(this.getRandomDyeColor());
        return livingdata;
    }

    private Color getRandomDyeColor() {
        int[][] vanillaColors = new int[][]{{255, 255, 255}, {216, 127, 51}, {178, 76, 216}, {102, 153, 216}, {229, 229, 51}, {127, 204, 25}, {242, 127, 165}, {76, 76, 76}, {153, 153, 153}, {76, 127, 153}, {127, 63, 178}, {51, 76, 178}, {102, 76, 51}, {102, 127, 51}, {153, 51, 51}, {25, 25, 25}};
        int[] rgb = vanillaColors[this.field_70146_Z.nextInt(vanillaColors.length)];
        return new Color(rgb[0], rgb[1], rgb[2]);
    }
}

