/*
 * Decompiled with CFR 0.152.
 */
package de.julianweinelt.ubm.entities;

import de.julianweinelt.ubm.UBM;
import de.julianweinelt.ubm.entities.EntityAxolotl;
import de.julianweinelt.ubm.entities.EntityBambooRaft;
import de.julianweinelt.ubm.entities.EntityBee;
import de.julianweinelt.ubm.entities.EntityCod;
import de.julianweinelt.ubm.entities.EntityDolphin;
import de.julianweinelt.ubm.entities.EntityFox;
import de.julianweinelt.ubm.entities.EntityFrog;
import de.julianweinelt.ubm.entities.EntityGlowSquid;
import de.julianweinelt.ubm.entities.EntityGoat;
import de.julianweinelt.ubm.entities.EntityPhantom;
import de.julianweinelt.ubm.entities.EntityPillager;
import de.julianweinelt.ubm.entities.EntitySalmon;
import de.julianweinelt.ubm.entities.EntityTropicalFish;
import de.julianweinelt.ubm.entities.EntityTurtle;
import de.julianweinelt.ubm.entities.EntityWarden;
import de.julianweinelt.ubm.entities.custom.EntityCustomWolf;
import de.julianweinelt.ubm.entities.custom.EntityNewVillager;
import de.julianweinelt.ubm.entities.models.ModelBee;
import de.julianweinelt.ubm.entities.models.ModelCod;
import de.julianweinelt.ubm.entities.models.ModelDolphin;
import de.julianweinelt.ubm.entities.models.ModelFrog;
import de.julianweinelt.ubm.entities.models.ModelGoat;
import de.julianweinelt.ubm.entities.models.ModelPhantom;
import de.julianweinelt.ubm.entities.models.ModelSalmon;
import de.julianweinelt.ubm.entities.models.ModelTurtle;
import de.julianweinelt.ubm.entities.models.ModelWarden;
import de.julianweinelt.ubm.entities.render.RenderAxolotl;
import de.julianweinelt.ubm.entities.render.RenderBambooRaft;
import de.julianweinelt.ubm.entities.render.RenderCustomWolf;
import de.julianweinelt.ubm.entities.render.RenderFox;
import de.julianweinelt.ubm.entities.render.RenderGlowSquid;
import de.julianweinelt.ubm.entities.render.RenderNewVillager;
import de.julianweinelt.ubm.entities.render.RenderPillager;
import de.julianweinelt.ubm.entities.render.RenderTropicalFish;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.entity.Entity;
import net.minecraft.init.Biomes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="ubm")
public class ModEntities {
    private static int currentID = 1;

    public static void init() {
        ModEntities.register(EntityBee.class, "bee");
        ModEntities.register(EntityFrog.class, "frog");
        ModEntities.register(EntityTurtle.class, "turtle");
        ModEntities.register(EntityGoat.class, "goat");
        ModEntities.register(EntityBambooRaft.class, "bamboo_raft");
        ModEntities.register(EntityWarden.class, "warden");
        ModEntities.register(EntityCustomWolf.class, "custom_wolf");
        ModEntities.register(EntityFox.class, "fox");
        ModEntities.register(EntityDolphin.class, "dolphin");
        ModEntities.register(EntitySalmon.class, "salmon");
        ModEntities.register(EntityCod.class, "cod");
        ModEntities.register(EntityAxolotl.class, "axolotl");
        ModEntities.register(EntityGlowSquid.class, "glow_squid");
        ModEntities.register(EntityTropicalFish.class, "tropical_fish");
        ModEntities.register(EntityPillager.class, "pillager");
        ModEntities.register(EntityPhantom.class, "phantom");
        ModEntities.register(EntityNewVillager.class, "villager");
    }

    private static void register(Class<? extends Entity> clazz, String name) {
        name = name.toLowerCase();
        String entityName = ModEntities.convertName(name);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("ubm", name), clazz, (String)entityName, (int)currentID, (Object)UBM.instance, (int)64, (int)1, (boolean)true);
        ++currentID;
    }

    private static String convertName(String input) {
        StringBuilder sb = new StringBuilder();
        boolean capitalizeNext = true;
        for (char c : input.toCharArray()) {
            if (c == '_') {
                capitalizeNext = true;
                continue;
            }
            if (capitalizeNext) {
                sb.append(Character.toUpperCase(c));
                capitalizeNext = false;
                continue;
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static void addSpawns() {
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerRenders() {
        UBM.getLogger().info("Registering Renderers");
        RenderingRegistry.registerEntityRenderingHandler(EntityBee.class, renderManager -> new RenderLiving<EntityBee>(renderManager, (ModelBase)new ModelBee(), 0.5f){

            protected ResourceLocation getEntityTexture(@Nullable EntityBee entity) {
                if (entity == null) {
                    return new ResourceLocation("ubm", "textures/entity/bee/bee.png");
                }
                if (entity.getBeeState().equals((Object)EntityBee.BeeState.RETURN_TO_NEST)) {
                    return new ResourceLocation("ubm", "textures/entity/bee/bee_nectar.png");
                }
                if (entity.isAggressive()) {
                    return new ResourceLocation("ubm", "textures/entity/bee/bee_angry.png");
                }
                return new ResourceLocation("ubm", "textures/entity/bee/bee.png");
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityFrog.class, renderManager -> new RenderLiving<EntityFrog>(renderManager, (ModelBase)new ModelFrog(), 0.5f){

            protected ResourceLocation getEntityTexture(@Nullable EntityFrog entity) {
                if (entity == null) {
                    return new ResourceLocation("ubm", "textures/entity/frog/temperate_frog.png");
                }
                switch (entity.getFrogType()) {
                    case COOL: {
                        return new ResourceLocation("ubm", "textures/entity/frog/cold_frog.png");
                    }
                    case WARM: {
                        return new ResourceLocation("ubm", "textures/entity/frog/warm_frog.png");
                    }
                }
                return new ResourceLocation("ubm", "textures/entity/frog/temperate_frog.png");
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityTurtle.class, renderManager -> new RenderLiving<EntityTurtle>(renderManager, (ModelBase)new ModelTurtle(), 0.5f){

            protected ResourceLocation getEntityTexture(@Nullable EntityTurtle entity) {
                return new ResourceLocation("ubm", "textures/entity/turtle.png");
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityGoat.class, renderManager -> new RenderLiving<EntityGoat>(renderManager, (ModelBase)new ModelGoat(), 0.5f){

            protected ResourceLocation getEntityTexture(@Nullable EntityGoat entity) {
                return new ResourceLocation("ubm", "textures/entity/goat.png");
            }

            protected void preRenderCallback(@Nonnull EntityGoat entityLivingBaseIn, float partialTickTime) {
                float scale = entityLivingBaseIn.func_70631_g_() ? 0.5f : 1.0f;
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityWarden.class, renderManager -> new RenderLiving<EntityWarden>(renderManager, (ModelBase)new ModelWarden(), 0.5f){

            protected ResourceLocation getEntityTexture(@Nullable EntityWarden entity) {
                return new ResourceLocation("ubm", "textures/entity/warden/warden.png");
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityDolphin.class, renderManager -> new RenderLiving<EntityDolphin>(renderManager, (ModelBase)new ModelDolphin(), 0.5f){

            protected ResourceLocation getEntityTexture(@Nullable EntityDolphin entity) {
                return new ResourceLocation("ubm", "textures/entity/dolphin.png");
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntitySalmon.class, renderManager -> new RenderLiving<EntitySalmon>(renderManager, (ModelBase)new ModelSalmon(), 0.5f){

            protected ResourceLocation getEntityTexture(@Nullable EntitySalmon entity) {
                return new ResourceLocation("ubm", "textures/entity/fish/salmon.png");
            }

            protected void preRenderCallback(@Nonnull EntitySalmon entityLivingBaseIn, float partialTickTime) {
                Random random = entityLivingBaseIn.func_70681_au();
                float min = 0.3f;
                float max = 1.2f;
                float scale = random.nextFloat() * (max - min) + min;
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityCod.class, renderManager -> new RenderLiving<EntityCod>(renderManager, (ModelBase)new ModelCod(), 0.5f){

            protected ResourceLocation getEntityTexture(@Nullable EntityCod entity) {
                return new ResourceLocation("ubm", "textures/entity/fish/cod.png");
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityPhantom.class, renderManager -> new RenderLiving<EntityPhantom>(renderManager, (ModelBase)new ModelPhantom(), 0.5f){

            protected ResourceLocation getEntityTexture(@Nullable EntityPhantom entity) {
                return new ResourceLocation("ubm", "textures/entity/phantom.png");
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityBambooRaft.class, RenderBambooRaft::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityFox.class, RenderFox::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityCustomWolf.class, RenderCustomWolf::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityNewVillager.class, RenderNewVillager::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityAxolotl.class, RenderAxolotl::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityGlowSquid.class, RenderGlowSquid::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityTropicalFish.class, RenderTropicalFish::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityPillager.class, RenderPillager::new);
        UBM.getLogger().info("Registered Renderers");
    }

    @SubscribeEvent
    public void onMobSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (event.getEntity() instanceof EntitySalmon) {
            UBM.getLogger().info("Tried to spawn salmon");
            Biome biome = event.getWorld().func_180494_b(event.getEntity().func_180425_c());
            if (biome != Biomes.field_76771_b && biome != Biomes.field_150575_M && biome != Biomes.field_76781_i) {
                event.setResult(Event.Result.DENY);
            }
        }
    }
}

