/*
 * Decompiled with CFR 0.152.
 */
package de.julianweinelt.ubm.entities.ai;

import de.julianweinelt.ubm.blocks.BlockBeeNest;
import de.julianweinelt.ubm.blocks.ModBlocks;
import de.julianweinelt.ubm.entities.EntityBee;
import de.julianweinelt.ubm.misc.ModSounds;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class EntityAIFlyToFlower
extends EntityAIBase {
    private final EntityBee bee;
    private BlockPos targetFlower;
    private BlockPos nest;
    private final double speed;

    public EntityAIFlyToFlower(EntityBee bee, double speed) {
        this.bee = bee;
        this.speed = speed;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        if (this.bee.func_70681_au().nextInt(20) != 0) {
            return false;
        }
        if (this.bee.getBeeState() == EntityBee.BeeState.SEARCHING_FLOWER) {
            this.targetFlower = this.findNearbyFlower();
            return this.targetFlower != null;
        }
        if (this.bee.getBeeState() == EntityBee.BeeState.RETURN_TO_NEST) {
            if (this.nest == null) {
                this.nest = this.findNest();
                this.bee.setNestPos(this.nest);
            }
            return this.nest != null;
        }
        return false;
    }

    public void func_75249_e() {
        if (this.targetFlower != null && this.bee.getBeeState().equals((Object)EntityBee.BeeState.SEARCHING_FLOWER)) {
            this.bee.func_70661_as().func_75492_a((double)this.targetFlower.func_177958_n() + 0.5, (double)this.targetFlower.func_177956_o() + 1.0, (double)this.targetFlower.func_177952_p() + 0.5, this.speed);
        }
        if (this.nest != null && this.bee.getBeeState().equals((Object)EntityBee.BeeState.RETURN_TO_NEST)) {
            this.bee.func_70661_as().func_75492_a((double)this.nest.func_177958_n() + 0.5, (double)this.nest.func_177956_o() + 1.0, (double)this.nest.func_177952_p() + 0.5, this.speed);
        }
    }

    public void func_75251_c() {
        this.targetFlower = null;
    }

    public void func_75246_d() {
        double speed;
        Vec3d dir;
        if (this.targetFlower != null && this.bee.getBeeState().equals((Object)EntityBee.BeeState.SEARCHING_FLOWER)) {
            dir = new Vec3d((double)this.targetFlower.func_177958_n() + 0.5 - this.bee.field_70165_t, (double)this.targetFlower.func_177956_o() + 0.5 - this.bee.field_70163_u, (double)this.targetFlower.func_177952_p() + 0.5 - this.bee.field_70161_v).func_72432_b();
            speed = 0.1;
            this.bee.field_70159_w = dir.field_72450_a * speed;
            this.bee.field_70181_x = dir.field_72448_b * speed;
            this.bee.field_70179_y = dir.field_72449_c * speed;
        }
        if (this.nest != null && this.bee.getBeeState().equals((Object)EntityBee.BeeState.RETURN_TO_NEST)) {
            dir = new Vec3d((double)this.nest.func_177958_n() + 0.5 - this.bee.field_70165_t, (double)this.nest.func_177956_o() + 0.5 - this.bee.field_70163_u, (double)this.nest.func_177952_p() + 0.5 - this.bee.field_70161_v).func_72432_b();
            speed = 0.1;
            this.bee.field_70159_w = dir.field_72450_a * speed;
            this.bee.field_70181_x = dir.field_72448_b * speed;
            this.bee.field_70179_y = dir.field_72449_c * speed;
        }
        if (this.foundFlower()) {
            this.bee.setState(EntityBee.BeeState.RETURN_TO_NEST);
        }
        this.tryEnterNearbyHive();
    }

    private BlockPos findNearbyFlower() {
        BlockPos beePos = this.bee.func_180425_c();
        int radius = 32;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -8; y <= 8; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos pos = beePos.func_177982_a(x, y, z);
                    IBlockState state = this.bee.field_70170_p.func_180495_p(pos);
                    if (!this.isFlower(state)) continue;
                    return pos;
                }
            }
        }
        return null;
    }

    private boolean foundFlower() {
        BlockPos beePos = this.bee.func_180425_c();
        int radius = 2;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = 0; y <= 2; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos pos = beePos.func_177982_a(x, y, z);
                    IBlockState state = this.bee.field_70170_p.func_180495_p(pos);
                    if (!this.isFlower(state)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void tryEnterNearbyHive() {
        BlockPos beePos = this.bee.func_180425_c();
        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)beePos.func_177982_a(-1, -1, -1), (BlockPos)beePos.func_177982_a(1, 1, 1))) {
            IBlockState state;
            if (pos.equals((Object)beePos) || (state = this.bee.field_70170_p.func_180495_p(pos)).func_177230_c() != ModBlocks.BEE_HIVE && state.func_177230_c() != ModBlocks.BEE_NEST) continue;
            int currentBees = (Integer)state.func_177229_b((IProperty)BlockBeeNest.BEES);
            if (currentBees < 3) {
                this.bee.field_70170_p.func_180501_a(pos, state.func_177226_a((IProperty)BlockBeeNest.BEES, (Comparable)Integer.valueOf(currentBees + 1)), 2);
                this.bee.func_70106_y();
                this.bee.field_70170_p.func_184133_a(null, pos, ModSounds.BEE_HIVE_ENTER, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            return;
        }
    }

    private BlockPos findNest() {
        BlockPos beePos = this.bee.func_180425_c();
        if (this.bee.getNestPos() != null) {
            return this.bee.getNestPos();
        }
        int radius = 32;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -8; y <= 8; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos pos = beePos.func_177982_a(x, y, z);
                    IBlockState state = this.bee.field_70170_p.func_180495_p(pos);
                    if (state.func_177230_c() == ModBlocks.BEE_NEST) {
                        return pos;
                    }
                    if (state.func_177230_c() == ModBlocks.BEE_HIVE) {
                        return pos;
                    }
                    ResourceLocation name = state.func_177230_c().getRegistryName();
                    if (name == null || !name.func_110623_a().contains("bee_")) continue;
                    return pos;
                }
            }
        }
        return null;
    }

    private boolean isFlower(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150328_O || state.func_177230_c() == Blocks.field_150327_N;
    }
}

