/*
 * Decompiled with CFR 0.152.
 */
package de.julianweinelt.ubm.entities.custom;

import de.julianweinelt.ubm.UBM;
import de.julianweinelt.ubm.items.ModItems;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class EntityCustomWolf
extends EntityWolf {
    private boolean hasArmor;
    private ItemStack armorItem = ItemStack.field_190927_a;
    private int textureVariant = this.field_70146_Z.nextInt(7);

    public ItemStack getArmorItem() {
        return this.armorItem;
    }

    public void setArmorItem(ItemStack stack) {
        this.armorItem = stack;
    }

    public EntityCustomWolf(World worldIn) {
        super(worldIn);
    }

    public int getTextureVariant() {
        return this.textureVariant;
    }

    public boolean hasArmor() {
        return this.hasArmor;
    }

    public void setHasArmor(boolean value) {
        this.hasArmor = value;
    }

    public void func_70014_b(@Nonnull NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("TextureVariant", this.textureVariant);
        if (!this.armorItem.func_190926_b()) {
            NBTTagCompound armorNBT = new NBTTagCompound();
            this.armorItem.func_77955_b(armorNBT);
            compound.func_74782_a("ArmorItem", (NBTBase)armorNBT);
        }
    }

    public void func_70037_a(@Nonnull NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.textureVariant = compound.func_74762_e("TextureVariant");
        if (compound.func_74764_b("ArmorItem")) {
            this.armorItem = new ItemStack(compound.func_74775_l("ArmorItem"));
            this.hasArmor = !this.armorItem.func_190926_b();
        }
    }

    public boolean func_184645_a(EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() == ModItems.WOLF_ARMOR) {
            if (!this.func_70909_n()) {
                return false;
            }
            if (!this.hasArmor()) {
                this.setArmorItem(heldItem.func_77946_l());
                this.armorItem.func_190920_e(1);
                this.setHasArmor(true);
                if (!player.field_71075_bZ.field_75098_d) {
                    heldItem.func_190918_g(1);
                }
                this.func_184185_a(SoundEvents.field_187725_r, 1.0f, 1.0f);
                return true;
            }
        }
        if (this.hasArmor() && heldItem.func_77973_b() == Items.field_151097_aZ) {
            if (!player.field_71071_by.func_70441_a(this.getArmorItem())) {
                player.func_71019_a(this.getArmorItem(), false);
            }
            heldItem.func_190918_g(1);
            this.setHasArmor(false);
            this.setArmorItem(ItemStack.field_190927_a);
            this.func_184185_a(SoundEvents.field_187638_cR, 1.0f, 1.0f);
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public boolean func_70097_a(@Nonnull DamageSource damageSrc, float damageAmount) {
        if (!this.hasArmor()) {
            return super.func_70097_a(damageSrc, damageAmount);
        }
        List<DamageSource> blackList = Arrays.asList(DamageSource.field_76380_i, DamageSource.field_76376_m, DamageSource.field_82727_n, DamageSource.field_76368_d);
        if (blackList.contains(damageSrc)) {
            return true;
        }
        EntityLivingBase attacker = null;
        if (damageSrc.func_76346_g() instanceof EntityLivingBase) {
            attacker = (EntityLivingBase)damageSrc.func_76346_g();
        }
        if (attacker == null) {
            return true;
        }
        this.armorItem.func_77972_a((int)damageAmount, attacker);
        UBM.getLogger().info("Armor Damage: " + this.armorItem.func_77952_i());
        if (this.armorItem.func_77952_i() >= this.armorItem.func_77958_k()) {
            this.setArmorItem(ItemStack.field_190927_a);
            this.setHasArmor(false);
            this.func_184185_a(SoundEvents.field_187769_eM, 1.0f, 1.0f);
        }
        return false;
    }
}

