/*
 * Decompiled with CFR 0.152.
 */
package de.julianweinelt.ubm.entities.render;

import de.julianweinelt.ubm.entities.EntityTropicalFish;
import de.julianweinelt.ubm.entities.models.ModelTropicalFishA;
import de.julianweinelt.ubm.entities.models.ModelTropicalFishB;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;

public class RenderTropicalFish
extends RenderLiving<EntityTropicalFish> {
    private static final ResourceLocation MODEL_A_TEXTURE = new ResourceLocation("ubm:textures/entity/fish/tropical_a.png");
    private static final ResourceLocation MODEL_B_TEXTURE = new ResourceLocation("ubm:textures/entity/fish/tropical_b.png");
    private static final ResourceLocation[] PATTERN_TEXTURES_A = new ResourceLocation[]{new ResourceLocation("ubm:textures/entity/fish/tropical_a_pattern_1.png"), new ResourceLocation("ubm:textures/entity/fish/tropical_a_pattern_2.png"), new ResourceLocation("ubm:textures/entity/fish/tropical_a_pattern_3.png"), new ResourceLocation("ubm:textures/entity/fish/tropical_a_pattern_4.png"), new ResourceLocation("ubm:textures/entity/fish/tropical_a_pattern_5.png"), new ResourceLocation("ubm:textures/entity/fish/tropical_a_pattern_6.png")};
    private static final ResourceLocation[] PATTERN_TEXTURES_B = new ResourceLocation[]{new ResourceLocation("ubm:textures/entity/fish/tropical_b_pattern_1.png"), new ResourceLocation("ubm:textures/entity/fish/tropical_b_pattern_2.png"), new ResourceLocation("ubm:textures/entity/fish/tropical_b_pattern_3.png"), new ResourceLocation("ubm:textures/entity/fish/tropical_b_pattern_4.png"), new ResourceLocation("ubm:textures/entity/fish/tropical_b_pattern_5.png"), new ResourceLocation("ubm:textures/entity/fish/tropical_b_pattern_6.png")};
    private final ModelBase modelA = new ModelTropicalFishA();
    private final ModelBase modelB = new ModelTropicalFishB();

    public RenderTropicalFish(RenderManager renderManager) {
        super(renderManager, (ModelBase)new ModelTropicalFishA(), 0.2f);
    }

    protected ResourceLocation getEntityTexture(EntityTropicalFish entity) {
        return entity.getFishModel() == 0 ? MODEL_A_TEXTURE : MODEL_B_TEXTURE;
    }

    public void doRender(EntityTropicalFish entity, double x, double y, double z, float entityYaw, float partialTicks) {
        this.field_77045_g = entity.getFishModel() == 0 ? this.modelA : this.modelB;
        super.func_76986_a((EntityLiving)entity, x, y, z, entityYaw, partialTicks);
    }

    protected int getColorMultiplier(EntityTropicalFish entity, float lightBrightness, float partialTickTime) {
        return entity.getBaseColor().getRGB();
    }

    protected void renderLayers(EntityTropicalFish entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        ResourceLocation[] PATTERN_TEXTURES;
        super.func_177093_a((EntityLivingBase)entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale);
        int patternIndex = entity.getPattern();
        ResourceLocation[] resourceLocationArray = PATTERN_TEXTURES = entity.getFishModel() == 0 ? PATTERN_TEXTURES_A : PATTERN_TEXTURES_B;
        if (patternIndex >= 0 && patternIndex < PATTERN_TEXTURES.length) {
            this.func_110776_a(PATTERN_TEXTURES[patternIndex]);
            int color = entity.getPatternColor().getRGB();
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            GlStateManager.func_179124_c((float)r, (float)g, (float)b);
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            this.field_77045_g.func_78088_a((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            GlStateManager.func_179084_k();
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

