/*
 * Decompiled with CFR 0.152.
 */
package de.julianweinelt.ubm.items;

import de.julianweinelt.ubm.enchantments.ModEnchantments;
import de.julianweinelt.ubm.misc.AdvancementHelper;
import de.julianweinelt.ubm.misc.ModCreativeTabs;
import de.julianweinelt.ubm.misc.ModSounds;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class ItemCrossbow
extends Item {
    public static final ResourceLocation PULL_PROP = new ResourceLocation("pull_custom");

    public ItemCrossbow() {
        this.func_77625_d(1);
        this.func_77656_e(500);
        this.func_77637_a(ModCreativeTabs.UBM_TAB_PILLAGE);
        this.func_185043_a(PULL_PROP, (stack, world, entity) -> {
            if (!(entity instanceof EntityPlayer)) {
                return 0.0f;
            }
            EntityPlayer player = (EntityPlayer)entity;
            if (this.isCharged(stack)) {
                return 1.0f;
            }
            if (!player.func_184587_cr() || player.func_184607_cu() != stack) {
                return 0.0f;
            }
            int useDuration = this.func_77626_a(stack);
            int count = player.func_184605_cv();
            return MathHelper.func_76131_a((float)((float)(useDuration - count) / 20.0f), (float)0.0f, (float)1.0f);
        });
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.isCharged(stack)) {
            this.shoot(world, player, stack);
            AdvancementHelper.grantAdvancement(player, "ol_betsy");
            this.setCharged(stack, false);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, ModSounds.ITEM_CROSSBOW_LOADING_START, SoundCategory.PLAYERS, 1.0f, 1.0f);
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.NONE;
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entity, int timeLeft) {
        if (entity instanceof EntityPlayer) {
            int charge;
            boolean hasQuickCharge = EnchantmentHelper.func_82781_a((ItemStack)stack).containsKey(ModEnchantments.QUICK_CHARGE);
            if (hasQuickCharge) {
                int level = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.QUICK_CHARGE, (ItemStack)stack);
                timeLeft -= level * 5;
            }
            if ((charge = this.func_77626_a(stack) - timeLeft) >= 25) {
                this.setCharged(stack, true);
                world.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, ModSounds.ITEM_CROSSBOW_LOADING_END, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    private void shoot(World world, EntityPlayer player, ItemStack stack) {
        if (!world.field_72995_K) {
            EntityTippedArrow arrow = new EntityTippedArrow(world, (EntityLivingBase)player);
            arrow.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 3.0f, 1.0f);
            world.func_72838_d((Entity)arrow);
            stack.func_77972_a(1, (EntityLivingBase)player);
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, ModSounds.ITEM_CROSSBOW_SHOOT, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
    }

    private boolean isCharged(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74767_n("Charged");
    }

    private void setCharged(ItemStack stack, boolean charged) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74757_a("Charged", charged);
    }
}

