/*
 * Decompiled with CFR 0.152.
 */
package de.julianweinelt.ubm.misc;

import de.julianweinelt.ubm.UBM;
import de.julianweinelt.ubm.blocks.tiles.RenderTileEntityCampfire;
import de.julianweinelt.ubm.blocks.tiles.TileEntityCampfire;
import de.julianweinelt.ubm.entities.ModEntities;
import de.julianweinelt.ubm.misc.ClientEventHandler;
import de.julianweinelt.ubm.misc.CommonProxy;
import de.julianweinelt.ubm.misc.ModModels;
import de.julianweinelt.ubm.qol.SwimClientHandler;
import de.julianweinelt.ubm.trims.LayerArmorTrim;
import de.julianweinelt.ubm.trims.TrimColorHelper;
import de.julianweinelt.ubm.worldgen.WorldTypeModern;
import de.julianweinelt.ubm.worldgen.WorldTypeSelectableBiome;
import de.julianweinelt.ubm.worldgen.structure.village.ModCustomVillage;
import java.awt.Color;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    @Override
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModEntities.registerRenders();
    }

    @Override
    public void init(FMLInitializationEvent e) {
        UBM.getLogger().info("\u2705 ClientProxy init aufgerufen!");
        Map renderMap = Minecraft.func_71410_x().func_175598_ae().field_78729_o;
        ClientProxy.addLayerIfLiving((Render<? extends Entity>)((Render)renderMap.get(EntityZombie.class)));
        ClientProxy.addLayerIfLiving((Render<? extends Entity>)((Render)renderMap.get(EntitySkeleton.class)));
        ClientProxy.addLayerIfLiving((Render<? extends Entity>)((Render)renderMap.get(EntityArmorStand.class)));
        super.init(e);
        for (RenderPlayer renderer : Minecraft.func_71410_x().func_175598_ae().getSkinMap().values()) {
            renderer.func_177094_a((LayerRenderer)new LayerArmorTrim((RenderLivingBase<?>)renderer));
        }
        ClientEventHandler.registerParticles();
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityCampfire.class, (TileEntitySpecialRenderer)new RenderTileEntityCampfire());
        MinecraftForge.EVENT_BUS.register((Object)new SwimClientHandler());
        new WorldTypeSelectableBiome("selectable_biome");
        new WorldTypeModern();
        String basePath = "textures/equipment/trims/color_palettes/";
        for (String material : UBM.colorPalettes) {
            UBM.getLogger().info("Registering color palette: " + material);
            Color[] palette = TrimColorHelper.extractPalette(basePath + material + ".png");
            LayerArmorTrim.MATERIAL_TO_PALETTE.put(material, palette);
        }
        ModCustomVillage.init();
    }

    private static void addLayerIfLiving(Render<? extends Entity> renderer) {
        if (renderer instanceof RenderLivingBase) {
            ((RenderLivingBase)renderer).func_177094_a((LayerRenderer)new LayerArmorTrim((RenderLivingBase)renderer));
        }
    }

    @SubscribeEvent
    public static void onModelRegistry(ModelRegistryEvent event) {
        ModModels.registerAllArmorModels();
    }
}

