/*
 * Decompiled with CFR 0.152.
 */
package de.julianweinelt.ubm.misc;

import de.julianweinelt.ubm.blocks.ModBlocks;
import de.julianweinelt.ubm.items.ItemSpyglass;
import de.julianweinelt.ubm.misc.ModDamageSource;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="ubm")
public class EntityEvents {
    private static float spyglassZoom = 1.0f;

    @SubscribeEvent
    public static void onFovUpdate(FOVUpdateEvent event) {
        boolean active;
        EntityPlayer player = event.getEntity();
        ItemStack stack = player.func_184607_cu();
        boolean bl = active = !stack.func_190926_b() && stack.func_77973_b() instanceof ItemSpyglass;
        spyglassZoom = active ? (spyglassZoom += (0.2f - spyglassZoom) * 0.2f) : (spyglassZoom += (1.0f - spyglassZoom) * 0.2f);
        event.setNewfov(spyglassZoom);
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Post event) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        if (player == null) {
            return;
        }
        ItemStack stack = player.func_184607_cu();
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemSpyglass) {
            mc.func_110434_K().func_110577_a(new ResourceLocation("ubm:textures/gui/spyglass_scope.png"));
            int width = event.getResolution().func_78326_a();
            int height = event.getResolution().func_78328_b();
            GlStateManager.func_179097_i();
            GlStateManager.func_179147_l();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Gui.func_146110_a((int)0, (int)0, (float)0.0f, (float)0.0f, (int)width, (int)height, (float)width, (float)height);
            GlStateManager.func_179084_k();
            GlStateManager.func_179126_j();
        }
    }

    @SubscribeEvent
    public static void onEntityTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer entity = event.player;
        World world = entity.field_70170_p;
        if (world.field_72995_K) {
            return;
        }
        BlockPos pos = new BlockPos(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        BlockPos pos2 = new BlockPos(entity.field_70165_t, entity.field_70163_u + 1.0, entity.field_70161_v);
        if (world.func_180495_p(pos).func_177230_c() == ModBlocks.POWDER_SNOW || world.func_180495_p(pos2).func_177230_c() == ModBlocks.POWDER_SNOW) {
            EntityEvents.applySlowdown((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            int timer;
            EntityPlayer player = event.player;
            BlockPos pos = new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            IBlockState state = player.field_70170_p.func_180495_p(pos);
            if (state.func_177230_c() == ModBlocks.POWDER_SNOW) {
                if (EntityEvents.isWearingLeather(player)) {
                    return;
                }
                player.getEntityData().func_74757_a("inFrozenBlock", true);
                player.getEntityData().func_74776_a("freezeTime", player.getEntityData().func_74760_g("freezeTime") + 0.005f);
            } else {
                if (player.getEntityData().func_74767_n("inFrozenBlock")) {
                    player.getEntityData().func_74776_a("freezeTime", Math.max(0.0f, player.getEntityData().func_74760_g("freezeTime") - 0.05f));
                } else {
                    player.getEntityData().func_74776_a("freezeTime", Math.min(1.0f, player.getEntityData().func_74760_g("freezeTime")));
                }
                if (player.getEntityData().func_74760_g("freezeTime") <= 0.0f) {
                    player.getEntityData().func_74757_a("inFrozenBlock", false);
                }
            }
            if (player.getEntityData().func_74767_n("inFrozenBlock") && (timer = Math.round(player.getEntityData().func_74760_g("freezeTime") * 100.0f)) % 10 == 0) {
                player.func_70097_a(ModDamageSource.frostbite(), 1.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGameOverlayEvent.Pre event) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        if (player != null && player.getEntityData().func_74767_n("inFrozenBlock") && event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            GlStateManager.func_179147_l();
            GlStateManager.func_179141_d();
            mc.func_110434_K().func_110577_a(new ResourceLocation("ubm", "textures/gui/powder_snow_outline.png"));
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)Math.min(1.0f, player.getEntityData().func_74760_g("freezeTime")));
            Gui.func_146110_a((int)0, (int)0, (float)0.0f, (float)0.0f, (int)event.getResolution().func_78326_a(), (int)event.getResolution().func_78328_b(), (float)event.getResolution().func_78326_a(), (float)event.getResolution().func_78328_b());
        }
    }

    public static void onRenderHearts(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.HEALTH) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        if (player == null) {
            return;
        }
        if (!player.getEntityData().func_74767_n("inFrozenBlock")) {
            return;
        }
        event.setCanceled(true);
        int left = 10;
        int top = event.getResolution().func_78328_b() - 39;
        float health = player.func_110143_aJ();
        float maxHealth = player.func_110138_aP();
        int hearts = MathHelper.func_76123_f((float)(maxHealth / 2.0f));
        for (int i = 0; i < hearts; ++i) {
            int x = left + i * 8;
            int y = top;
            if (health >= (float)((i + 1) * 2)) {
                mc.func_110434_K().func_110577_a(new ResourceLocation("ubm:textures/gui/heart/frozen_full.png"));
            } else if (health >= (float)(i * 2 + 1)) {
                mc.func_110434_K().func_110577_a(new ResourceLocation("ubm:textures/gui/heart/frozen_half.png"));
            } else {
                mc.func_110434_K().func_110577_a(new ResourceLocation("ubm:textures/gui/heart/container.png"));
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            mc.field_71456_v.func_73729_b(x, y, 0, 0, 9, 9);
        }
    }

    private static void applySlowdown(Entity entity) {
        entity.field_70159_w *= 0.2;
        entity.field_70179_y *= 0.2;
        entity.field_70181_x *= 0.6;
    }

    private static boolean isWearingLeather(EntityPlayer player) {
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            ItemStack stack;
            if (slot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR || (stack = player.func_184582_a(slot)).func_190926_b() || stack.func_77973_b() != Items.field_151024_Q && stack.func_77973_b() != Items.field_151027_R && stack.func_77973_b() != Items.field_151026_S && stack.func_77973_b() != Items.field_151021_T) continue;
            return true;
        }
        return false;
    }
}

