/*
 * Decompiled with CFR 0.152.
 */
package de.julianweinelt.ubm.misc.client;

import de.julianweinelt.ubm.trims.TrimColorHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.BlockPartRotation;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.model.ITransformation;
import net.minecraftforge.common.model.TRSRTransformation;
import org.lwjgl.util.vector.Vector3f;

public class InventoryTrimRenderer {
    public static void renderTrim(ItemStack stack, float x, float y, float scale) {
        if (stack.func_190926_b() || !stack.func_77942_o()) {
            return;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            return;
        }
        if (!nbt.func_74764_b("trim") || !nbt.func_74764_b("trimMaterial")) {
            return;
        }
        String trim = nbt.func_74779_i("trim");
        String material = nbt.func_74779_i("trimMaterial");
        String type = "";
        if (stack.func_77973_b() instanceof ItemArmor) {
            ItemArmor.ArmorMaterial mat = ((ItemArmor)stack.func_77973_b()).func_82812_d();
            switch (((ItemArmor)stack.func_77973_b()).field_77881_a) {
                case HEAD: {
                    type = "helmet";
                    break;
                }
                case CHEST: {
                    type = "chestplate";
                    break;
                }
                case LEGS: {
                    type = "leggings";
                    break;
                }
                case FEET: {
                    type = "boots";
                }
            }
        }
        ResourceLocation texture = new ResourceLocation("ubm", "textures/trims/items" + type + "_trim.png");
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)100.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        InventoryTrimRenderer.renderQuad();
        GlStateManager.func_179121_F();
    }

    public static void renderQuad() {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(0.0, 16.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b(16.0, 16.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b(16.0, 0.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }

    public static List<BakedQuad> getTrimQuads(ResourceLocation texture) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        ResourceLocation tex = TrimColorHelper.createColoredTrim(texture, TrimColorHelper.extractPalette("textures/equipment/trims/color_palettes/gold.png"));
        Minecraft mc = Minecraft.func_71410_x();
        TextureAtlasSprite sprite = mc.func_147117_R().func_110572_b(texture.toString());
        if (sprite == null) {
            return quads;
        }
        FaceBakery bakery = new FaceBakery();
        BlockPartFace face = new BlockPartFace(null, 0, "", new BlockFaceUV(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0));
        Vector3f from = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f to = new Vector3f(16.0f, 16.0f, 0.0f);
        BlockPartRotation rotation = new BlockPartRotation(new Vector3f(0.0f, 0.0f, 0.0f), EnumFacing.Axis.X, 0.0f, false);
        BakedQuad quad = bakery.makeBakedQuad(from, to, face, sprite, EnumFacing.NORTH, (ITransformation)TRSRTransformation.identity(), rotation, false, true);
        quads.add(quad);
        return quads;
    }
}

