/*
 * Decompiled with CFR 0.152.
 */
package de.julianweinelt.ubm.mixin;

import de.julianweinelt.pathfinder.PathFinderAPI;
import de.julianweinelt.pathfinder.command.Argument;
import de.julianweinelt.pathfinder.command.Command;
import de.julianweinelt.ubm.UBM;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiChat;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiChatWithSuggestions
extends GuiChat {
    private int suggestionIndex = 0;
    private List<String> currentSuggestions = new ArrayList<String>();

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146415_a.func_146195_b(true);
    }

    public void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 208) {
            this.suggestionIndex = Math.max(0, this.suggestionIndex - 1);
            UBM.getLogger().info(this.suggestionIndex + "");
            return;
        }
        if (keyCode == 200) {
            int newIdx = Math.min(this.currentSuggestions.size() - 1, this.suggestionIndex + 1);
            UBM.getLogger().info(newIdx + " (new)");
            this.suggestionIndex = newIdx;
            UBM.getLogger().info(this.suggestionIndex + "");
            return;
        }
        if (keyCode == 15 && !this.currentSuggestions.isEmpty()) {
            String base = this.getBaseCommand();
            UBM.getLogger().info(this.suggestionIndex + "");
            if (this.field_146415_a.func_146179_b().split(" ").length > 1) {
                this.field_146415_a.func_146180_a("/" + base + " " + this.currentSuggestions.get(this.suggestionIndex));
            } else {
                this.field_146415_a.func_146180_a("/" + this.currentSuggestions.get(this.suggestionIndex));
            }
            return;
        }
        super.func_73869_a(typedChar, keyCode);
        this.updateSuggestions();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (this.field_146415_a.func_146179_b().startsWith("/")) {
            this.field_146415_a.func_146193_g(0xA8A8A8);
        } else {
            this.field_146415_a.func_146193_g(0xFFFFFF);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        int x = this.field_146415_a.field_146209_f;
        int y = this.field_146415_a.field_146210_g - 4;
        int lineHeight = this.field_146289_q.field_78288_b + 2;
        int width = 0;
        for (String s : this.currentSuggestions) {
            int w = this.field_146289_q.func_78256_a(s);
            if (w <= width) continue;
            width = w;
        }
        width += 6;
        int height = this.currentSuggestions.size() * lineHeight;
        String suggestion = this.suggestionIndex > this.currentSuggestions.size() - 1 || this.suggestionIndex < 0 ? "" : this.currentSuggestions.get(this.suggestionIndex);
        int cursorPos = this.field_146415_a.func_146198_h();
        String textBeforeCursor = this.field_146415_a.func_146179_b().substring(0, cursorPos);
        String latestArg = textBeforeCursor.split(" ")[textBeforeCursor.split(" ").length - 1];
        int caretX = this.field_146415_a.field_146209_f + this.field_146289_q.func_78256_a(textBeforeCursor);
        int caretY = this.field_146415_a.field_146210_g;
        this.field_146289_q.func_78276_b(suggestion.substring(latestArg.length() > suggestion.length() ? 0 : latestArg.length()), caretX, caretY, 0x545454);
        GuiChatWithSuggestions.func_73734_a((int)(caretX - 2), (int)(y - height), (int)(caretX + width), (int)y, (int)-301989888);
        for (int i = 0; i < this.currentSuggestions.size(); ++i) {
            int color = i == this.suggestionIndex ? 16513876 : 0xA8A8A8;
            this.field_146289_q.func_175063_a(this.currentSuggestions.get(i), (float)caretX, (float)(y - (i + 1) * lineHeight + 1), color);
        }
    }

    private void updateSuggestions() {
        String text = this.field_146415_a.func_146179_b();
        if (!text.startsWith("/")) {
            this.currentSuggestions = new ArrayList<String>();
            this.suggestionIndex = 0;
            return;
        }
        String[] parts = text.substring(1).split(" ");
        if (parts.length == 0) {
            return;
        }
        String base = parts[0];
        boolean newArg = text.endsWith(" ");
        String currentArg = newArg && parts.length > 1 ? "" : parts[parts.length - 1];
        List<String> newSuggestions = parts.length == 1 && !newArg ? this.getCommands(base) : this.getLastArgSuggestions(base, currentArg, text);
        if (!newSuggestions.equals(this.currentSuggestions)) {
            this.currentSuggestions = new ArrayList<String>(newSuggestions);
            this.suggestionIndex = this.currentSuggestions.size() - 1;
        }
    }

    private List<String> getCommands() {
        ArrayList<String> commands = new ArrayList<String>();
        for (String s : PathFinderAPI.commandRegistry.getCommandMap().keySet()) {
            for (Command c : (List)PathFinderAPI.commandRegistry.getCommandMap().get(s)) {
                commands.add(c.getName());
            }
        }
        commands.sort(Collections.reverseOrder());
        return commands;
    }

    private List<String> getCommands(String input) {
        ArrayList<String> commands = new ArrayList<String>();
        for (String s : PathFinderAPI.commandRegistry.getCommandMap().keySet()) {
            for (Command c : (List)PathFinderAPI.commandRegistry.getCommandMap().get(s)) {
                if (!c.getName().startsWith(input)) continue;
                commands.add(c.getName());
            }
        }
        commands.sort(Collections.reverseOrder());
        return commands;
    }

    private List<String> getLastArgSuggestions(String command, String input, String fullText) {
        Command cmd = PathFinderAPI.getCommandRegistry().getCommand("minecraft", command);
        if (cmd == null) {
            UBM.getLogger().warn("CMD is null");
            return new ArrayList<String>();
        }
        String[] args = fullText.substring(1).split(" ");
        List availableArgs = cmd.getArgs();
        Argument current = null;
        for (int i = 1; i < args.length; ++i) {
            String argInput = args[i];
            Argument match = null;
            for (Argument candidate : availableArgs) {
                if (candidate == null || !argInput.isEmpty() && !candidate.matches(argInput)) continue;
                match = candidate;
                break;
            }
            if (match == null) break;
            current = match;
            availableArgs = current.getArgs();
        }
        ArrayList<String> suggestions = new ArrayList<String>();
        if (current != null && current.getSuggestions() != null) {
            for (String s : current.getSuggestions()) {
                if (!s.toLowerCase().startsWith(input.toLowerCase())) continue;
                suggestions.add(s);
            }
        }
        for (Argument candidate : availableArgs) {
            if (candidate.getSuggestions() != null) {
                for (String suggestion : candidate.getSuggestions()) {
                    if (!suggestion.toLowerCase().startsWith(input.toLowerCase())) continue;
                    suggestions.add(suggestion);
                }
            }
            suggestions.add(candidate.getName());
            if (candidate.getSuggestion_type() == null || Objects.equals(candidate.getSuggestion_type(), "list") || Objects.equals(candidate.getSuggestion_type(), "custom")) continue;
            suggestions.addAll(PathFinderAPI.getSuggestionTypeEntries((String)candidate.getSuggestion_type(), null));
        }
        Collections.sort(suggestions);
        return suggestions;
    }

    private String getBaseCommand() {
        String text = this.field_146415_a.func_146179_b();
        if (text.startsWith("/")) {
            String[] parts = text.substring(1).split(" ");
            return parts[0];
        }
        return "";
    }
}

