/*
 * Decompiled with CFR 0.152.
 */
package de.julianweinelt.ubm.trims;

import de.julianweinelt.ubm.trims.TrimColorHelper;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerBipedArmor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class LayerArmorTrim
extends LayerBipedArmor {
    public static final Map<String, Color[]> MATERIAL_TO_PALETTE = new HashMap<String, Color[]>();
    private final RenderLivingBase<?> renderer;
    private static final Map<String, ResourceLocation> TRIM_CACHE = new HashMap<String, ResourceLocation>();

    public LayerArmorTrim(RenderLivingBase<?> renderer) {
        super(renderer);
        this.renderer = renderer;
    }

    protected void func_177177_a() {
        this.field_177189_c = new ModelBiped(0.5f);
        this.field_177186_d = new ModelBiped(1.0f);
    }

    public void func_177141_a(@Nonnull EntityLivingBase entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            NBTTagCompound trim;
            ItemStack stack;
            if (slot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR || (stack = entity.func_184582_a(slot)).func_190926_b() || !stack.func_77942_o() || (trim = stack.func_77978_p()) == null) continue;
            String pattern = trim.func_74779_i("trim").isEmpty() ? "tide" : trim.func_74779_i("trim");
            String material = trim.func_74779_i("trimMaterial").isEmpty() ? "emerald" : trim.func_74779_i("trimMaterial");
            String overlayPath = slot == EntityEquipmentSlot.LEGS ? "textures/equipment/trims/entity/humanoid_leggings/" + pattern + ".png" : "textures/equipment/trims/entity/humanoid/" + pattern + ".png";
            Color[] palette = MATERIAL_TO_PALETTE.getOrDefault(material.toLowerCase(), null);
            if (palette == null) continue;
            ModelBiped model = slot == EntityEquipmentSlot.LEGS ? (ModelBiped)this.field_177189_c : (ModelBiped)this.field_177186_d;
            model.func_178686_a(this.renderer.func_177087_b());
            this.setupVisibilityForSlot(model, slot);
            ResourceLocation coloredTrim = TrimColorHelper.createColoredTrim(overlayPath, palette);
            if (coloredTrim == null) continue;
            GlStateManager.func_179094_E();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.renderer.func_110776_a(coloredTrim);
            model.func_78088_a((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            GlStateManager.func_179121_F();
        }
    }

    private ResourceLocation getOrCreateTrim(String pattern, String material) {
        String key = pattern + "_" + material;
        if (TRIM_CACHE.containsKey(key)) {
            return TRIM_CACHE.get(key);
        }
        String overlayPath = "textures/equipment/troms/entity/humanoid/" + pattern + ".png";
        Color[] palette = MATERIAL_TO_PALETTE.get(material);
        if (palette == null) {
            return null;
        }
        ResourceLocation res = TrimColorHelper.createColoredTrim(overlayPath, palette);
        TRIM_CACHE.put(key, res);
        return res;
    }

    private void setupVisibilityForSlot(ModelBiped model, EntityEquipmentSlot slot) {
        model.field_78116_c.field_78806_j = false;
        model.field_178720_f.field_78806_j = false;
        model.field_78115_e.field_78806_j = false;
        model.field_178723_h.field_78806_j = false;
        model.field_178724_i.field_78806_j = false;
        model.field_178721_j.field_78806_j = false;
        model.field_178722_k.field_78806_j = false;
        switch (slot) {
            case HEAD: {
                model.field_78116_c.field_78806_j = true;
                model.field_178720_f.field_78806_j = true;
                break;
            }
            case CHEST: {
                model.field_78115_e.field_78806_j = true;
                model.field_178723_h.field_78806_j = true;
                model.field_178724_i.field_78806_j = true;
                break;
            }
            case LEGS: {
                model.field_178721_j.field_78806_j = true;
                model.field_178722_k.field_78806_j = true;
                break;
            }
            case FEET: {
                model.field_178721_j.field_78806_j = true;
                model.field_178722_k.field_78806_j = true;
                break;
            }
        }
    }
}

